/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.transform;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import org.springframework.util.Assert;
import org.springframework.xml.JaxpVersion;
import org.springframework.xml.transform.StaxResult;
import org.springframework.xml.transform.StaxSource;

public abstract class TraxUtils {
    static /* synthetic */ Class class$javax$xml$transform$stax$StAXSource;
    static /* synthetic */ Class class$javax$xml$transform$stax$StAXResult;

    public static boolean isStaxSource(Source source) {
        if (source instanceof StaxSource) {
            return true;
        }
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.isStaxSource(source);
        }
        return false;
    }

    public static boolean isStaxResult(Result result) {
        if (result instanceof StaxResult) {
            return true;
        }
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.isStaxResult(result);
        }
        return false;
    }

    public static XMLStreamReader getXMLStreamReader(Source source) {
        if (source instanceof StaxSource) {
            return ((StaxSource)source).getXMLStreamReader();
        }
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.getXMLStreamReader(source);
        }
        throw new IllegalArgumentException("Source '" + source + "' is neither StaxSource nor StAXSource");
    }

    public static XMLEventReader getXMLEventReader(Source source) {
        if (source instanceof StaxSource) {
            return ((StaxSource)source).getXMLEventReader();
        }
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.getXMLEventReader(source);
        }
        throw new IllegalArgumentException("Source '" + source + "' is neither StaxSource nor StAXSource");
    }

    public static XMLStreamWriter getXMLStreamWriter(Result result) {
        if (result instanceof StaxResult) {
            return ((StaxResult)result).getXMLStreamWriter();
        }
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.getXMLStreamWriter(result);
        }
        throw new IllegalArgumentException("Result '" + result + "' is neither StaxResult nor StAXResult");
    }

    public static XMLEventWriter getXMLEventWriter(Result result) {
        if (result instanceof StaxResult) {
            return ((StaxResult)result).getXMLEventWriter();
        }
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.getXMLEventWriter(result);
        }
        throw new IllegalArgumentException("Result '" + result + "' is neither StaxResult nor StAXResult");
    }

    public static Source createStaxSource(XMLStreamReader streamReader) {
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.createStaxSource(streamReader);
        }
        return new StaxSource(streamReader);
    }

    public static Source createStaxSource(XMLEventReader eventReader) throws XMLStreamException {
        if (JaxpVersion.isAtLeastJaxp14()) {
            return Jaxp14StaxHandler.createStaxSource(eventReader);
        }
        return new StaxSource(eventReader);
    }

    private static class Jaxp14StaxHandler {
        private Jaxp14StaxHandler() {
        }

        private static Source createStaxSource(XMLStreamReader streamReader) {
            return new StAXSource(streamReader);
        }

        private static Source createStaxSource(XMLEventReader eventReader) throws XMLStreamException {
            return new StAXSource(eventReader);
        }

        private static boolean isStaxSource(Source source) {
            return source instanceof StAXSource;
        }

        private static boolean isStaxResult(Result result) {
            return result instanceof StAXResult;
        }

        private static XMLStreamReader getXMLStreamReader(Source source) {
            Assert.isInstanceOf(class$javax$xml$transform$stax$StAXSource == null ? (class$javax$xml$transform$stax$StAXSource = TraxUtils.class$("javax.xml.transform.stax.StAXSource")) : class$javax$xml$transform$stax$StAXSource, source);
            return ((StAXSource)source).getXMLStreamReader();
        }

        private static XMLEventReader getXMLEventReader(Source source) {
            Assert.isInstanceOf(class$javax$xml$transform$stax$StAXSource == null ? (class$javax$xml$transform$stax$StAXSource = TraxUtils.class$("javax.xml.transform.stax.StAXSource")) : class$javax$xml$transform$stax$StAXSource, source);
            return ((StAXSource)source).getXMLEventReader();
        }

        private static XMLStreamWriter getXMLStreamWriter(Result result) {
            Assert.isInstanceOf(class$javax$xml$transform$stax$StAXResult == null ? (class$javax$xml$transform$stax$StAXResult = TraxUtils.class$("javax.xml.transform.stax.StAXResult")) : class$javax$xml$transform$stax$StAXResult, result);
            return ((StAXResult)result).getXMLStreamWriter();
        }

        private static XMLEventWriter getXMLEventWriter(Result result) {
            Assert.isInstanceOf(class$javax$xml$transform$stax$StAXResult == null ? (class$javax$xml$transform$stax$StAXResult = TraxUtils.class$("javax.xml.transform.stax.StAXResult")) : class$javax$xml$transform$stax$StAXResult, result);
            return ((StAXResult)result).getXMLEventWriter();
        }
    }
}

