/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.ArrayFloatList;
import org.apache.commons.collections.primitives.FloatIterator;
import org.apache.commons.collections.primitives.FloatList;
import org.apache.commons.collections.primitives.FloatListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableFloatIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableFloatList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableFloatListIterator;

public final class FloatCollections {
    public static final FloatList EMPTY_FLOAT_LIST = FloatCollections.unmodifiableFloatList(new ArrayFloatList(0));
    public static final FloatIterator EMPTY_FLOAT_ITERATOR = FloatCollections.unmodifiableFloatIterator(EMPTY_FLOAT_LIST.iterator());
    public static final FloatListIterator EMPTY_FLOAT_LIST_ITERATOR = FloatCollections.unmodifiableFloatListIterator(EMPTY_FLOAT_LIST.listIterator());

    public static FloatList singletonFloatList(float value) {
        ArrayFloatList list = new ArrayFloatList(1);
        list.add(value);
        return UnmodifiableFloatList.wrap((FloatList)list);
    }

    public static FloatIterator singletonFloatIterator(float value) {
        return FloatCollections.singletonFloatList(value).iterator();
    }

    public static FloatListIterator singletonFloatListIterator(float value) {
        return FloatCollections.singletonFloatList(value).listIterator();
    }

    public static FloatList unmodifiableFloatList(FloatList list) throws NullPointerException {
        if (null == list) {
            throw new NullPointerException();
        }
        return UnmodifiableFloatList.wrap((FloatList)list);
    }

    public static FloatIterator unmodifiableFloatIterator(FloatIterator iter) {
        if (null == iter) {
            throw new NullPointerException();
        }
        return UnmodifiableFloatIterator.wrap((FloatIterator)iter);
    }

    public static FloatListIterator unmodifiableFloatListIterator(FloatListIterator iter) {
        if (null == iter) {
            throw new NullPointerException();
        }
        return UnmodifiableFloatListIterator.wrap((FloatListIterator)iter);
    }

    public static FloatList getEmptyFloatList() {
        return EMPTY_FLOAT_LIST;
    }

    public static FloatIterator getEmptyFloatIterator() {
        return EMPTY_FLOAT_ITERATOR;
    }

    public static FloatListIterator getEmptyFloatListIterator() {
        return EMPTY_FLOAT_LIST_ITERATOR;
    }
}

