/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.io.Serializable;
import java.util.StringTokenizer;

public class Version
implements Comparable,
Serializable {
    private static final long serialVersionUID = 7941704456058067109L;
    private Integer majorVersion;
    private Integer minorVersion;
    private Integer incrementalVersion;
    private Integer buildNumber;
    private String qualifier;

    public Version(String version) {
        this.parseVersion(version);
    }

    public int compareTo(Object o) {
        Version otherVersion = (Version)o;
        int result = this.compareIntegers(this.majorVersion, otherVersion.majorVersion);
        if (result == 0) {
            result = this.compareIntegers(this.minorVersion, otherVersion.minorVersion);
        }
        if (result == 0) {
            result = this.compareIntegers(this.incrementalVersion, otherVersion.incrementalVersion);
        }
        if (result == 0) {
            if (this.buildNumber != null || otherVersion.buildNumber != null) {
                result = this.compareIntegers(this.buildNumber, otherVersion.buildNumber);
            } else if (this.qualifier != null) {
                result = otherVersion.qualifier != null ? (this.qualifier.length() > otherVersion.qualifier.length() && this.qualifier.startsWith(otherVersion.qualifier) ? -1 : (this.qualifier.length() < otherVersion.qualifier.length() && otherVersion.qualifier.startsWith(this.qualifier) ? 1 : this.qualifier.compareTo(otherVersion.qualifier))) : -1;
            } else if (otherVersion.qualifier != null) {
                result = 1;
            }
        }
        return result;
    }

    private int compareIntegers(Integer i1, Integer i2) {
        if (i1 == null ? i2 == null : i1.equals(i2)) {
            return 0;
        }
        if (i1 == null) {
            return -i2.intValue();
        }
        if (i2 == null) {
            return i1;
        }
        return i1 - i2;
    }

    public int getMajorVersion() {
        return this.majorVersion != null ? this.majorVersion : 0;
    }

    public int getMinorVersion() {
        return this.minorVersion != null ? this.minorVersion : 0;
    }

    public int getIncrementalVersion() {
        return this.incrementalVersion != null ? this.incrementalVersion : 0;
    }

    public int getBuildNumber() {
        return this.buildNumber != null ? this.buildNumber : 0;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public final void parseVersion(String version) {
        String part1;
        int index = version.indexOf("-");
        String part2 = null;
        if (index < 0) {
            part1 = version;
        } else {
            part1 = version.substring(0, index);
            part2 = version.substring(index + 1);
        }
        if (part2 != null) {
            try {
                if (part2.length() == 1 || !part2.startsWith("0")) {
                    this.buildNumber = Integer.valueOf(part2);
                } else {
                    this.qualifier = part2;
                }
            }
            catch (NumberFormatException e) {
                this.qualifier = part2;
            }
        }
        if (part1.indexOf(".") < 0 && !part1.startsWith("0")) {
            try {
                this.majorVersion = Integer.valueOf(part1);
            }
            catch (NumberFormatException e) {
                this.qualifier = version;
                this.buildNumber = null;
            }
        } else {
            boolean fallback = false;
            StringTokenizer tok = new StringTokenizer(part1, ".");
            try {
                this.majorVersion = Version.getNextIntegerToken(tok);
                if (tok.hasMoreTokens()) {
                    this.minorVersion = Version.getNextIntegerToken(tok);
                }
                if (tok.hasMoreTokens()) {
                    this.incrementalVersion = Version.getNextIntegerToken(tok);
                }
                if (tok.hasMoreTokens()) {
                    fallback = true;
                }
            }
            catch (NumberFormatException e) {
                fallback = true;
            }
            if (fallback) {
                this.qualifier = version;
                this.majorVersion = null;
                this.minorVersion = null;
                this.incrementalVersion = null;
            }
        }
    }

    private static Integer getNextIntegerToken(StringTokenizer tok) {
        String s = tok.nextToken();
        if (s.length() > 1 && s.startsWith("0")) {
            throw new NumberFormatException("Number part has a leading 0: '" + s + "'");
        }
        return Integer.valueOf(s);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.majorVersion != null) {
            buf.append(this.majorVersion);
        }
        if (this.minorVersion != null) {
            buf.append(".");
            buf.append(this.minorVersion);
        }
        if (this.incrementalVersion != null) {
            buf.append(".");
            buf.append(this.incrementalVersion);
        }
        if (this.buildNumber != null) {
            buf.append("-");
            buf.append(this.buildNumber);
        } else if (this.qualifier != null) {
            if (buf.length() > 0) {
                buf.append("-");
            }
            buf.append(this.qualifier);
        }
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Version v = (Version)other;
        if (this.majorVersion == null ? v.majorVersion != null : !this.majorVersion.equals(v.majorVersion)) {
            return false;
        }
        if (this.minorVersion == null ? v.minorVersion != null : !this.minorVersion.equals(v.minorVersion)) {
            return false;
        }
        if (this.incrementalVersion == null ? v.incrementalVersion != null : !this.incrementalVersion.equals(v.incrementalVersion)) {
            return false;
        }
        if (this.buildNumber == null ? v.buildNumber != null : !this.buildNumber.equals(v.buildNumber)) {
            return false;
        }
        return this.qualifier == null ? v.qualifier == null : this.qualifier.equals(v.qualifier);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.majorVersion != null) {
            hashCode = this.majorVersion;
        }
        if (this.minorVersion != null) {
            hashCode = 37 * hashCode + this.minorVersion;
        }
        if (this.incrementalVersion != null) {
            hashCode = 37 * hashCode + this.incrementalVersion;
        }
        if (this.buildNumber != null) {
            hashCode = 37 * hashCode + this.buildNumber;
        }
        if (this.qualifier != null) {
            hashCode = 37 * hashCode + this.qualifier.hashCode();
        }
        return hashCode;
    }
}

