/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.InternPool;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.CompositeUnaryFunction;
import org.apache.ode.utils.stl.EqualsUnaryFunction;
import org.apache.ode.utils.stl.FilterIterator;
import org.apache.ode.utils.stl.TransformIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSContext
implements NamespaceContext,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(NSContext.class);
    private HashMap<String, String> _prefixToUriMap = new HashMap<String, String>(){

        @Override
        public String put(String prefix, String uri) {
            prefix = (String)InternPool.intern("namespace.prefixes", prefix);
            uri = (String)InternPool.intern("namespace.uris", uri);
            return super.put(prefix, uri);
        }
    };

    public NSContext() {
    }

    public NSContext(NSContext map) {
        this._prefixToUriMap.putAll(map._prefixToUriMap);
    }

    @Override
    public String getNamespaceURI(String prefix) throws NSContextException {
        if (prefix == null) {
            return this._prefixToUriMap.get("");
        }
        String nsURI = this._prefixToUriMap.get(prefix);
        if (nsURI != null) {
            return nsURI;
        }
        String errorMsg = "Namespace not found for prefix \"" + prefix + "\"";
        throw new NSContextException(errorMsg);
    }

    @Override
    public String getPrefix(String uri) {
        Iterator i = this.getPrefixes(uri);
        if (i.hasNext()) {
            return (String)i.next();
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        return new TransformIterator<Map.Entry, Object>(new FilterIterator<Map.Entry<String, String>>(this._prefixToUriMap.entrySet().iterator(), new CompositeUnaryFunction(new EqualsUnaryFunction<String>(uri), CollectionsX.ufnMapEntry_getValue)), CollectionsX.ufnMapEntry_getKey);
    }

    public Set<String> getPrefixes() {
        return Collections.unmodifiableSet(this._prefixToUriMap.keySet());
    }

    public Set<String> getUriSet() {
        return new HashSet<String>(this._prefixToUriMap.values());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int numKeys = in.readInt();
        for (int i = 0; i < numKeys; ++i) {
            String prefix = in.readUTF();
            String uri = in.readUTF();
            this._prefixToUriMap.put(prefix, uri);
        }
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("readExternal: contents=" + this._prefixToUriMap));
        }
    }

    public void register(String prefix, String uri) {
        if (uri == null) {
            uri = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("register(prefix=" + prefix + ", uri=" + uri + ")"));
        }
        this._prefixToUriMap.put(prefix, uri);
    }

    public void register(Map<String, String> prefixMapping) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("register(prefixmappings=" + prefixMapping + ")"));
        }
        this._prefixToUriMap.putAll(prefixMapping);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("writeExternal: contents=" + this._prefixToUriMap));
        }
        out.writeInt(this._prefixToUriMap.size());
        for (Map.Entry<String, String> me : this._prefixToUriMap.entrySet()) {
            out.writeUTF(me.getKey());
            out.writeUTF(me.getValue());
        }
    }

    public QName derefQName(String qname) throws NSContextException {
        String uri;
        if (qname == null) {
            return null;
        }
        int idx = qname.indexOf(58);
        if (idx == -1) {
            try {
                return new QName(this.getNamespaceURI(null), qname);
            }
            catch (NSContextException nsEx) {
                return null;
            }
        }
        String prefix = qname.substring(0, idx);
        String localname = qname.substring(idx + 1);
        try {
            uri = this.getNamespaceURI(prefix);
        }
        catch (NSContextException nsEx) {
            nsEx.setErrorMsg("Namespace not found for prefix in " + prefix);
            throw nsEx;
        }
        return new QName(uri, localname);
    }

    public Map<String, String> toMap() {
        return Collections.unmodifiableMap(this._prefixToUriMap);
    }

    public boolean equals(Object b) {
        if (b instanceof NSContext) {
            return this._prefixToUriMap.equals(((NSContext)b)._prefixToUriMap);
        }
        return false;
    }

    public class NSContextException
    extends RuntimeException {
        private String errorMsg;

        public NSContextException(String msg, Throwable cause) {
            super(msg, cause);
            this.errorMsg = msg;
        }

        public NSContextException(String msg) {
            super(msg);
            this.errorMsg = msg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }
    }
}

