/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jca.server.rmi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.apache.ode.jca.server.Interaction;
import org.apache.ode.jca.server.rmi.RmiTransportServerImpl;
import org.apache.ode.ra.transports.rmi.OdeTransportPipeRemote;
import org.apache.ode.utils.Reflect;

class RmiPipeServerImpl
implements OdeTransportPipeRemote {
    private RmiTransportServerImpl _server;
    private String[] _connectionClass;
    private HashMap<String, Method> _methodMap = new HashMap();
    final long createTime;
    long lastActivityTime = this.createTime = System.currentTimeMillis();
    OdeTransportPipeRemote remote;
    Object target;
    private WeakHashMap<Object, RmiPipeServerImpl> _interactions = new WeakHashMap();

    public RmiPipeServerImpl(RmiTransportServerImpl server, Object target, String[] connectionClass) {
        this._server = server;
        this._connectionClass = connectionClass;
        ArrayList<String> connectionClassNames = new ArrayList<String>();
        for (String cn : connectionClass) {
            connectionClassNames.add(cn);
        }
        for (Class<?> i : target.getClass().getInterfaces()) {
            for (Method m : i.getMethods()) {
                this._methodMap.put(Reflect.generateMethodSignature(m), m);
            }
        }
        this.target = target;
    }

    public void close() {
        this._server.pipeClosed(this);
        this.remote = null;
    }

    public String[] getConnectionClassNames() {
        return this._connectionClass;
    }

    public Object invokeConnectionMethod(String name, Object[] args) throws RemoteException, InvocationTargetException {
        this.lastActivityTime = System.currentTimeMillis();
        Method m = this._methodMap.get(name);
        if (m == null) {
            throw new RemoteException("Unknown method: " + name);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Object ret = m.invoke(this.target, args);
            if (ret != null && ret instanceof Interaction) {
                RmiPipeServerImpl remoteProxy = this._interactions.get(ret);
                if (remoteProxy != null) {
                    RmiPipeServerImpl rmiPipeServerImpl = remoteProxy;
                    return rmiPipeServerImpl;
                }
                Class<?>[] interfaces = ret.getClass().getInterfaces();
                String[] inames = new String[interfaces.length];
                for (int i = 0; i < interfaces.length; ++i) {
                    inames[i] = interfaces[i].getName();
                }
                remoteProxy = new RmiPipeServerImpl(this._server, ret, inames);
                this._interactions.put(ret, remoteProxy);
                RmiPipeServerImpl rmiPipeServerImpl = remoteProxy;
                return rmiPipeServerImpl;
            }
            Object object = ret;
            return object;
        }
        catch (IllegalArgumentException e) {
            throw new RemoteException("Illegal Argument", e);
        }
        catch (IllegalAccessException e) {
            throw new RemoteException("Illegal Access", e);
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

