/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.JacobObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChannelListener<CT extends Channel>
extends JacobObject {
    private static Log __log = LogFactory.getLog(ChannelListener.class);
    private transient Set<Method> _implementedMethods;
    private transient CT _channel;

    protected ChannelListener(CT channel) throws IllegalStateException {
        assert (this.getClass().getSuperclass().getSuperclass() == ChannelListener.class) : "Inheritance in ChannelListener classes not allowed!";
        if (channel == null) {
            throw new IllegalArgumentException("Null channel!");
        }
        this._channel = channel;
    }

    public CT getChannel() {
        return this._channel;
    }

    public void setChannel(CT channel) {
        this._channel = channel;
    }

    public Set<ChannelListener> or(ChannelListener other) {
        HashSet<ChannelListener> retval = new HashSet<ChannelListener>();
        retval.add(this);
        retval.add(other);
        return retval;
    }

    public Set<ChannelListener> or(Set<ChannelListener> other) {
        HashSet<ChannelListener> retval = new HashSet<ChannelListener>(other);
        retval.add(this);
        return retval;
    }

    @Override
    public Set<Method> getImplementedMethods() {
        if (this._implementedMethods == null) {
            HashSet<Method> implementedMethods = new HashSet<Method>();
            ChannelListener.getImplementedMethods(implementedMethods, this.getClass().getSuperclass());
            this._implementedMethods = Collections.unmodifiableSet(implementedMethods);
        }
        return this._implementedMethods;
    }

    private static Set<Method> getImplementedMethods(Set<Method> methods, Class clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i] == Channel.class) continue;
            Method[] allmethods = interfaces[i].getDeclaredMethods();
            for (int j = 0; j < allmethods.length; ++j) {
                methods.add(allmethods[j]);
            }
            ChannelListener.getImplementedMethods(methods, interfaces[i]);
        }
        return methods;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClassName());
        buf.append('{');
        for (Method m : this.getImplementedMethods()) {
            buf.append(m.getName());
            buf.append("()");
            buf.append("&");
        }
        buf.setLength(buf.length() - 1);
        buf.append('}');
        return buf.toString();
    }

    protected Log log() {
        return __log;
    }
}

