/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.extension.longrunning;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.dd.DeployDocument;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.dd.TInvoke;
import org.apache.ode.bpel.dd.TProvide;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.extension.AbstractLongRunningExtensionOperation;
import org.apache.ode.bpel.runtime.extension.ExtensionContext;
import org.apache.ode.extension.longrunning.LongRunningExtensionBundle;
import org.apache.ode.store.DeploymentUnitDir;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LongRunningExtensionOperation
extends AbstractLongRunningExtensionOperation {
    private static Log log = LogFactory.getLog(AbstractLongRunningExtensionOperation.class);
    private ExtensionContext extensionContext;
    private String[] correlationValues;
    private String cid;
    LongRunningActivity longRunningActivity;

    public void runAsync(ExtensionContext context, String cid, Element element) throws FaultException {
        this.extensionContext = context;
        this.cid = cid;
        this.longRunningActivity = new LongRunningActivity(element);
        ServiceClient sender = null;
        String corId = null;
        try {
            Element inputEle = (Element)context.readVariable(this.longRunningActivity.getInputVariable());
            Node inputNode = inputEle.getFirstChild().getFirstChild();
            String inputStr = DOMUtils.domToString(inputNode);
            OMElement payload = AXIOMUtil.stringToOM((String)inputStr);
            EndpointReference targetEPR = new EndpointReference(this.longRunningActivity.getServiceEPR());
            Options options = new Options();
            options.setTo(targetEPR);
            options.setAction("urn:approve");
            sender = null;
            sender = new ServiceClient();
            sender.setOptions(options);
            OMElement response = sender.sendReceive(payload);
            corId = this.getCorrelationValue(response);
            if (corId == null) {
                log.error((Object)"Correlation value is null");
                throw new FaultException(new QName(LongRunningExtensionBundle.NS, "Correlation value is null"));
            }
        }
        catch (Exception e) {
            throw new FaultException(new QName(LongRunningExtensionBundle.NS, "LongRunningExtension"), (Throwable)e);
        }
        finally {
            if (sender != null) {
                try {
                    sender.cleanupTransport();
                }
                catch (AxisFault axisFault) {
                    axisFault.printStackTrace();
                    log.warn((Object)"Unable to release http connections");
                }
            }
        }
        this.correlationValues = new String[]{corId};
        context.setCorrelationValues(this.correlationValues);
        String correlatorId = this.genCorrelatorId();
        if (correlatorId == null) {
            throw new FaultException(new QName(LongRunningExtensionBundle.NS, "Null correlatorId"));
        }
        context.setCorrelatorId(correlatorId);
    }

    private String getCorrelationValue(OMElement response) {
        if (!response.getQName().equals(new QName(null, "part"))) {
            return null;
        }
        OMElement hifb = response.getFirstChildWithName(new QName("http://wso2.org/humantask/feedback", "HIFeedback"));
        if (hifb == null) {
            return null;
        }
        OMElement taskIDele = hifb.getFirstChildWithName(new QName("http://wso2.org/humantask/feedback", "TaskID"));
        if (taskIDele == null) {
            return null;
        }
        return taskIDele.getText();
    }

    private String genCorrelatorId() throws FaultException {
        String operation = this.longRunningActivity.getResponseOperation();
        PartnerLinkInstance plink = this.extensionContext.getPartnerLinkInstance(this.longRunningActivity.getPartnerLink());
        return plink.partnerLink.getName() + "." + operation;
    }

    public void onRequestReceived(String mexId) throws FaultException {
        _log.info((Object)"Response received");
        Element notificationMessageEle = this.extensionContext.getInternalInstance().getMyRequest(mexId);
        Node part = this.extensionContext.getPartData(notificationMessageEle, this.longRunningActivity.getOutputVariable());
        _log.info((Object)("RESPONSE: " + DOMUtils.domToString(notificationMessageEle)));
        _log.info((Object)("PART: " + DOMUtils.domToString(part)));
        this.extensionContext.writeVariable(this.longRunningActivity.getOutputVariable(), part);
        this.extensionContext.complete(this.cid);
    }

    private class LongRunningActivity
    implements Serializable {
        private static final long serialVersionUID = -82336987878838011L;
        private Element content;
        private DeploymentUnitDir du;
        private QName serviceName;
        private String servicePort;
        private QName callbackServiceName;
        private String callbackServicePort;
        private String serviceURI;

        LongRunningActivity(Element content) {
            this.content = content;
            this.du = new DeploymentUnitDir(new File(LongRunningExtensionOperation.this.extensionContext.getDUDir()));
        }

        public String getName() {
            return this.content.getAttribute("name");
        }

        public String getInputVariable() {
            return this.content.getAttribute("inputVariable");
        }

        public String getOutputVariable() {
            return this.content.getAttribute("outputVariable");
        }

        public String getPartnerLink() {
            return this.content.getAttribute("partnerLink");
        }

        public String getOperation() {
            return this.content.getAttribute("operation");
        }

        public String getResponseOperation() {
            return this.content.getAttribute("responseOperation");
        }

        public String getServiceEPR() throws FaultException {
            if (this.du == null) {
                this.du = new DeploymentUnitDir(new File(LongRunningExtensionOperation.this.extensionContext.getDUDir()));
            }
            DeployDocument deployDocument = this.du.getDeploymentDescriptor();
            OProcess processModel = LongRunningExtensionOperation.this.extensionContext.getProcessModel();
            TDeployment.Process myProcess = null;
            List<TDeployment.Process> processList = deployDocument.getDeploy().getProcessList();
            for (TDeployment.Process process : processList) {
                if (!process.getName().equals(processModel.getQName())) continue;
                myProcess = process;
                break;
            }
            if (myProcess == null) {
                throw new FaultException(new QName(LongRunningExtensionBundle.NS, "related process not found"));
            }
            List<TInvoke> tInvokeList = myProcess.getInvokeList();
            for (TInvoke tInvoke : tInvokeList) {
                if (!tInvoke.getPartnerLink().equals(this.getPartnerLink())) continue;
                this.serviceName = tInvoke.getService().getName();
                this.servicePort = tInvoke.getService().getPort();
                break;
            }
            if (this.serviceName == null || this.servicePort == null) {
                log.error((Object)"service and port for human interaction is not found in the deploy.xml");
                throw new FaultException(new QName(LongRunningExtensionBundle.NS, "service and port for human interaction is not found in the deploy.xml"));
            }
            List<TProvide> tProvideList = myProcess.getProvideList();
            for (TProvide tProvide : tProvideList) {
                if (!tProvide.getPartnerLink().equals(this.getPartnerLink())) continue;
                this.callbackServiceName = tProvide.getService().getName();
                this.callbackServicePort = tProvide.getService().getPort();
                break;
            }
            Definition serviceWSDL = this.du.getDefinitionForService(this.serviceName);
            Service service = serviceWSDL.getService(this.serviceName);
            Port port = service.getPort(this.servicePort);
            List extList = port.getExtensibilityElements();
            for (Object extEle : extList) {
                if (!(extEle instanceof SOAPAddressImpl)) continue;
                SOAPAddressImpl soapAddress = (SOAPAddressImpl)extEle;
                this.serviceURI = soapAddress.getLocationURI();
                break;
            }
            if (this.serviceURI == null) {
                throw new FaultException(new QName(LongRunningExtensionBundle.NS, "Service URI is not available"));
            }
            return this.serviceURI;
        }
    }
}

