/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.extension.e4x;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.runtime.extension.ExtensionContext;
import org.apache.ode.extension.e4x.TopLevelFunctions;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.xml.XMLObject;
import org.mozilla.javascript.xmlimpl.XMLLibImpl;
import org.w3c.dom.Node;

public class VariableDelegator
extends Delegator {
    private static final Log __logger = LogFactory.getLog(VariableDelegator.class);
    private ExtensionContext _ectx;
    private Context _sctx;
    private Map<String, Object> _env = new HashMap<String, Object>();
    private Set<String> _variables = new HashSet<String>();

    public VariableDelegator(Scriptable obj, ExtensionContext ectx, Context sctx) {
        super(obj);
        this._ectx = ectx;
        this._sctx = sctx;
    }

    public Object get(String name, Scriptable start) {
        if (super.has(name, start)) {
            return super.get(name, start);
        }
        if (this._env.get(name) != null) {
            if (__logger.isDebugEnabled()) {
                __logger.debug((Object)("Reading JS variable '" + name + "'."));
            }
            return this._env.get(name);
        }
        try {
            if (!this._ectx.isVariableVisible(name)) {
                return ScriptableObject.NOT_FOUND;
            }
            if (__logger.isDebugEnabled()) {
                __logger.debug((Object)("Reading BPEL variable '" + name + "'."));
            }
            Node n = this._ectx.readVariable(name);
            XMLObject xmlObj = (XMLObject)this._sctx.newObject(start, "XML", new Object[]{Context.javaToJS((Object)TopLevelFunctions.domToString(n), (Scriptable)start)});
            this._env.put(name, xmlObj);
            if (!this._variables.contains(name)) {
                this._variables.add(name);
            }
            return xmlObj;
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing variable " + name + ".", e);
        }
    }

    public boolean has(String name, Scriptable start) {
        if (super.has(name, start) || this._env.containsKey(name)) {
            return true;
        }
        return this._ectx.isVariableVisible(name);
    }

    public void put(String name, Scriptable start, Object value) {
        if (__logger.isDebugEnabled()) {
            __logger.debug((Object)("Setting JS variable '" + name + "' to '" + value + "'."));
        }
        this._env.put(name, value);
        if (this._ectx.isVariableVisible(name) && !this._variables.contains(name)) {
            this._variables.add(name);
        }
    }

    public Scriptable getParentScope() {
        return this.obj;
    }

    public void writeVariables() throws FaultException, ExternalVariableModuleException {
        for (String varName : this._variables) {
            if (__logger.isDebugEnabled()) {
                __logger.debug((Object)("Writing BPEL variable '" + varName + "' to '" + this._env.get(varName) + "'."));
            }
            this._ectx.writeVariable(varName, XMLLibImpl.toDomNode((Object)this._env.get(varName)));
        }
    }
}

