/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OWhile;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannel;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.runtime.channels.TerminationChannel;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;

class WHILE
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(WHILE.class);
    private Set<CompensationHandler> _compHandlers = new HashSet<CompensationHandler>();

    public WHILE(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(self, scopeFrame, linkFrame);
    }

    public void run() {
        boolean condResult = false;
        try {
            condResult = this.checkCondition();
        }
        catch (FaultException fe) {
            __log.error((Object)fe);
            this._self.parent.completed(this.createFault(fe.getQName(), this._self.o), this._compHandlers);
            return;
        }
        if (condResult) {
            ActivityInfo child = new ActivityInfo(this.genMonotonic(), this.getOWhile().activity, this.newChannel(TerminationChannel.class), this.newChannel(ParentScopeChannel.class));
            WHILE.instance(this.createChild(child, this._scopeFrame, this._linkFrame));
            WHILE.instance(new WAITER(child));
        } else {
            this._self.parent.completed(null, this._compHandlers);
        }
    }

    public String toString() {
        return "<T:Act:While:" + this._self.o + ">";
    }

    protected Log log() {
        return __log;
    }

    private OWhile getOWhile() {
        return (OWhile)this._self.o;
    }

    private boolean checkCondition() throws FaultException {
        try {
            return this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsBoolean(this.getOWhile().whileCondition, this.getEvaluationContext());
        }
        catch (EvaluationException e) {
            String msg = "Unexpected expression evaluation error checking while condition.";
            __log.error((Object)msg, (Throwable)e);
            throw new InvalidProcessException(msg, e);
        }
    }

    private class WAITER
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -7645042174027252066L;
        private ActivityInfo _child;
        private boolean _terminated;

        WAITER(ActivityInfo child) {
            this._child = child;
        }

        public void run() {
            WAITER.object(false, new TerminationChannelListener(WHILE.this._self.self){
                private static final long serialVersionUID = -5471984635653784051L;

                public void terminate() {
                    WAITER.this._terminated = true;
                    2.replication(((WAITER)WAITER.this)._child.self).terminate();
                    2.instance(WAITER.this);
                }
            }.or(new ParentScopeChannelListener(this._child.parent){
                private static final long serialVersionUID = 3907167240907524405L;

                @Override
                public void compensate(OScope scope, SynchChannel ret) {
                    WHILE.this._self.parent.compensate(scope, ret);
                    1.instance(WAITER.this);
                }

                @Override
                public void completed(FaultData faultData, Set<CompensationHandler> compensations) {
                    WHILE.this._compHandlers.addAll(compensations);
                    if (WAITER.this._terminated || faultData != null) {
                        WHILE.this._self.parent.completed(faultData, compensations);
                    } else {
                        1.instance(WHILE.this);
                    }
                }

                @Override
                public void cancelled() {
                    this.completed(null, CompensationHandler.emptySet());
                }

                @Override
                public void failure(String reason, Element data) {
                    this.completed(null, CompensationHandler.emptySet());
                }
            }));
        }
    }
}

