/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.Set;
import org.apache.ode.bpel.evt.ProcessInstanceStartedEvent;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OFailureHandling;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.InstanceGlobals;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.READWRITELOCK;
import org.apache.ode.bpel.runtime.SCOPE;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannel;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.runtime.channels.ReadWriteLockChannel;
import org.apache.ode.bpel.runtime.channels.TerminationChannel;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;

public class PROCESS
extends BpelJacobRunnable {
    private static final long serialVersionUID = 1L;
    private OProcess _oprocess;
    private InstanceGlobals _globals;

    public PROCESS(OProcess process) {
        this._oprocess = process;
    }

    public void run() {
        BpelRuntimeContext ntive = this.getBpelRuntimeContext();
        Long scopeInstanceId = ntive.createScopeInstance(null, this._oprocess.procesScope);
        this.createGlobals();
        ProcessInstanceStartedEvent evt = new ProcessInstanceStartedEvent();
        evt.setRootScopeId(scopeInstanceId);
        evt.setScopeDeclarationId(this._oprocess.procesScope.getId());
        ntive.sendEvent(evt);
        ActivityInfo child = new ActivityInfo(this.genMonotonic(), this._oprocess.procesScope, this.newChannel(TerminationChannel.class), this.newChannel(ParentScopeChannel.class));
        ScopeFrame processFrame = new ScopeFrame(this._oprocess.procesScope, scopeInstanceId, null, null, this._globals);
        PROCESS.instance(new SCOPE(child, processFrame, new LinkFrame(null)));
        PROCESS.object(new ParentScopeChannelListener(child.parent){
            private static final long serialVersionUID = -8564969578471906493L;

            @Override
            public void compensate(OScope scope, SynchChannel ret) {
                assert (false);
            }

            @Override
            public void completed(FaultData fault, Set<CompensationHandler> compensations) {
                BpelRuntimeContext nativeAPI = (BpelRuntimeContext)1.getExtension(BpelRuntimeContext.class);
                if (fault == null) {
                    nativeAPI.completedOk();
                } else {
                    nativeAPI.completedFault(fault);
                }
            }

            @Override
            public void cancelled() {
                this.completed(null, CompensationHandler.emptySet());
            }

            @Override
            public void failure(String reason, Element data) {
                FaultData faultData = PROCESS.this.createFault(OFailureHandling.FAILURE_FAULT_NAME, PROCESS.this._oprocess, reason);
                this.completed(faultData, CompensationHandler.emptySet());
            }
        });
    }

    private void createGlobals() {
        this._globals = new InstanceGlobals();
        for (OBase child : this._oprocess.getChildren()) {
            if (!(child instanceof OScope.Variable)) continue;
            OScope.Variable var = (OScope.Variable)child;
            ReadWriteLockChannel vlock = this.newChannel(ReadWriteLockChannel.class);
            PROCESS.instance(new READWRITELOCK(vlock));
            this._globals._varLocks.put(var, vlock);
        }
    }
}

