/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.CorrelatorMessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.memdao.BpelDAOConnectionImpl;
import org.apache.ode.bpel.memdao.DaoBaseImpl;
import org.apache.ode.bpel.memdao.MessageRouteDaoImpl;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CorrelatorDaoImpl
extends DaoBaseImpl
implements CorrelatorDAO {
    private static final Log __log = LogFactory.getLog(CorrelatorDaoImpl.class);
    private String _correlatorId;
    private List<MsgQueueEntry> _messages = new ArrayList<MsgQueueEntry>();
    private List<MessageRouteDaoImpl> _routes = new ArrayList<MessageRouteDaoImpl>();
    private BpelDAOConnectionImpl _conn;

    CorrelatorDaoImpl(String correlatorId, BpelDAOConnectionImpl conn) {
        this._correlatorId = correlatorId;
        this._conn = conn;
    }

    @Override
    public MessageExchangeDAO dequeueMessage(CorrelationKeySet instanceKeySet) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("dequeueEarliest: MATCHING correlationKey=" + instanceKeySet));
        }
        Iterator<MsgQueueEntry> i = this._messages.iterator();
        while (i.hasNext()) {
            MsgQueueEntry mqe = i.next();
            CorrelationKeySet aKeySet = mqe.keySet;
            if (!aKeySet.isRoutableTo(instanceKeySet, false)) continue;
            i.remove();
            return mqe.message;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"dequeueEarliest: MATCH NOT FOUND!");
        }
        return null;
    }

    @Override
    public List<MessageRouteDAO> findRoute(CorrelationKeySet keySet) {
        ArrayList<MessageRouteDAO> routes = new ArrayList<MessageRouteDAO>();
        assert (keySet != null);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("findRoute: keySet=" + keySet));
        }
        boolean routed = false;
        for (MessageRouteDaoImpl route : this._routes) {
            assert (route._ckeySet != null);
            if (!keySet.isRoutableTo(route._ckeySet, "all".equals(route.getRoute()))) continue;
            if ("all".equals(route.getRoute())) {
                routes.add(route);
                continue;
            }
            if (!routed) {
                routes.add(route);
            }
            routed = true;
        }
        return routes;
    }

    @Override
    public String getCorrelatorId() {
        return this._correlatorId;
    }

    @Override
    public void setCorrelatorId(String newId) {
        this._correlatorId = newId;
    }

    @Override
    public void removeRoutes(String routeGroupId, ProcessInstanceDAO target) {
        ((ProcessInstanceDaoImpl)target).removeRoutes(routeGroupId);
    }

    @Override
    public Collection<MessageRouteDAO> getAllRoutes() {
        return new ArrayList<MessageRouteDAO>(this._routes);
    }

    @Override
    public Collection<CorrelatorMessageDAO> getAllMessages() {
        return new ArrayList<CorrelatorMessageDAO>(this._messages);
    }

    @Override
    public void enqueueMessage(MessageExchangeDAO mex, CorrelationKeySet keySet) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("enqueueProcessInvocation: data=" + mex + " keys=" + keySet));
        }
        MsgQueueEntry mqe = new MsgQueueEntry(mex, keySet);
        this._messages.add(mqe);
    }

    @Override
    public void addRoute(String routeId, ProcessInstanceDAO target, int idx, CorrelationKeySet keySet, String routePolicy) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("addRoute: target=" + target + " correlationKeySet=" + keySet));
        }
        final MessageRouteDaoImpl mr = new MessageRouteDaoImpl((ProcessInstanceDaoImpl)target, routeId, keySet, idx, routePolicy);
        this._conn.defer(new Runnable(){

            public void run() {
                CorrelatorDaoImpl.this._routes.add(mr);
            }
        });
    }

    public boolean checkRoute(CorrelationKey ckey) {
        return true;
    }

    void _removeRoutes(String routeGroupId, ProcessInstanceDaoImpl target) {
        Iterator<MessageRouteDaoImpl> i = this._routes.iterator();
        while (i.hasNext()) {
            MessageRouteDaoImpl we = i.next();
            if (!we._groupId.equals(routeGroupId) && routeGroupId != null || we._instance != target) continue;
            i.remove();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{CorrelatorDaoImpl corrId=");
        buf.append(this._correlatorId);
        buf.append(" waiters=");
        buf.append(this._routes);
        buf.append(" messages=");
        buf.append(this._messages);
        buf.append('}');
        return buf.toString();
    }

    @Override
    public boolean checkRoute(CorrelationKeySet correlationKeySet) {
        return true;
    }

    private class MsgQueueEntry
    implements CorrelatorMessageDAO {
        public MessageExchangeDAO message;
        public CorrelationKeySet keySet;

        private MsgQueueEntry(MessageExchangeDAO mex, CorrelationKeySet keySet) {
            this.message = mex;
            this.keySet = keySet;
        }

        public CorrelationKey getCorrelationKey() {
            return this.keySet.iterator().next();
        }

        public void setCorrelationKey(CorrelationKey ckey) {
            this.keySet = new CorrelationKeySet();
            this.keySet.add(ckey);
        }
    }
}

