/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.cron;

import java.util.Set;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.FilteredInstanceDeletable;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeDataCleanupRunnable
implements Scheduler.MapSerializableRunnable,
BpelServerImpl.ContextsAware {
    private final Log _log = LogFactory.getLog(RuntimeDataCleanupRunnable.class);
    private static final long serialVersionUID = 1L;
    private transient Contexts _contexts;
    private int _transactionSize;
    private ProcessConf.CleanupInfo _cleanupInfo;
    private QName _pid;
    private Set<QName> _pidsToExclude;

    @Override
    public void restoreFromDetails(Scheduler.JobDetails details) {
        this._cleanupInfo = (ProcessConf.CleanupInfo)details.getDetailsExt().get("cleanupInfo");
        this._transactionSize = (Integer)details.getDetailsExt().get("transactionSize");
        this._pid = details.getProcessId();
        this._pidsToExclude = (Set)details.getDetailsExt().get("pidsToExclude");
    }

    @Override
    public void storeToDetails(Scheduler.JobDetails details) {
    }

    @Override
    public void setContexts(Contexts contexts) {
        this._contexts = contexts;
    }

    @Override
    public void run() {
        this._log.info((Object)"CRON CLEAN.run().");
        for (String filter : this._cleanupInfo.getFilters()) {
            if (this._pid != null) {
                filter = filter + " pid=" + this._pid;
            } else if (this._pidsToExclude != null) {
                StringBuffer pids = new StringBuffer();
                for (QName pid : this._pidsToExclude) {
                    if (pids.length() > 0) {
                        pids.append("|");
                    }
                    pids.append(pid);
                }
                filter = filter + " pid<>" + pids.toString();
            }
            if (filter.trim().length() <= 0) continue;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("CRON CLEAN.run(" + filter + ") "));
            }
            long numberOfDeletedInstances = 0L;
            while ((numberOfDeletedInstances = (long)this.cleanInstances(filter, this._cleanupInfo.getCategories(), this._transactionSize)) == (long)this._transactionSize) {
            }
        }
    }

    int cleanInstances(String filter, final Set<ProcessConf.CLEANUP_CATEGORY> categories, int limit) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("CRON CLEAN using filter: " + filter + ", limit: " + limit));
        }
        final InstanceFilter instanceFilter = new InstanceFilter(filter, "", limit);
        try {
            if (this._contexts.scheduler != null) {
                return this._contexts.scheduler.execTransaction(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        BpelDAOConnection con = ((RuntimeDataCleanupRunnable)RuntimeDataCleanupRunnable.this)._contexts.dao.getConnection();
                        if (con instanceof FilteredInstanceDeletable) {
                            return ((FilteredInstanceDeletable)((Object)con)).deleteInstances(instanceFilter, categories);
                        }
                        return 0;
                    }
                });
            }
            return 0;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while listing instances: ", e);
        }
    }
}

