/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.File;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.utils.msg.MessageBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Messages
extends MessageBundle {
    String msgBarProcessLoadErr() {
        return this.format("Unable to load compiled BPEL process.");
    }

    String msgProcessDeployed(QName processId) {
        return this.format("Process {0} deployed.", processId);
    }

    String msgDbError() {
        return this.format("A database error prevented the operation from succeeding.");
    }

    String msgInstanceNotFound(Long pid) {
        return this.format("The instance \"{0}\" was not found in the database.", pid);
    }

    String msgUnknownEPR(String epr) {
        return this.format("Unkown EPR: {0}", epr);
    }

    String msgProcessRegistered(QName pid) {
        return this.format("Registered process {0}.", pid);
    }

    String msgProcessUnregistered(QName pid) {
        return this.format("Unregistered process {0}.", pid);
    }

    String msgProcessUnregisterFailed(QName process) {
        return this.format("Failed to unregister process {0}! Check database for consistency!", process);
    }

    String msgProcessNotFound(QName pid) {
        return this.format("Process {0} not found. ", pid);
    }

    String msgProcessNotActive(QName processId) {
        return this.format("Process {0} is not active. ", processId);
    }

    String msgProcessLoadError(QName processId) {
        return this.format("Process {0}, could not be loaded. ", processId);
    }

    String msgDeployFailDescriptorURIInvalid(URI dduri) {
        return this.format("Deployment failure: invalid deployment descriptor URI \"{0}\" ", dduri);
    }

    String msgDeployFailDescriptorInvalid(URI dduri) {
        return this.format("Deployment failure: invalid/malformed deployment descriptor at \"{0}\"", dduri);
    }

    String msgDeployFailDescriptorIOError(URI dduri) {
        return this.format("Deployment failure: IO error reading deployment descriptor at \"{0}\"", dduri);
    }

    String msgDDPartnerLinkNotFound(String partnerLinkName) {
        return this.format("Partner link declared in process deployment descriptor could not be found in process definition: {0}", partnerLinkName);
    }

    String msgDDPartnerRoleNotFound(String partnerLinkName) {
        return this.format("Role 'partnerRole' declared in process deployment descriptor isn't defined in process definition for partner link : {0}", partnerLinkName);
    }

    String msgDDMyRoleNotFound(String partnerLinkName) {
        return this.format("Role 'myRole' declared in process deployment descriptor isn't defined in process definition for partner link : {0}", partnerLinkName);
    }

    String msgDDNoInitiliazePartnerRole(String partnerLinkName) {
        return this.format("Partner link {0} is defined in process as initializePartnerRole=no, its partner role endpoint can't be initialized by deployment descriptor.", partnerLinkName);
    }

    String msgProcessDeployErrAlreadyDeployed(QName processId) {
        return this.format("The process could not be deployed; another process is already deployed as {0}!", processId);
    }

    String msgScheduledJobReferencesUnknownInstance(Long iid) {
        return this.format("Received a scheduled job event for unknown instance {0}", iid);
    }

    String msgReschedulingJobForInactiveProcess(QName processId, String jobId, Date rescheduled) {
        return this.format("Received a scheduled job event for inactive process {0}; rescheduling job {1} for {2}", processId, jobId, rescheduled);
    }

    String msgProcessActivationError(QName pid) {
        return this.format("Error activating process {0}", pid);
    }

    String msgOperationInterrupted() {
        return this.format("Operation was interrupted.");
    }

    String msgServerStarted() {
        return this.format("BPEL Server Started.");
    }

    String msgServerStopped() {
        return this.format("BPEL Server Stopped.");
    }

    String msgUndefinedServicePort(QName service, String port) {
        return this.format("The service name and port defined in your deployment descriptor couldn't be found in any WSDL document: {0} {1}.", service, port);
    }

    String msgInterceptorAborted(String mexId, String interceptor, String msg) {
        return this.format("Message exchange {0} aborted by interceptor {1}: {2}", mexId, interceptor, msg);
    }

    String msgMyRoleRoutingFailure(String messageExchangeId) {
        return this.format("Unable to route message exchange {0}, EPR was not specified and the target my-role could not be inferred.", messageExchangeId);
    }

    String msgPropertyAliasReturnedNullSet(String alias, String variable) {
        return this.format("msgPropertyAliasReturnedNullSet: {0} {1}", alias, variable);
    }

    String msgUnknownOperation(String operationName, QName portType) {
        return this.format("Unknown operation \"{0}\" for port type \"{1}\".", operationName, portType);
    }

    String msgPropertyAliasDerefFailedOnMessage(String aliasDescription, String reason) {
        return this.format("Unable to evaluate property alias \"{0}\" to incoming message: {1}", aliasDescription, reason);
    }

    public String msgDeployStarting(File deploymentUnitDirectory) {
        return this.format("Starting deployment of processes from directory \"{0}\". ", deploymentUnitDirectory);
    }

    public String msgDeployFailed(QName name, File deploymentUnitDirectory) {
        return this.format("Deployment of process \"{0}\" from \"{1}\" failed.", name, deploymentUnitDirectory);
    }

    public String msgDeployRollback(File deploymentUnitDirectory) {
        return this.format("Deployment of processes from \"{0}\" failed, rolling back. ", deploymentUnitDirectory);
    }

    public String msgExpLangRegistrationError(String expressionLanguageUri, Map<String, String> properties) {
        return this.format("Error registering expression language \"" + expressionLanguageUri + "\" with properties " + properties);
    }

    public String msgScheduledJobFailed(Scheduler.JobDetails jobDetail) {
        return this.format("Scheduled job failed; jobDetail={0}", jobDetail);
    }

    public String msgExtensionMustUnderstandError(QName name, String extensionUri) {
        return this.format("Deployment of process \"{0}\" failed. The process model requires the engine to understand language extensions defined by {1}. No extension bundle has been registered for this namespace.", name, extensionUri);
    }
}

