/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
implements Message {
    public MessageDAO _dao;

    public MessageImpl(MessageDAO message) {
        this._dao = message;
    }

    @Override
    public Element getPart(String partName) {
        Element message = this.getMessage();
        NodeList eltList = message.getElementsByTagName(partName);
        if (eltList.getLength() == 0) {
            return null;
        }
        return (Element)eltList.item(0);
    }

    @Override
    public void setPart(String partName, Element content) {
        Element message = this.getMessage();
        if (message == null) {
            Document doc = DOMUtils.newDocument();
            message = doc.createElement("message");
            doc.appendChild(message);
        }
        message.appendChild(message.getOwnerDocument().importNode(content, true));
        this.setMessage(message);
    }

    @Override
    public Element getHeaderPart(String partName) {
        Element header = this._dao.getHeader();
        if (header == null) {
            return null;
        }
        NodeList eltList = header.getElementsByTagName(partName);
        if (eltList.getLength() == 0) {
            return null;
        }
        return (Element)eltList.item(0);
    }

    @Override
    public void setHeaderPart(String name, Element content) {
        Element header = this._dao.getHeader();
        if (header == null) {
            Document doc = DOMUtils.newDocument();
            header = doc.createElement("header");
            doc.appendChild(header);
        }
        Element part = header.getOwnerDocument().createElement(name);
        header.appendChild(part);
        part.appendChild(header.getOwnerDocument().importNode(content, true));
        this._dao.setHeader(header);
    }

    @Override
    public void setHeaderPart(String name, String content) {
        Element header = this._dao.getHeader();
        if (header == null) {
            Document doc = DOMUtils.newDocument();
            header = doc.createElement("header");
            doc.appendChild(header);
        }
        Element part = header.getOwnerDocument().createElement(name);
        header.appendChild(part);
        part.setTextContent(content);
        this._dao.setHeader(header);
    }

    @Override
    public void setMessage(Element msg) {
        this._dao.setData(msg);
    }

    @Override
    public Element getMessage() {
        return this._dao.getData();
    }

    @Override
    public Element getHeader() {
        return this._dao.getHeader();
    }

    @Override
    public QName getType() {
        return this._dao.getType();
    }

    @Override
    public List<String> getParts() {
        ArrayList<String> parts = new ArrayList<String>();
        Element message = this.getMessage();
        NodeList nodeList = message.getChildNodes();
        for (int m = 0; m < nodeList.getLength(); ++m) {
            Node node = nodeList.item(m);
            if (node.getNodeType() != 1) continue;
            parts.add(node.getLocalName());
        }
        return parts;
    }

    @Override
    public Map<String, Node> getHeaderParts() {
        HashMap<String, Node> l = new HashMap<String, Node>();
        Element header = this._dao.getHeader();
        if (header != null) {
            NodeList children = header.getChildNodes();
            for (int m = 0; m < children.getLength(); ++m) {
                if (children.item(m).getNodeType() != 1) continue;
                Element part = (Element)children.item(m);
                Node node = DOMUtils.findChildByType(part, 1);
                if (node == null) {
                    node = DOMUtils.findChildByType(part, 3);
                }
                l.put(part.getLocalName(), node);
            }
        }
        return l;
    }
}

