/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.runtime;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.elang.xpath20.compiler.WrappedResolverException;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OXsdTypeVarType;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.w3c.dom.Node;

public class JaxpVariableResolver
implements XPathVariableResolver {
    private static final Log __log = LogFactory.getLog(JaxpVariableResolver.class);
    private EvaluationContext _ectx;
    private OXPath10ExpressionBPEL20 _oxpath;
    private Configuration _config;

    public JaxpVariableResolver(EvaluationContext ectx, OXPath10ExpressionBPEL20 oxpath, Configuration config) {
        this._ectx = ectx;
        this._oxpath = oxpath;
        this._config = config;
    }

    public Object resolveVariable(QName variableName) {
        String partName;
        String varName;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Resolving variable " + variableName));
        }
        if (!(this._oxpath instanceof OXPath10ExpressionBPEL20)) {
            throw new IllegalStateException("XPath variables not supported for bpel 1.1");
        }
        if (variableName.getNamespaceURI().equals(Namespaces.ODE_EXTENSION_NS)) {
            if ("pid".equals(variableName.getLocalPart())) {
                return this._ectx.getProcessId();
            }
            if ("processQName".equals(variableName.getLocalPart())) {
                return this._ectx.getProcessQName();
            }
            if ("currentEventDateTime".equals(variableName.getLocalPart())) {
                return this._ectx.getCurrentEventDateTime();
            }
        }
        OXPath10ExpressionBPEL20 expr = this._oxpath;
        if (expr.isJoinExpression) {
            OLink olink = (OLink)this._oxpath.links.get(variableName.getLocalPart());
            try {
                return this._ectx.isLinkActive(olink) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (FaultException e) {
                throw new WrappedResolverException(e);
            }
        }
        int dotloc = variableName.getLocalPart().indexOf(46);
        if (dotloc == -1) {
            varName = variableName.getLocalPart();
            partName = null;
        } else {
            varName = variableName.getLocalPart().substring(0, dotloc);
            partName = variableName.getLocalPart().substring(dotloc + 1);
        }
        OScope.Variable variable = (OScope.Variable)this._oxpath.vars.get(varName);
        OMessageVarType.Part part = partName == null ? null : ((OMessageVarType)variable.type).parts.get(partName);
        try {
            Node variableNode = this._ectx.readVariable(variable, part);
            if (variableNode == null) {
                throw new FaultException(variable.getOwner().constants.qnSelectionFailure, "Unknown variable " + variableName.getLocalPart());
            }
            if (this._ectx.narrowTypes()) {
                if (variable.type instanceof OXsdTypeVarType && ((OXsdTypeVarType)variable.type).simple) {
                    return this.getSimpleContent(variableNode, ((OXsdTypeVarType)variable.type).xsdType);
                }
                if (part != null && part.type instanceof OXsdTypeVarType && ((OXsdTypeVarType)part.type).simple) {
                    return this.getSimpleContent(variableNode, ((OXsdTypeVarType)part.type).xsdType);
                }
            }
            return variableNode;
        }
        catch (FaultException e) {
            throw new WrappedResolverException(e);
        }
    }

    public Value convertSimpleTypeToSaxon(QName type, String value) {
        int fp = this._config.getNamePool().allocate("", type.getNamespaceURI(), type.getLocalPart());
        SchemaType type2 = this._config.getSchemaType(fp);
        if (type2 == null || !type2.isAtomicType()) {
            __log.warn((Object)("Can't find simple type " + type + " value " + value + " result: " + null));
            return null;
        }
        try {
            if (type2.equals(BuiltInAtomicType.INT) && value.indexOf(".") != -1) {
                value = value.substring(0, value.indexOf("."));
            }
            AtomicValue value2 = StringValue.convertStringToAtomicType((CharSequence)value, (AtomicType)((AtomicType)type2), null).asAtomic();
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("converting " + type + " value " + value + " result: " + value2));
            }
            return value2;
        }
        catch (ValidationException e) {
            __log.debug((Object)("Can't convert " + value + " to " + type + " returning empty sequence"));
            return EmptySequence.getInstance();
        }
    }

    public Object getSimpleContent(Node simpleNode, QName type) {
        String text = simpleNode.getTextContent();
        Value o = this.convertSimpleTypeToSaxon(type, text);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("getSimpleContent for " + DOMUtils.domToString(simpleNode) + " " + type + " returned " + o));
        }
        return o;
    }
}

