/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.compiler;

import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.elang.xpath10.compiler.XPathMessages;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.elang.xpath20.compiler.WrappedResolverException;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.o.OXsdTypeVarType;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Document;

public class JaxpVariableResolver
implements XPathVariableResolver {
    private static final XPathMessages __msgs = MessageBundle.getMessages(XPathMessages.class);
    private CompilerContext _cctx;
    private OXPath10ExpressionBPEL20 _oxpath;

    public JaxpVariableResolver(CompilerContext cctx, OXPath10ExpressionBPEL20 oxpath) {
        this._cctx = cctx;
        this._oxpath = oxpath;
    }

    public Object resolveVariable(QName variableName) {
        if ("ode".equals(variableName.getPrefix()) || Namespaces.ODE_EXTENSION_NS.equals(variableName.getNamespaceURI())) {
            if ("pid".equals(variableName.getLocalPart()) || "processQName".equals(variableName.getLocalPart())) {
                return "";
            }
            if ("currentEventDateTime".equals(variableName.getLocalPart())) {
                return new Date(1L);
            }
        }
        try {
            String name = variableName.getLocalPart();
            if (this._oxpath.isJoinExpression) {
                OLink olink = this._cctx.resolveLink(name);
                this._oxpath.links.put(name, olink);
                return Boolean.TRUE;
            }
            int dot = name.indexOf(46);
            if (dot != -1) {
                name = name.substring(0, dot);
            }
            OScope.Variable var = this._cctx.resolveVariable(name);
            this._oxpath.vars.put(name, var);
            return this.extractValue(var, var.type);
        }
        catch (CompilationException e) {
            throw new WrappedResolverException(e);
        }
    }

    private Object extractValue(OScope.Variable var, OVarType varType) {
        if (varType instanceof OXsdTypeVarType) {
            return this.generateFromType(((OXsdTypeVarType)varType).xsdType);
        }
        if (varType instanceof OElementVarType) {
            return this.generateFromType(((OElementVarType)varType).elementType);
        }
        if (varType instanceof OMessageVarType) {
            if (((OMessageVarType)varType).parts.size() == 0) {
                throw new WrappedResolverException(__msgs.errExpressionMessageNoPart(var.name));
            }
            return this.extractValue(var, ((OMessageVarType)varType).parts.values().iterator().next().type);
        }
        return "";
    }

    private Object generateFromType(QName typeName) {
        if (typeName.getNamespaceURI().equals(Namespaces.XML_SCHEMA)) {
            if (typeName.getLocalPart().equals("int") || typeName.getLocalPart().equals("integer") || typeName.getLocalPart().equals("short") || typeName.getLocalPart().equals("long") || typeName.getLocalPart().equals("byte") || typeName.getLocalPart().equals("float") || typeName.getLocalPart().equals("double") || typeName.getLocalPart().equals("nonPositiveInteger") || typeName.getLocalPart().equals("nonNegativeInteger") || typeName.getLocalPart().equals("negativeInteger") || typeName.getLocalPart().equals("unsignedLong") || typeName.getLocalPart().equals("unsignedInt") || typeName.getLocalPart().equals("unsignedShort") || typeName.getLocalPart().equals("unsignedByte")) {
                return 0;
            }
            if (typeName.getLocalPart().equals("boolean")) {
                return Boolean.TRUE;
            }
            if (typeName.getLocalPart().equals("string")) {
                return "";
            }
        }
        Document doc = DOMUtils.newDocument();
        doc.appendChild(doc.createElement("empty"));
        return doc.getDocumentElement();
    }
}

