/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath10.runtime;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerFactory;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10Expression;
import org.apache.ode.bpel.elang.xpath10.runtime.BpelDocumentNavigator;
import org.apache.ode.bpel.elang.xpath10.runtime.JaxenContexts;
import org.apache.ode.bpel.elang.xpath10.runtime.JaxenNamespaceContextAdapter;
import org.apache.ode.bpel.elang.xpath10.runtime.WrappedFaultException;
import org.apache.ode.bpel.explang.ConfigurationException;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.explang.ExpressionLanguageRuntime;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.xsd.Duration;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XPath10ExpressionRuntime
implements ExpressionLanguageRuntime {
    private static final Log __log = LogFactory.getLog(XPath10ExpressionRuntime.class);
    private final Map<String, XPath> _compiledExpressions = new HashMap<String, XPath>();
    private final Map _extensionFunctions = new HashMap();

    public void initialize(Map properties) throws ConfigurationException {
        TransformerFactoryImpl trsf = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)trsf);
    }

    public String evaluateAsString(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        try {
            return this.compile((OXPath10Expression)cexp).stringValueOf((Object)this.createContext((OXPath10Expression)cexp, ctx));
        }
        catch (JaxenException e) {
            this.handleJaxenException(e);
            throw new AssertionError((Object)"UNREACHABLE");
        }
    }

    public boolean evaluateAsBoolean(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        try {
            return this.compile((OXPath10Expression)cexp).booleanValueOf((Object)this.createContext((OXPath10Expression)cexp, ctx));
        }
        catch (JaxenException e) {
            this.handleJaxenException(e);
            throw new AssertionError((Object)"UNREACHABLE");
        }
    }

    public Number evaluateAsNumber(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        try {
            return this.compile((OXPath10Expression)cexp).numberValueOf((Object)this.createContext((OXPath10Expression)cexp, ctx));
        }
        catch (JaxenException e) {
            this.handleJaxenException(e);
            throw new AssertionError((Object)"UNREACHABLE");
        }
    }

    public List evaluate(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        try {
            XPath compiledXPath = this.compile((OXPath10Expression)cexp);
            Context context = this.createContext((OXPath10Expression)cexp, ctx);
            List<Text> retVal = compiledXPath.selectNodes((Object)context);
            if (retVal.size() == 1 && !(retVal.get(0) instanceof Node)) {
                Document d = DOMUtils.newDocument();
                Element wrapper = d.createElement("wrapper");
                Text text = d.createTextNode(retVal.get(0).toString());
                wrapper.appendChild(text);
                d.appendChild(wrapper);
                retVal = Collections.singletonList(text);
            }
            return retVal;
        }
        catch (JaxenException je) {
            this.handleJaxenException(je);
            throw new AssertionError((Object)"UNREACHABLE");
        }
    }

    public Node evaluateNode(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        List retVal = this.evaluate(cexp, ctx);
        if (retVal.size() == 0 || retVal.size() > 1) {
            StringBuffer msg = new StringBuffer(retVal.size() == 0 ? "No results for expression: '" : "Multiple results for expression: '");
            if (cexp instanceof OXPath10Expression) {
                msg.append(((OXPath10Expression)cexp).xpath);
            } else {
                msg.append(cexp.toString());
            }
            msg.append("'");
            if (ctx.getRootNode() != null) {
                msg.append(" against '");
                msg.append(DOMUtils.domToString(ctx.getRootNode()));
                msg.append("'");
            }
            throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, msg.toString());
        }
        return (Node)retVal.get(0);
    }

    public Calendar evaluateAsDate(OExpression cexp, EvaluationContext context) throws FaultException, EvaluationException {
        String literal = this.evaluateAsString(cexp, context);
        try {
            return ISO8601DateParser.parseCal(literal);
        }
        catch (Exception ex) {
            String errmsg = "Invalid date: " + literal;
            __log.error((Object)errmsg, (Throwable)ex);
            throw new FaultException(cexp.getOwner().constants.qnInvalidExpressionValue, errmsg);
        }
    }

    public Duration evaluateAsDuration(OExpression cexp, EvaluationContext context) throws FaultException, EvaluationException {
        String literal = this.evaluateAsString(cexp, context);
        try {
            Duration duration = new Duration(literal);
            return duration;
        }
        catch (Exception ex) {
            String errmsg = "Invalid duration: " + literal;
            __log.error((Object)errmsg, (Throwable)ex);
            throw new FaultException(cexp.getOwner().constants.qnInvalidExpressionValue, errmsg);
        }
    }

    private Context createContext(OXPath10Expression oxpath, EvaluationContext ctx) {
        JaxenContexts bpelSupport = new JaxenContexts(oxpath, this._extensionFunctions, ctx);
        ContextSupport support = new ContextSupport((NamespaceContext)new JaxenNamespaceContextAdapter(oxpath.namespaceCtx), (FunctionContext)bpelSupport, (VariableContext)bpelSupport, (Navigator)new BpelDocumentNavigator(ctx.getRootNode()));
        Context jctx = new Context(support);
        if (ctx.getRootNode() != null) {
            jctx.setNodeSet(Collections.singletonList(ctx.getRootNode()));
        }
        return jctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPath compile(OXPath10Expression exp) throws JaxenException {
        XPath xpath = this._compiledExpressions.get(exp.xpath);
        if (xpath == null) {
            xpath = new DOMXPath(exp.xpath);
            Map<String, XPath> map = this._compiledExpressions;
            synchronized (map) {
                this._compiledExpressions.put(exp.xpath, xpath);
            }
        }
        return xpath;
    }

    private void handleJaxenException(JaxenException je) throws EvaluationException, FaultException {
        if (je instanceof WrappedFaultException) {
            throw ((WrappedFaultException)((Object)je)).getFaultException();
        }
        if (je.getCause() instanceof WrappedFaultException) {
            throw ((WrappedFaultException)((Object)je.getCause())).getFaultException();
        }
        throw new EvaluationException(je.getMessage(), je);
    }
}

