/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang;

import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10Expression;
import org.apache.ode.bpel.o.OXslSheet;
import org.apache.ode.utils.fs.FileUtils;

public class XslRuntimeUriResolver
implements URIResolver {
    private static final Log __log = LogFactory.getLog(XslRuntimeUriResolver.class);
    private OXPath10Expression _expr;
    private final URI _baseResourceURI;

    public XslRuntimeUriResolver(OXPath10Expression expr, URI baseResourceURI) {
        this._expr = expr;
        this._baseResourceURI = baseResourceURI;
    }

    public Source resolve(String href, String base) throws TransformerException {
        URI uri;
        try {
            uri = new URI(FileUtils.encodePath(href));
        }
        catch (URISyntaxException e) {
            return null;
        }
        OXslSheet sheet = this._expr.getXslSheet(uri);
        if (sheet != null) {
            String result = sheet.sheetBody;
            if (result != null) {
                return new StreamSource(new StringReader(result));
            }
            return null;
        }
        InputStream result = this.getResourceAsStream(uri);
        if (result != null) {
            return new StreamSource(result);
        }
        return null;
    }

    private InputStream getResourceAsStream(URI docUri) {
        URI resolvedURI = this._baseResourceURI.resolve(docUri);
        InputStream is = null;
        try {
            URL url = resolvedURI.toURL();
            is = url.openStream();
            return is;
        }
        catch (Exception e) {
            __log.warn((Object)("Couldn't load XSL resource " + docUri), (Throwable)e);
            return null;
        }
    }
}

