/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.connector;

import org.apache.ode.bpel.connector.ConnectionProviderImpl;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.jca.server.rmi.RmiTransportServerImpl;

public class BpelServerConnector {
    private BpelServer _server;
    private ProcessStore _store;
    private RmiTransportServerImpl _transport = new RmiTransportServerImpl();

    public BpelServerConnector() {
        this._transport.setId("ode/BpelEngine");
    }

    public void setBpelServer(BpelServer server) {
        this._server = server;
    }

    public void setProcessStore(ProcessStore store) {
        this._store = store;
    }

    public void start() throws Exception {
        if (this._server == null) {
            throw new IllegalStateException("Server not set!");
        }
        if (this._store == null) {
            throw new IllegalStateException("Store not set!");
        }
        this._transport.setConnectionProvider(new ConnectionProviderImpl(this._server, this._store));
        this._transport.start();
    }

    public void shutdown() throws Exception {
        this._transport.stop();
    }

    public void setPort(int connectorPort) {
        this._transport.setPort(connectorPort);
    }

    public void setId(String connectorName) {
        this._transport.setId(connectorName);
    }
}

