/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.util.Collection;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.PickGeneratorMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.Correlation;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OPickReceive;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.utils.msg.MessageBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PickReceiveGenerator
extends DefaultActivityGenerator {
    protected static final CommonCompilationMessages __cmsgsGeneral = MessageBundle.getMessages(CommonCompilationMessages.class);
    protected static final PickGeneratorMessages __cmsgs = MessageBundle.getMessages(PickGeneratorMessages.class);

    PickReceiveGenerator() {
    }

    @Override
    public OActivity newInstance(Activity src) {
        return new OPickReceive(this._context.getOProcess(), this._context.getCurrent());
    }

    protected OPickReceive.OnMessage compileOnMessage(String varname, String plink, String operation, String messageExchangeId, QName portType, boolean createInstance, Collection<Correlation> correlations, String route) {
        OPickReceive.OnMessage onMessage = new OPickReceive.OnMessage(this._context.getOProcess());
        onMessage.partnerLink = this._context.resolvePartnerLink(plink);
        onMessage.operation = this._context.resolveMyRoleOperation(onMessage.partnerLink, operation);
        if (onMessage.operation.getInput() != null && onMessage.operation.getInput().getMessage() != null) {
            onMessage.variable = this._context.resolveMessageVariable(varname, onMessage.operation.getInput().getMessage().getQName());
        }
        onMessage.messageExchangeId = messageExchangeId;
        onMessage.route = route;
        if (portType != null && !portType.equals(onMessage.partnerLink.myRolePortType.getQName())) {
            throw new CompilationException(__cmsgsGeneral.errPortTypeMismatch(portType, onMessage.partnerLink.myRolePortType.getQName()));
        }
        if (createInstance) {
            onMessage.partnerLink.addCreateInstanceOperation(onMessage.operation);
        }
        HashSet<String> csetNames = new HashSet<String>();
        for (Correlation correlation : correlations) {
            if (csetNames.contains(correlation.getCorrelationSet())) {
                throw new CompilationException(__cmsgsGeneral.errDuplicateUseCorrelationSet(correlation.getCorrelationSet()));
            }
            OScope.CorrelationSet cset = this._context.resolveCorrelationSet(correlation.getCorrelationSet());
            switch (correlation.getInitiate()) {
                case UNSET: 
                case NO: {
                    if (createInstance) {
                        throw new CompilationException(__cmsgsGeneral.errUseOfUninitializedCorrelationSet(correlation.getCorrelationSet()));
                    }
                    onMessage.matchCorrelations.add(cset);
                    onMessage.partnerLink.addCorrelationSetForOperation(onMessage.operation, cset, false);
                    break;
                }
                case YES: {
                    onMessage.initCorrelations.add(cset);
                    break;
                }
                case JOIN: {
                    cset.hasJoinUseCases = true;
                    onMessage.joinCorrelations.add(cset);
                    onMessage.partnerLink.addCorrelationSetForOperation(onMessage.operation, cset, true);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected value for correlation set enumeration!");
                }
            }
            for (OProcess.OProperty property : cset.properties) {
                this._context.resolvePropertyAlias(onMessage.variable, property.name);
            }
            csetNames.add(correlation.getCorrelationSet());
        }
        if (!onMessage.partnerLink.hasMyRole()) {
            throw new CompilationException(__cmsgsGeneral.errNoMyRoleOnReceivePartnerLink(onMessage.partnerLink.getName()));
        }
        return onMessage;
    }
}

