/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.util;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLEncodedTransformer {
    private static final Log log = LogFactory.getLog(URLEncodedTransformer.class);

    public String transform(Map<String, Element> values) {
        if (values.isEmpty()) {
            return null;
        }
        ArrayList<NameValuePair> l = new ArrayList<NameValuePair>(values.size());
        for (Map.Entry<String, Element> e : values.entrySet()) {
            Element childElement;
            String partName = e.getKey();
            Element value = e.getValue();
            String textValue = DOMUtils.isEmptyElement(value) ? "" : ((childElement = DOMUtils.getFirstChildElement(value)) != null ? DOMUtils.getTextContent(childElement) : DOMUtils.getTextContent(value));
            if (textValue == null) continue;
            l.add(new NameValuePair(e.getKey(), textValue));
        }
        return EncodingUtil.formUrlEncode((NameValuePair[])l.toArray(new NameValuePair[0]), (String)"UTF-8");
    }
}

