/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.httpbinding;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.ExternalService;
import org.apache.ode.axis2.ODEService;
import org.apache.ode.axis2.OdeFault;
import org.apache.ode.axis2.httpbinding.HttpBindingValidator;
import org.apache.ode.axis2.httpbinding.HttpHelper;
import org.apache.ode.axis2.httpbinding.HttpMethodConverter;
import org.apache.ode.axis2.util.ClusterUrlTransformer;
import org.apache.ode.bpel.epr.EndpointFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.epr.WSAEndpoint;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Properties;
import org.apache.ode.utils.wsdl.Messages;
import org.apache.ode.utils.wsdl.WsdlUtils;
import org.w3c.dom.Element;

public class HttpExternalService
implements ExternalService {
    private static final Log log = LogFactory.getLog(ExternalService.class);
    private static final Messages msgs = Messages.getMessages(Messages.class);
    private MultiThreadedHttpConnectionManager connections;
    protected ExecutorService executorService;
    protected Scheduler scheduler;
    protected BpelServer server;
    protected ProcessConf pconf;
    protected QName serviceName;
    protected String portName;
    protected WSAEndpoint endpointReference;
    protected HttpMethodConverter httpMethodConverter;
    protected Binding portBinding;
    private URL endpointUrl;
    private ClusterUrlTransformer clusterUrlTransformer;

    public HttpExternalService(ProcessConf pconf, QName serviceName, String portName, ExecutorService executorService, Scheduler scheduler, BpelServer server, MultiThreadedHttpConnectionManager connManager, ClusterUrlTransformer clusterUrlTransformer) throws OdeFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("new HTTP External service, service name=[" + serviceName + "]; port name=[" + portName + "]"));
        }
        this.portName = portName;
        this.serviceName = serviceName;
        this.executorService = executorService;
        this.scheduler = scheduler;
        this.server = server;
        this.pconf = pconf;
        this.clusterUrlTransformer = clusterUrlTransformer;
        Definition definition = pconf.getDefinitionForService(serviceName);
        Service serviceDef = definition.getService(serviceName);
        if (serviceDef == null) {
            throw new IllegalArgumentException(msgs.msgServiceDefinitionNotFound(serviceName));
        }
        Port port = serviceDef.getPort(portName);
        if (port == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(serviceName, portName));
        }
        this.portBinding = port.getBinding();
        if (this.portBinding == null) {
            throw new IllegalArgumentException(msgs.msgBindingNotFound(portName));
        }
        if (!WsdlUtils.useHTTPBinding(port)) {
            throw new IllegalArgumentException(msgs.msgNoHTTPBindingForPort(portName));
        }
        new HttpBindingValidator(this.portBinding).validate();
        Element eprElmt = ODEService.genEPRfromWSDL(definition, serviceName, portName);
        if (eprElmt == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(serviceName, portName));
        }
        this.endpointReference = EndpointFactory.convertToWSA(ODEService.createServiceRef(eprElmt));
        try {
            this.endpointUrl = new URL(this.endpointReference.getUrl());
        }
        catch (MalformedURLException e) {
            throw new OdeFault(e);
        }
        this.httpMethodConverter = new HttpMethodConverter(definition, serviceName, portName);
        this.connections = connManager;
    }

    public String getPortName() {
        return this.portName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void close() {
        this.connections.shutdown();
    }

    public EndpointReference getInitialEndpointReference() {
        return this.endpointReference;
    }

    public void invoke(PartnerRoleMessageExchange odeMex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Preparing " + this.getClass().getSimpleName() + " invocation..."));
        }
        try {
            boolean isTwoWay;
            String mexEndpointUrl;
            Map<String, String> properties = this.pconf.getEndpointProperties(this.endpointReference);
            HttpParams params = Properties.HttpClient.translate(properties);
            String baseUrl = mexEndpointUrl = ((MutableEndpoint)odeMex.getEndpointReference()).getUrl();
            if (this.endpointUrl.equals(new URL(mexEndpointUrl))) {
                String address = (String)params.getParameter("address");
                if (address != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Endpoint URL overridden by property files. " + mexEndpointUrl + " => " + address));
                    }
                    baseUrl = address;
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Endpoint URL overridden by process. " + this.endpointUrl + " => " + mexEndpointUrl));
            }
            baseUrl = this.clusterUrlTransformer.rewriteOutgoingClusterURL(baseUrl);
            HttpMethod method = this.httpMethodConverter.createHttpRequest(odeMex, params, baseUrl);
            HttpClient client = new HttpClient((HttpConnectionManager)this.connections);
            Element message = odeMex.getRequest().getMessage();
            Element authenticatePart = message == null ? null : DOMUtils.findChildByName(message, new QName(null, "WWW-Authenticate"));
            HttpHelper.configure(client, method.getURI(), authenticatePart, params);
            boolean bl = isTwoWay = odeMex.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
            if (isTwoWay) {
                final TwoWayCallable executionCallable = new TwoWayCallable(client, method, odeMex.getMessageExchangeId(), odeMex.getOperation());
                this.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

                    public void afterCompletion(boolean success) {
                        if (!success) {
                            return;
                        }
                        HttpExternalService.this.executorService.submit(executionCallable);
                    }

                    public void beforeCompletion() {
                    }
                });
                odeMex.replyAsync();
            } else {
                OneWayCallable executionCallable = new OneWayCallable(client, method, odeMex.getMessageExchangeId(), odeMex.getOperation());
                this.executorService.submit(executionCallable);
                odeMex.replyOneWayOk();
            }
        }
        catch (UnsupportedEncodingException e) {
            String errmsg = "The returned HTTP encoding isn't supported " + odeMex;
            log.error((Object)("[Service: " + this.serviceName + ", Port: " + this.portName + ", Operation: " + odeMex.getOperationName() + "] " + errmsg), (Throwable)e);
            odeMex.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, errmsg, null);
        }
        catch (URIException e) {
            String errmsg = "Error sending message to " + this.getClass().getSimpleName() + " for ODE mex " + odeMex;
            log.error((Object)("[Service: " + this.serviceName + ", Port: " + this.portName + ", Operation: " + odeMex.getOperationName() + "] " + errmsg), (Throwable)e);
            odeMex.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, errmsg, null);
        }
        catch (Exception e) {
            String errmsg = "Unknown HTTP call error for ODE mex " + odeMex;
            log.error((Object)("[Service: " + this.serviceName + ", Port: " + this.portName + ", Operation: " + odeMex.getOperationName() + "] " + errmsg), (Throwable)e);
            odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, null);
        }
    }

    private class TwoWayCallable
    extends OneWayCallable {
        public TwoWayCallable(HttpClient client, HttpMethod method, String mexId, Operation operation) {
            super(client, method, mexId, operation);
        }

        public void processResponse(final int statusCode) {
            try {
                HttpExternalService.this.scheduler.execTransaction(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            if (statusCode >= 200 && statusCode < 300) {
                                TwoWayCallable.this._2xx_success();
                            } else if (statusCode >= 300 && statusCode < 400) {
                                TwoWayCallable.this._3xx_redirection();
                            } else if (statusCode >= 400 && statusCode < 600) {
                                TwoWayCallable.this._4xx_5xx_error();
                            } else {
                                TwoWayCallable.this.unmanagedStatus();
                            }
                        }
                        catch (Exception e) {
                            TwoWayCallable.this.replyWithFailure("Exception occured while processing the HTTP response of a two-way request. mexId= " + TwoWayCallable.this.mexId, e);
                        }
                        return null;
                    }
                });
            }
            catch (Exception transactionException) {
                String errmsg = "[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + this.operation.getName() + "] Error executing reply transaction; reply will be lost.";
                log.error((Object)errmsg, (Throwable)transactionException);
            }
        }

        private void unmanagedStatus() throws Exception {
            this.replyWithFailure("Unmanaged Status Code! Status-Line: " + this.method.getStatusLine() + " for " + this.method.getURI());
        }

        private void _4xx_5xx_error() throws Exception {
            int status = this.method.getStatusCode();
            if (HttpHelper.isFaultOrFailure(status) > 0) {
                this.replyWithFault();
            } else {
                this.replyWithFailure("HTTP Status-Line: " + this.method.getStatusLine() + " for " + this.method.getURI());
            }
        }

        private void _3xx_redirection() throws Exception {
            this.replyWithFailure("Redirections disabled! HTTP Status-Line: " + this.method.getStatusLine() + " for " + this.method.getURI());
        }

        private void _2xx_success() throws Exception {
            PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)HttpExternalService.this.server.getEngine().getMessageExchange(this.mexId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + this.operation.getName() + "] HTTP Status-Line: " + this.method.getStatusLine() + " for " + this.method.getURI()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received response for MEX " + odeMex));
            }
            Operation opDef = odeMex.getOperation();
            QName outputMsgName = odeMex.getOperation().getOutput().getMessage().getQName();
            Message odeResponse = odeMex.createMessage(outputMsgName);
            HttpExternalService.this.httpMethodConverter.parseHttpResponse(odeResponse, this.method, opDef);
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Response: " + (odeResponse.getMessage() != null ? DOMUtils.domToString(odeResponse.getMessage()) : "empty")));
                }
                odeMex.reply(odeResponse);
            }
            catch (Exception ex) {
                this.replyWithFailure("Unable to process response: " + ex.getMessage(), ex);
            }
        }

        void replyWithFault() {
            PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)HttpExternalService.this.server.getEngine().getMessageExchange(this.mexId);
            Object[] fault = HttpExternalService.this.httpMethodConverter.parseFault(odeMex, this.method);
            Message response = (Message)fault[1];
            QName faultName = (QName)fault[0];
            if (log.isWarnEnabled()) {
                log.warn((Object)("[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + this.operation.getName() + "] Fault response: faultName=" + faultName + " faultType=" + response.getType() + "\n" + DOMUtils.domToString(response.getMessage())));
            }
            odeMex.replyWithFault(faultName, response);
        }

        void replyWithFailure(String errmsg) {
            this.replyWithFailure(errmsg, null);
        }

        void replyWithFailure(String errmsg, Throwable t) {
            log.error((Object)("[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + this.operation.getName() + "] " + errmsg), t);
            PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)HttpExternalService.this.server.getEngine().getMessageExchange(this.mexId);
            odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, HttpHelper.prepareDetailsElement(this.method));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OneWayCallable
    implements Callable<Void> {
        HttpMethod method;
        String mexId;
        Operation operation;
        HttpClient client;

        public OneWayCallable(HttpClient client, HttpMethod method, String mexId, Operation operation) {
            this.method = method;
            this.mexId = mexId;
            this.operation = operation;
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executing HTTP Request : " + this.method.getName() + " " + this.method.getURI()));
                    log.debug((Object)HttpHelper.requestToString(this.method));
                }
                int statusCode = this.client.executeMethod(this.method);
                byte[] responseBody = this.method.getResponseBody();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Received response for MEX " + this.mexId));
                    log.debug((Object)HttpHelper.responseToString(this.method));
                }
                this.processResponse(statusCode);
            }
            catch (IOException e) {
                try {
                    HttpExternalService.this.scheduler.execTransaction(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)HttpExternalService.this.server.getEngine().getMessageExchange(OneWayCallable.this.mexId);
                            String errmsg = "Unable to execute http request : " + e.getMessage();
                            log.error((Object)("[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + OneWayCallable.this.operation.getName() + "] " + errmsg), (Throwable)e);
                            odeMex.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, errmsg, null);
                            return null;
                        }
                    });
                }
                catch (Exception e1) {
                    String errmsg = "[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + this.operation.getName() + "] Error executing reply transaction; reply will be lost.";
                    log.error((Object)errmsg, (Throwable)e);
                }
            }
            finally {
                this.method.releaseConnection();
            }
            return null;
        }

        public void processResponse(int statusCode) {
            try {
                if (statusCode >= 400) {
                    log.error((Object)("OneWay HTTP Request failed, Status-Line: " + this.method.getStatusLine() + " for " + this.method.getURI()));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("OneWay HTTP Request, Status-Line: " + this.method.getStatusLine() + " for " + this.method.getURI()));
                }
            }
            catch (Exception e) {
                String errmsg = "[Service: " + HttpExternalService.this.serviceName + ", Port: " + HttpExternalService.this.portName + ", Operation: " + this.operation.getName() + "] Exception occured while processing the HTTP response of a one-way request: " + e.getMessage();
                log.error((Object)errmsg, (Throwable)e);
            }
        }
    }
}

