/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.hooks;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SessionInHandler
extends AbstractHandler {
    private static final long serialVersionUID = -806564877582696569L;
    private static final Log __log = LogFactory.getLog(SessionInHandler.class);

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        SOAPHeader header = messageContext.getEnvelope().getHeader();
        if (header != null) {
            OMElement callbackSession;
            OMElement callback;
            OMElement wsaToSession;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Found a header in incoming message, checking if there are endpoints there.");
            }
            if ((wsaToSession = header.getFirstChildWithName(new QName(Namespaces.INTALIO_SESSION_NS, "session"))) != null) {
                OMElement wsaToAddress;
                Document doc = DOMUtils.newDocument();
                Element serviceEpr = doc.createElementNS(Namespaces.WS_ADDRESSING_NS, "EndpointReference");
                Element sessionId = doc.createElementNS(Namespaces.INTALIO_SESSION_NS, "session");
                doc.appendChild(serviceEpr);
                serviceEpr.appendChild(sessionId);
                sessionId.setTextContent(wsaToSession.getText());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("A TO endpoint has been found in the header with session: " + wsaToSession.getText()));
                }
                if ((wsaToAddress = header.getFirstChildWithName(new QName(Namespaces.WS_ADDRESSING_NS, "To"))) != null) {
                    Element addressElmt = doc.createElementNS(Namespaces.WS_ADDRESSING_NS, "Address");
                    addressElmt.setTextContent(wsaToAddress.getText());
                    serviceEpr.appendChild(addressElmt);
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Constructed a TO endpoint: " + DOMUtils.domToString(serviceEpr)));
                }
                messageContext.setProperty("targetSessionEndpoint", (Object)serviceEpr);
            }
            if ((callback = header.getFirstChildWithName(new QName(Namespaces.INTALIO_SESSION_NS, "callback"))) != null && (callbackSession = callback.getFirstChildWithName(new QName(Namespaces.INTALIO_SESSION_NS, "session"))) != null) {
                OMElement wsaToAddress;
                Document doc = DOMUtils.newDocument();
                Element serviceEpr = doc.createElementNS(Namespaces.WS_ADDRESSING_NS, "EndpointReference");
                Element sessionId = doc.createElementNS(Namespaces.INTALIO_SESSION_NS, "session");
                doc.appendChild(serviceEpr);
                serviceEpr.appendChild(sessionId);
                sessionId.setTextContent(callbackSession.getText());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("A CALLBACK endpoint has been found in the header with session: " + callbackSession.getText()));
                }
                if ((wsaToAddress = callback.getFirstChildWithName(new QName(Namespaces.WS_ADDRESSING_NS, "Address"))) != null) {
                    Element addressElmt = doc.createElementNS(Namespaces.WS_ADDRESSING_NS, "Address");
                    addressElmt.setTextContent(wsaToAddress.getText());
                    serviceEpr.appendChild(addressElmt);
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Constructed a CALLBACK endpoint: " + DOMUtils.domToString(serviceEpr)));
                }
                messageContext.setProperty("callbackSessionEndpoint", (Object)serviceEpr);
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

