/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.codemodel.JJavaName;
import com.sun.codemodel.util.JavadocEscapeWriter;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassInfoParent;
import com.sun.tools.xjc.model.CClassRef;
import com.sun.tools.xjc.model.CEnumConstant;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.model.TypeUse;
import com.sun.tools.xjc.model.TypeUseFactory;
import com.sun.tools.xjc.reader.Ring;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.xjc.reader.xmlschema.BindingComponent;
import com.sun.tools.xjc.reader.xmlschema.Messages;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIConversion;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIEnum;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIEnumMember;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIProperty;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.EnumMemberMode;
import com.sun.tools.xjc.util.MimeTypeRange;
import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.v2.runtime.SwaRefAdapter;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.XSVariety;
import com.sun.xml.xsom.impl.util.SchemaWriter;
import com.sun.xml.xsom.visitor.XSSimpleTypeFunction;
import java.io.StringWriter;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.activation.MimeTypeParseException;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleTypeBuilder
extends BindingComponent {
    protected final BGMBuilder builder = Ring.get(BGMBuilder.class);
    private final Model model = Ring.get(Model.class);
    public final Stack<XSComponent> refererStack = new Stack();
    private final Set<XSComponent> acknowledgedXmimeContentTypes = new HashSet<XSComponent>();
    private XSSimpleType initiatingType;
    public static final Map<String, TypeUse> builtinConversions;
    public final XSSimpleTypeFunction<TypeUse> composer = new XSSimpleTypeFunction<TypeUse>(){

        @Override
        public TypeUse listSimpleType(XSListSimpleType type) {
            XSSimpleType itemType = type.getItemType();
            SimpleTypeBuilder.this.refererStack.push(itemType);
            TypeUse tu = TypeUseFactory.makeCollection(SimpleTypeBuilder.this.build(type.getItemType()));
            SimpleTypeBuilder.this.refererStack.pop();
            return tu;
        }

        @Override
        public TypeUse unionSimpleType(XSUnionSimpleType type) {
            boolean isCollection = false;
            for (int i = 0; i < type.getMemberSize(); ++i) {
                if (type.getMember(i).getVariety() != XSVariety.LIST) continue;
                isCollection = true;
                break;
            }
            TypeUse r = CBuiltinLeafInfo.STRING;
            if (isCollection) {
                r = TypeUseFactory.makeCollection(r);
            }
            return r;
        }

        @Override
        public TypeUse restrictionSimpleType(XSRestrictionSimpleType type) {
            return SimpleTypeBuilder.this.compose(type.getSimpleBaseType());
        }
    };
    private static final Set<String> builtinTypeSafeEnumCapableTypes;
    private static final BigInteger LONG_MIN;
    private static final BigInteger LONG_MAX;
    private static final BigInteger INT_MIN;
    private static final BigInteger INT_MAX;

    public TypeUse build(XSSimpleType type) {
        XSSimpleType oldi = this.initiatingType;
        this.initiatingType = type;
        TypeUse e = this.checkRefererCustomization(type);
        if (e == null) {
            e = this.compose(type);
        }
        this.initiatingType = oldi;
        return e;
    }

    public TypeUse buildDef(XSSimpleType type) {
        XSSimpleType oldi = this.initiatingType;
        this.initiatingType = type;
        TypeUse e = type.apply(this.composer);
        this.initiatingType = oldi;
        return e;
    }

    private BIConversion getRefererCustomization() {
        BindInfo info = this.builder.getBindInfo(this.getReferer());
        BIProperty prop = info.get(BIProperty.class);
        if (prop == null) {
            return null;
        }
        return prop.getConv();
    }

    public XSComponent getReferer() {
        return this.refererStack.peek();
    }

    private TypeUse checkRefererCustomization(XSSimpleType type) {
        XSComponent top = this.getReferer();
        if (top instanceof XSElementDecl) {
            XSElementDecl eref = (XSElementDecl)top;
            assert (eref.getType() == type);
            BindInfo info = this.builder.getBindInfo(top);
            BIConversion conv = info.get(BIConversion.class);
            if (conv != null) {
                conv.markAsAcknowledged();
                return conv.getTypeUse(type);
            }
            this.detectJavaTypeCustomization();
        } else if (top instanceof XSAttributeDecl) {
            XSAttributeDecl aref = (XSAttributeDecl)top;
            assert (aref.getType() == type);
            this.detectJavaTypeCustomization();
        } else if (top instanceof XSComplexType) {
            XSComplexType tref = (XSComplexType)top;
            assert (tref.getBaseType() == type || tref.getContentType() == type);
            this.detectJavaTypeCustomization();
        } else if (top != type) assert (false);
        BIConversion conv = this.getRefererCustomization();
        if (conv != null) {
            conv.markAsAcknowledged();
            return conv.getTypeUse(type);
        }
        return null;
    }

    private void detectJavaTypeCustomization() {
        BindInfo info = this.builder.getBindInfo(this.getReferer());
        BIConversion conv = info.get(BIConversion.class);
        if (conv != null) {
            conv.markAsAcknowledged();
            this.getErrorReporter().error(conv.getLocation(), "SimpleTypeBuilder.UnnestedJavaTypeCustomization", new Object[0]);
        }
    }

    TypeUse compose(XSSimpleType t) {
        TypeUse e = this.find(t);
        if (e != null) {
            return e;
        }
        return t.apply(this.composer);
    }

    private TypeUse find(XSSimpleType type) {
        XSRestrictionSimpleType rst;
        TypeUse r;
        String name;
        boolean noAutoEnum = false;
        BindInfo info = this.builder.getBindInfo(type);
        BIConversion conv = info.get(BIConversion.class);
        if (conv != null) {
            conv.markAsAcknowledged();
            return conv.getTypeUse(type);
        }
        BIEnum en = info.get(BIEnum.class);
        if (en != null) {
            en.markAsAcknowledged();
            if (!en.isMapped()) {
                noAutoEnum = true;
            } else {
                if (!SimpleTypeBuilder.canBeMappedToTypeSafeEnum(type)) {
                    this.getErrorReporter().error(en.getLocation(), "ConversionFinder.CannotBeTypeSafeEnum", new Object[0]);
                    this.getErrorReporter().error(type.getLocator(), "ConversionFinder.CannotBeTypeSafeEnum.Location", new Object[0]);
                    return null;
                }
                if (en.ref != null) {
                    if (!JJavaName.isFullyQualifiedClassName(en.ref)) {
                        Ring.get(ErrorReceiver.class).error(en.getLocation(), Messages.format("ClassSelector.IncorrectClassName", en.ref));
                        return null;
                    }
                    return new CClassRef(this.model, (XSComponent)type, en, info.toCustomizationList());
                }
                return this.bindToTypeSafeEnum((XSRestrictionSimpleType)type, en.className, en.javadoc, en.members, this.getEnumMemberMode().getModeWithEnum(), en.getLocation());
            }
        }
        if (type.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema") && (name = type.getName()) != null && (r = this.lookupBuiltin(name)) != null) {
            return r;
        }
        if (type.getTargetNamespace().equals("http://ws-i.org/profiles/basic/1.1/xsd") && (name = type.getName()) != null && name.equals("swaRef")) {
            return CBuiltinLeafInfo.STRING.makeAdapted(SwaRefAdapter.class, false);
        }
        if (type.isRestriction() && !noAutoEnum && this.shouldBeMappedToTypeSafeEnumByDefault(rst = type.asRestriction()) && (r = this.bindToTypeSafeEnum(rst, null, null, Collections.<String, BIEnumMember>emptyMap(), this.getEnumMemberMode(), null)) != null) {
            return r;
        }
        return (CNonElement)this.getClassSelector()._bindToClass(type, null, false);
    }

    private boolean shouldBeMappedToTypeSafeEnumByDefault(XSRestrictionSimpleType type) {
        if (type.isLocal()) {
            return false;
        }
        if (type.getRedefinedBy() != null) {
            return false;
        }
        List<XSFacet> facets = type.getDeclaredFacets("enumeration");
        if (facets.isEmpty() || facets.size() > this.builder.getGlobalBinding().getDefaultEnumMemberSizeCap()) {
            return false;
        }
        if (!SimpleTypeBuilder.canBeMappedToTypeSafeEnum(type)) {
            return false;
        }
        for (XSSimpleType t = type; t != null; t = t.getSimpleBaseType()) {
            if (!t.isGlobal() || !this.builder.getGlobalBinding().canBeMappedToTypeSafeEnum(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean canBeMappedToTypeSafeEnum(XSSimpleType type) {
        do {
            String localName;
            if (!"http://www.w3.org/2001/XMLSchema".equals(type.getTargetNamespace()) || (localName = type.getName()) == null) continue;
            if (localName.equals("anySimpleType")) {
                return false;
            }
            if (localName.equals("ID") || localName.equals("IDREF")) {
                return false;
            }
            if (!builtinTypeSafeEnumCapableTypes.contains(localName)) continue;
            return true;
        } while ((type = type.getSimpleBaseType()) != null);
        return false;
    }

    private TypeUse bindToTypeSafeEnum(XSRestrictionSimpleType type, String className, String javadoc, Map<String, BIEnumMember> members, EnumMemberMode mode, Locator loc) {
        if (loc == null) {
            loc = type.getLocator();
        }
        if (className == null) {
            if (!type.isGlobal()) {
                this.getErrorReporter().error(loc, "ConversionFinder.NoEnumNameAvailable", new Object[0]);
                return CBuiltinLeafInfo.STRING;
            }
            className = type.getName();
        }
        className = this.builder.deriveName(className, type);
        StringWriter out = new StringWriter();
        SchemaWriter sw = new SchemaWriter(new JavadocEscapeWriter(out));
        type.visit(sw);
        javadoc = javadoc != null ? javadoc + "\n\n" : "";
        javadoc = javadoc + Messages.format("ClassSelector.JavadocHeading", type.getName()) + "\n<p>\n<pre>\n" + out.getBuffer() + "</pre>";
        this.refererStack.push(type.getSimpleBaseType());
        TypeUse use = this.build(type.getSimpleBaseType());
        this.refererStack.pop();
        if (use.isCollection()) {
            return null;
        }
        CNonElement baseDt = use.getInfo();
        if (baseDt instanceof CClassInfo) {
            return null;
        }
        XSFacet[] errorRef = new XSFacet[1];
        List<CEnumConstant> memberList = this.buildCEnumConstants(type, false, members, errorRef);
        if (memberList == null || this.checkMemberNameCollision(memberList) != null) {
            switch (mode) {
                case SKIP: {
                    return null;
                }
                case ERROR: {
                    if (memberList == null) {
                        this.getErrorReporter().error(errorRef[0].getLocator(), "ERR_CANNOT_GENERATE_ENUM_NAME", errorRef[0].getValue());
                    } else {
                        CEnumConstant[] collision = this.checkMemberNameCollision(memberList);
                        this.getErrorReporter().error(collision[0].getLocator(), "ERR_ENUM_MEMBER_NAME_COLLISION", collision[0].getName());
                        this.getErrorReporter().error(collision[1].getLocator(), "ERR_ENUM_MEMBER_NAME_COLLISION_RELATED", new Object[0]);
                    }
                    return null;
                }
                case GENERATE: {
                    memberList = this.buildCEnumConstants(type, true, members, null);
                }
            }
        }
        CClassInfoParent scope = type.isGlobal() ? new CClassInfoParent.Package(this.getClassSelector().getPackage(type.getTargetNamespace())) : this.getClassSelector().getClassScope();
        CEnumLeafInfo xducer = new CEnumLeafInfo(this.model, BGMBuilder.getName(type), scope, className, baseDt, memberList, type, this.builder.getBindInfo(type).toCustomizationList(), loc);
        xducer.javadoc = javadoc;
        BIConversion.Static conv = new BIConversion.Static(type.getLocator(), xducer);
        conv.markAsAcknowledged();
        this.builder.getOrCreateBindInfo(type).addDecl(conv);
        return ((BIConversion)conv).getTypeUse(type);
    }

    private List<CEnumConstant> buildCEnumConstants(XSRestrictionSimpleType type, boolean needsToGenerateMemberName, Map<String, BIEnumMember> members, XSFacet[] errorRef) {
        ArrayList<CEnumConstant> memberList = new ArrayList<CEnumConstant>();
        int idx = 1;
        HashSet<String> enums = new HashSet<String>();
        for (XSFacet facet2 : type.getDeclaredFacets("enumeration")) {
            String name = null;
            String mdoc = this.builder.getBindInfo(facet2).getDocumentation();
            if (!enums.add(facet2.getValue().value)) continue;
            if (needsToGenerateMemberName) {
                name = "VALUE_" + idx++;
            } else {
                String facetValue = facet2.getValue().value;
                BIEnumMember mem = members.get(facetValue);
                if (mem == null) {
                    mem = this.builder.getBindInfo(facet2).get(BIEnumMember.class);
                }
                if (mem != null) {
                    name = mem.name;
                    mdoc = mem.javadoc;
                }
                if (name == null) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < facetValue.length(); ++i) {
                        char ch = facetValue.charAt(i);
                        if (Character.isJavaIdentifierPart(ch)) {
                            sb.append(ch);
                            continue;
                        }
                        sb.append('_');
                    }
                    name = this.model.getNameConverter().toConstantName(sb.toString());
                }
            }
            if (!JJavaName.isJavaIdentifier(name)) {
                if (errorRef != null) {
                    errorRef[0] = facet2;
                }
                return null;
            }
            memberList.add(new CEnumConstant(name, mdoc, facet2.getValue().value, facet2.getLocator()));
        }
        return memberList;
    }

    private CEnumConstant[] checkMemberNameCollision(List<CEnumConstant> memberList) {
        HashMap<String, CEnumConstant> names = new HashMap<String, CEnumConstant>();
        for (CEnumConstant c : memberList) {
            CEnumConstant old = names.put(c.getName(), c);
            if (old == null) continue;
            return new CEnumConstant[]{old, c};
        }
        return null;
    }

    private EnumMemberMode getEnumMemberMode() {
        return this.builder.getGlobalBinding().getEnumMemberMode();
    }

    private TypeUse lookupBuiltin(String typeLocalName) {
        if (typeLocalName.equals("integer") || typeLocalName.equals("long")) {
            BigInteger ni;
            BigInteger ne;
            BigInteger min;
            BigInteger xi;
            BigInteger xe = this.readFacet("maxExclusive", -1);
            BigInteger max = this.min(xe, xi = this.readFacet("maxInclusive", 0));
            if (max != null && (min = this.max(ne = this.readFacet("minExclusive", 1), ni = this.readFacet("minInclusive", 0))) != null) {
                if (min.compareTo(INT_MIN) >= 0 && max.compareTo(INT_MAX) <= 0) {
                    typeLocalName = "int";
                } else if (min.compareTo(LONG_MIN) >= 0 && max.compareTo(LONG_MAX) <= 0) {
                    typeLocalName = "long";
                }
            }
        } else {
            if (typeLocalName.equals("boolean") && this.isRestrictedTo0And1()) {
                return CBuiltinLeafInfo.BOOLEAN_ZERO_OR_ONE;
            }
            if (typeLocalName.equals("base64Binary")) {
                return this.lookupBinaryTypeBinding();
            }
            if (typeLocalName.equals("anySimpleType")) {
                if (this.getReferer() instanceof XSAttributeDecl || this.getReferer() instanceof XSSimpleType) {
                    return CBuiltinLeafInfo.STRING;
                }
                return CBuiltinLeafInfo.ANYTYPE;
            }
        }
        return builtinConversions.get(typeLocalName);
    }

    private TypeUse lookupBinaryTypeBinding() {
        XSComponent referer = this.getReferer();
        String emt = referer.getForeignAttribute("http://www.w3.org/2005/05/xmlmime", "expectedContentTypes");
        if (emt != null) {
            this.acknowledgedXmimeContentTypes.add(referer);
            try {
                List<MimeTypeRange> types = MimeTypeRange.parseRanges(emt);
                MimeTypeRange mt = MimeTypeRange.merge(types);
                if (mt.majorType.equals("image")) {
                    return CBuiltinLeafInfo.IMAGE.makeMimeTyped(mt.toMimeType());
                }
                if ((mt.majorType.equals("application") || mt.majorType.equals("text")) && this.isXml(mt.subType)) {
                    return CBuiltinLeafInfo.XML_SOURCE.makeMimeTyped(mt.toMimeType());
                }
                if (mt.majorType.equals("text") && mt.subType.equals("plain")) {
                    return CBuiltinLeafInfo.STRING.makeMimeTyped(mt.toMimeType());
                }
                return CBuiltinLeafInfo.DATA_HANDLER.makeMimeTyped(mt.toMimeType());
            }
            catch (ParseException e) {
                this.getErrorReporter().error(referer.getLocator(), Messages.format("ERR_ILLEGAL_EXPECTED_MIME_TYPE", emt, e.getMessage()), new Object[0]);
            }
            catch (MimeTypeParseException e) {
                this.getErrorReporter().error(referer.getLocator(), Messages.format("ERR_ILLEGAL_EXPECTED_MIME_TYPE", emt, e.getMessage()), new Object[0]);
            }
        }
        return CBuiltinLeafInfo.BASE64_BYTE_ARRAY;
    }

    public boolean isAcknowledgedXmimeContentTypes(XSComponent c) {
        return this.acknowledgedXmimeContentTypes.contains(c);
    }

    private boolean isXml(String subType) {
        return subType.equals("xml") || subType.endsWith("+xml");
    }

    private boolean isRestrictedTo0And1() {
        String v;
        String v2;
        XSFacet pattern = this.initiatingType.getFacet("pattern");
        if (pattern != null && ((v2 = pattern.getValue().value).equals("0|1") || v2.equals("1|0") || v2.equals("\\d"))) {
            return true;
        }
        XSFacet enumf = this.initiatingType.getFacet("enumeration");
        return enumf != null && ((v = enumf.getValue().value).equals("0") || v.equals("1"));
    }

    private BigInteger readFacet(String facetName, int offset) {
        XSFacet me = this.initiatingType.getFacet(facetName);
        if (me == null) {
            return null;
        }
        BigInteger bi = DatatypeConverterImpl._parseInteger(me.getValue().value);
        if (offset != 0) {
            bi = bi.add(BigInteger.valueOf(offset));
        }
        return bi;
    }

    private BigInteger min(BigInteger a, BigInteger b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.min(b);
    }

    private BigInteger max(BigInteger a, BigInteger b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.max(b);
    }

    static {
        String[] typeNames;
        builtinConversions = new HashMap<String, TypeUse>();
        HashSet<String> s = new HashSet<String>();
        for (String type : typeNames = new String[]{"string", "boolean", "float", "decimal", "double", "anyURI"}) {
            s.add(type);
        }
        builtinTypeSafeEnumCapableTypes = Collections.unmodifiableSet(s);
        LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
        LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
        INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
        INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
        Map<String, TypeUse> m = builtinConversions;
        m.put("string", CBuiltinLeafInfo.STRING);
        m.put("anyURI", CBuiltinLeafInfo.STRING);
        m.put("boolean", CBuiltinLeafInfo.BOOLEAN);
        m.put("hexBinary", CBuiltinLeafInfo.HEXBIN_BYTE_ARRAY);
        m.put("float", CBuiltinLeafInfo.FLOAT);
        m.put("decimal", CBuiltinLeafInfo.BIG_DECIMAL);
        m.put("integer", CBuiltinLeafInfo.BIG_INTEGER);
        m.put("long", CBuiltinLeafInfo.LONG);
        m.put("unsignedInt", CBuiltinLeafInfo.LONG);
        m.put("int", CBuiltinLeafInfo.INT);
        m.put("unsignedShort", CBuiltinLeafInfo.INT);
        m.put("short", CBuiltinLeafInfo.SHORT);
        m.put("unsignedByte", CBuiltinLeafInfo.SHORT);
        m.put("byte", CBuiltinLeafInfo.BYTE);
        m.put("double", CBuiltinLeafInfo.DOUBLE);
        m.put("QName", CBuiltinLeafInfo.QNAME);
        m.put("NOTATION", CBuiltinLeafInfo.QNAME);
        m.put("dateTime", CBuiltinLeafInfo.CALENDAR);
        m.put("date", CBuiltinLeafInfo.CALENDAR);
        m.put("time", CBuiltinLeafInfo.CALENDAR);
        m.put("gYearMonth", CBuiltinLeafInfo.CALENDAR);
        m.put("gYear", CBuiltinLeafInfo.CALENDAR);
        m.put("gMonthDay", CBuiltinLeafInfo.CALENDAR);
        m.put("gDay", CBuiltinLeafInfo.CALENDAR);
        m.put("gMonth", CBuiltinLeafInfo.CALENDAR);
        m.put("duration", CBuiltinLeafInfo.DURATION);
        m.put("token", CBuiltinLeafInfo.TOKEN);
        m.put("normalizedString", CBuiltinLeafInfo.NORMALIZED_STRING);
        m.put("ID", CBuiltinLeafInfo.ID);
        m.put("IDREF", CBuiltinLeafInfo.IDREF);
    }
}

