/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.episode;

import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.bind.v2.schemagen.episode.Bindings;
import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.output.StreamSerializer;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.visitor.XSFunction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PluginImpl
extends Plugin {
    private File episodeFile;
    private static final XSFunction<String> SCD = new XSFunction<String>(){

        private String name(XSDeclaration decl) {
            if (decl.getTargetNamespace().equals("")) {
                return decl.getName();
            }
            return "tns:" + decl.getName();
        }

        @Override
        public String complexType(XSComplexType type) {
            return "~" + this.name(type);
        }

        @Override
        public String simpleType(XSSimpleType simpleType2) {
            return "~" + this.name(simpleType2);
        }

        @Override
        public String elementDecl(XSElementDecl decl) {
            return this.name(decl);
        }

        @Override
        public String annotation(XSAnnotation ann) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String attGroupDecl(XSAttGroupDecl decl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String attributeDecl(XSAttributeDecl decl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String attributeUse(XSAttributeUse use) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String schema(XSSchema schema) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String facet(XSFacet facet2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String notation(XSNotation notation2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String identityConstraint(XSIdentityConstraint decl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String xpath(XSXPath xpath2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String particle(XSParticle particle2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String empty(XSContentType empty) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String wildcard(XSWildcard wc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String modelGroupDecl(XSModelGroupDecl decl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String modelGroup(XSModelGroup group2) {
            throw new UnsupportedOperationException();
        }
    };

    public String getOptionName() {
        return "episode";
    }

    public String getUsage() {
        return "  -episode <FILE>    :  generate the episode file for separate compilation";
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        if (args[i].equals("-episode")) {
            this.episodeFile = new File(opt.requireArgument("-episode", args, ++i));
            return 2;
        }
        return 0;
    }

    public boolean run(Outline model, Options opt, ErrorHandler errorHandler) throws SAXException {
        try {
            HashMap<XSSchema, ArrayList<ClassOutline>> perSchema = new HashMap<XSSchema, ArrayList<ClassOutline>>();
            boolean hasComponentInNoNamespace = false;
            for (ClassOutline classOutline : model.getClasses()) {
                XSDeclaration decl;
                XSComponent sc = classOutline.target.getSchemaComponent();
                if (sc == null || !(sc instanceof XSDeclaration) || (decl = (XSDeclaration)sc).isLocal()) continue;
                ArrayList<ClassOutline> list = (ArrayList<ClassOutline>)perSchema.get(decl.getOwnerSchema());
                if (list == null) {
                    list = new ArrayList<ClassOutline>();
                    perSchema.put(decl.getOwnerSchema(), list);
                }
                list.add(classOutline);
                if (!decl.getTargetNamespace().equals("")) continue;
                hasComponentInNoNamespace = true;
            }
            FileOutputStream os = new FileOutputStream(this.episodeFile);
            Bindings bindings = TXW.create(Bindings.class, new StreamSerializer(os, "UTF-8"));
            if (hasComponentInNoNamespace) {
                bindings._namespace("http://java.sun.com/xml/ns/jaxb", "jaxb");
            } else {
                bindings._namespace("http://java.sun.com/xml/ns/jaxb", "");
            }
            bindings.version("2.1");
            bindings._comment("\n\n" + opt.getPrologComment() + "\n  ");
            for (Map.Entry e : perSchema.entrySet()) {
                Bindings group2 = bindings.bindings();
                String tns = ((XSSchema)e.getKey()).getTargetNamespace();
                if (!tns.equals("")) {
                    group2._namespace(tns, "tns");
                }
                group2.scd("x-schema::" + (tns.equals("") ? "" : "tns"));
                group2.schemaBindings().map(false);
                for (ClassOutline co : (List)e.getValue()) {
                    Bindings child = group2.bindings();
                    child.scd(co.target.getSchemaComponent().apply(SCD));
                    child.klass().ref(co.implClass.fullName());
                }
                group2.commit(true);
            }
            bindings.commit();
            return true;
        }
        catch (IOException e) {
            errorHandler.error(new SAXParseException("Failed to write to " + this.episodeFile, null, e));
            return false;
        }
    }
}

