/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Element;
import org.wso2.carbon.bpel.core.ode.integration.BPELMessageContext;
import org.wso2.carbon.bpel.core.ode.integration.BPELProcessProxy;
import org.wso2.carbon.bpel.core.ode.integration.axis2.Axis2UriResolver;
import org.wso2.carbon.bpel.core.ode.integration.axis2.Axis2WSDLLocator;
import org.wso2.carbon.bpel.core.ode.integration.axis2.receivers.BPELMessageReceiver;
import org.wso2.carbon.bpel.core.ode.integration.utils.AnonymousServiceFactory;

public final class AxisServiceUtils {
    private static final Log log = LogFactory.getLog(AxisServiceUtils.class);

    private AxisServiceUtils() {
    }

    public static AxisService createAxisService(AxisConfiguration axisConfiguration, BPELProcessProxy processProxy) throws AxisFault {
        QName serviceName = processProxy.getServiceName();
        String portName = processProxy.getPort();
        Definition wsdlDefinition = processProxy.getWsdlDefinition();
        ProcessConf processConfiguration = processProxy.getProcessConfiguration();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating AxisService: Service=" + serviceName + " port=" + portName + " WSDL=" + wsdlDefinition.getDocumentBaseURI() + " BPEL=" + processConfiguration.getBpelDocument()));
        }
        WSDL11ToAxisServiceBuilder serviceBuilder = AxisServiceUtils.createAxisServiceBuilder(processProxy);
        AxisService axisService = AxisServiceUtils.populateAxisService(processProxy, axisConfiguration, serviceBuilder);
        Iterator operations = axisService.getOperations();
        BPELMessageReceiver messageRec = new BPELMessageReceiver();
        messageRec.setProcessProxy(processProxy);
        while (operations.hasNext()) {
            AxisOperation operation = (AxisOperation)operations.next();
            operation.setMessageReceiver((MessageReceiver)messageRec);
        }
        return axisService;
    }

    private static AxisService populateAxisService(BPELProcessProxy processProxy, AxisConfiguration axisConfiguration, WSDL11ToAxisServiceBuilder serviceBuilder) throws AxisFault {
        ProcessConf pConf = processProxy.getProcessConfiguration();
        AxisService axisService = serviceBuilder.populateService();
        axisService.setParent((AxisDescription)axisConfiguration);
        axisService.setWsdlFound(true);
        axisService.setCustomWsdl(true);
        axisService.setClassLoader(axisConfiguration.getServiceClassLoader());
        URL wsdlUrl = null;
        for (File file : pConf.getFiles()) {
            if (file.getAbsolutePath().indexOf(processProxy.getWsdlDefinition().getDocumentBaseURI()) <= 0) continue;
            try {
                wsdlUrl = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                String errorMessage = "Cannot convert File URI to URL.";
                AxisServiceUtils.handleException(pConf.getProcessId(), errorMessage, e);
            }
        }
        if (wsdlUrl != null) {
            axisService.setFileName(wsdlUrl);
        }
        Utils.setEndpointsToAllUsedBindings((AxisService)axisService);
        axisService.addParameter(new Parameter("useOriginalwsdl", (Object)"true"));
        axisService.addParameter(new Parameter("modifyUserWSDLPortAddress", (Object)"true"));
        axisService.addParameter(new Parameter("setEndpointsToAllUsedBindings", (Object)"true"));
        axisService.addParameter("serviceType", (Object)"bpel");
        axisService.addParameter("processId", (Object)pConf.getProcessId());
        axisService.addParameter(new Parameter("preserveServiceHistory", (Object)"true"));
        axisService.addParameter(new Parameter("messageReceiver.invokeOnSeparateThread", (Object)"true"));
        return axisService;
    }

    private static WSDL11ToAxisServiceBuilder createAxisServiceBuilder(BPELProcessProxy processProxy) throws AxisFault {
        String errMsg;
        Definition wsdlDef = processProxy.getWsdlDefinition();
        QName serviceName = processProxy.getServiceName();
        String portName = processProxy.getPort();
        ProcessConf pConf = processProxy.getProcessConfiguration();
        QName pid = pConf.getProcessId();
        InputStream wsdlInStream = null;
        URI wsdlBaseURI = pConf.getBaseURI().resolve(wsdlDef.getDocumentBaseURI());
        try {
            wsdlInStream = wsdlBaseURI.toURL().openStream();
        }
        catch (MalformedURLException e) {
            errMsg = "Malformed WSDL base URI.";
            AxisServiceUtils.handleException(pid, errMsg, e);
        }
        catch (IOException e) {
            errMsg = "Error opening stream.";
            AxisServiceUtils.handleException(pid, errMsg, e);
        }
        WSDL11ToAxisPatchedBuilder serviceBuilder = new WSDL11ToAxisPatchedBuilder(wsdlInStream, serviceName, portName);
        serviceBuilder.setBaseUri(wsdlBaseURI.toString());
        serviceBuilder.setCustomResolver(new Axis2UriResolver());
        try {
            serviceBuilder.setCustomWSDLResolver(new Axis2WSDLLocator(wsdlBaseURI));
        }
        catch (URISyntaxException e) {
            String errorMessage = "URI syntax invalid.";
            AxisServiceUtils.handleException(pid, errorMessage, e);
        }
        serviceBuilder.setServerSide(true);
        return serviceBuilder;
    }

    private static void handleException(QName pid, String errorMessage, Exception e) throws AxisFault {
        String tErrorMessage = "Error creating axis service for process " + pid + ".Cause: " + errorMessage;
        log.error((Object)tErrorMessage, (Throwable)e);
        throw new AxisFault(tErrorMessage, (Throwable)e);
    }

    public static void invokeService(BPELMessageContext partnerInvocationContext, ConfigurationContext configContext) throws AxisFault {
        MessageContext mctx = partnerInvocationContext.getInMessageContext();
        OperationClient opClient = AxisServiceUtils.getOperationClient(partnerInvocationContext, configContext);
        mctx.getOptions().setParent(opClient.getOptions());
        opClient.addMessageContext(mctx);
        Options operationOptions = opClient.getOptions();
        if (partnerInvocationContext.getUep().isAddressingEnabled()) {
            String action = AxisServiceUtils.getAction(partnerInvocationContext);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Soap action: " + action));
            }
            operationOptions.setAction(action);
        }
        if (partnerInvocationContext.getUep().getAddress() == null) {
            partnerInvocationContext.getUep().setAddress(AxisServiceUtils.getEPRfromWSDL(partnerInvocationContext.getBpelServiceWSDLDefinition(), partnerInvocationContext.getService(), partnerInvocationContext.getPort()));
        }
        operationOptions.setTo((EndpointReference)partnerInvocationContext.getUep());
        opClient.execute(true);
        if (partnerInvocationContext.isTwoWay()) {
            partnerInvocationContext.setOutMessageContext(opClient.getMessageContext("In"));
            partnerInvocationContext.setFaultMessageContext(opClient.getMessageContext("Fault"));
        }
    }

    public static String getAction(BPELMessageContext partnerMessageContext) {
        String action = AxisServiceUtils.getWSAInputAction(partnerMessageContext);
        if (action == null || "".equals(action)) {
            action = AxisServiceUtils.getSoapAction(partnerMessageContext);
        }
        return action;
    }

    public static String getWSAInputAction(BPELMessageContext partnerMessageContext) {
        BindingOperation bop = partnerMessageContext.getWsdlBindingForCurrentMessageFlow().getBindingOperation(partnerMessageContext.getOperationName(), null, null);
        if (bop == null) {
            return "";
        }
        Input input = bop.getOperation().getInput();
        if (input != null) {
            Object action = input.getExtensionAttribute(new QName(Namespaces.WS_ADDRESSING_NS, "Action"));
            if (action instanceof String) {
                return (String)action;
            }
            action = input.getExtensionAttribute(new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action"));
            if (action instanceof String) {
                return (String)action;
            }
            action = input.getExtensionAttribute(new QName("http://www.w3.org/2006/02/addressing/wsdl", "Action"));
            if (action instanceof String) {
                return (String)action;
            }
            action = input.getExtensionAttribute(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Action"));
            if (action instanceof String) {
                return (String)action;
            }
        }
        return "";
    }

    public static String getSoapAction(BPELMessageContext partnerMessageContext) {
        BindingOperation bop = partnerMessageContext.getWsdlBindingForCurrentMessageFlow().getBindingOperation(partnerMessageContext.getOperationName(), null, null);
        if (bop == null) {
            return "";
        }
        if (partnerMessageContext.isSoap12()) {
            Iterator i$ = CollectionsX.filter((Collection)bop.getExtensibilityElements(), SOAP12Operation.class).iterator();
            if (i$.hasNext()) {
                SOAP12Operation soapOp = (SOAP12Operation)i$.next();
                return soapOp.getSoapActionURI();
            }
        } else {
            Iterator i$ = CollectionsX.filter((Collection)bop.getExtensibilityElements(), SOAPOperation.class).iterator();
            if (i$.hasNext()) {
                SOAPOperation soapOp = (SOAPOperation)i$.next();
                return soapOp.getSoapActionURI();
            }
        }
        return "";
    }

    public static OperationClient getOperationClient(BPELMessageContext partnerMessageContext, ConfigurationContext clientConfigCtx) throws AxisFault {
        AxisService anonymousService = AnonymousServiceFactory.getAnonymousService(partnerMessageContext.getService(), partnerMessageContext.getPort(), clientConfigCtx.getAxisConfiguration(), partnerMessageContext.getCaller());
        anonymousService.engageModule(clientConfigCtx.getAxisConfiguration().getModule("UEPModule"));
        anonymousService.getParent().addParameter("hiddenService", (Object)"true");
        ServiceGroupContext sgc = new ServiceGroupContext(clientConfigCtx, (AxisServiceGroup)anonymousService.getParent());
        ServiceContext serviceCtx = sgc.getServiceContext(anonymousService);
        AxisOperation axisAnonymousOperation = anonymousService.getOperation(partnerMessageContext.isTwoWay() ? ServiceClient.ANON_OUT_IN_OP : ServiceClient.ANON_OUT_ONLY_OP);
        Options clientOptions = AxisServiceUtils.cloneOptions(partnerMessageContext.getInMessageContext().getOptions());
        clientOptions.setExceptionToBeThrownOnSOAPFault(false);
        clientOptions.setTimeOutInMilliSeconds(60000L);
        return axisAnonymousOperation.createClient(serviceCtx, clientOptions);
    }

    public static Options cloneOptions(Options options) {
        Options clonedOptions = new Options(options.getParent());
        clonedOptions.setCallTransportCleanup(options.isCallTransportCleanup());
        clonedOptions.setExceptionToBeThrownOnSOAPFault(options.isExceptionToBeThrownOnSOAPFault());
        clonedOptions.setManageSession(options.isManageSession());
        clonedOptions.setSoapVersionURI(options.getSoapVersionURI());
        clonedOptions.setTimeOutInMilliSeconds(options.getTimeOutInMilliSeconds());
        clonedOptions.setUseSeparateListener(options.isUseSeparateListener());
        clonedOptions.setListener(options.getListener());
        clonedOptions.setTransportIn(options.getTransportIn());
        clonedOptions.setTransportInProtocol(options.getTransportInProtocol());
        clonedOptions.setTransportOut(clonedOptions.getTransportOut());
        clonedOptions.setUserName(options.getUserName());
        clonedOptions.setPassword(options.getPassword());
        Iterator i$ = options.getProperties().keySet().iterator();
        while (i$.hasNext()) {
            String o;
            String key = o = (String)i$.next();
            clonedOptions.setProperty(key, options.getProperty(key));
        }
        return clonedOptions;
    }

    public static String getEPRfromWSDL(Definition wsdlDef, QName serviceName, String portName) {
        Port portDef;
        Service serviceDef = wsdlDef.getService(serviceName);
        if (serviceDef != null && (portDef = serviceDef.getPort(portName)) != null) {
            for (Object extElmt : portDef.getExtensibilityElements()) {
                if (extElmt instanceof SOAPAddress) {
                    return ((SOAPAddress)extElmt).getLocationURI();
                }
                if (extElmt instanceof HTTPAddress) {
                    return ((HTTPAddress)extElmt).getLocationURI();
                }
                if (!(extElmt instanceof SOAP12Address)) continue;
                return ((SOAP12Address)extElmt).getLocationURI();
            }
        }
        return null;
    }

    public static class WSDL11ToAxisPatchedBuilder
    extends WSDL11ToAxisServiceBuilder {
        public WSDL11ToAxisPatchedBuilder(InputStream in, QName serviceName, String portName) {
            super(in, serviceName, portName);
        }

        protected XmlSchema getXMLSchema(Element element, String baseUri) {
            XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
            if (baseUri != null) {
                schemaCollection.setBaseUri(baseUri);
            }
            return schemaCollection.read(element, baseUri);
        }
    }
}

