/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.dd.DeployDocument;
import org.apache.ode.bpel.dd.TBAMServerProfiles;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.dd.TProcessEvents;
import org.apache.ode.bpel.dd.TProvide;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.store.DeploymentUnitDAO;
import org.apache.ode.store.DeploymentUnitDir;
import org.apache.ode.store.ProcessConfDAO;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.bpel.core.internal.BPELServiceComponent;
import org.wso2.carbon.bpel.core.ode.integration.config.EndpointConfiguration;
import org.wso2.carbon.bpel.core.ode.integration.config.bam.BAMServerProfile;
import org.wso2.carbon.bpel.core.ode.integration.config.bam.BAMServerProfileBuilder;
import org.wso2.carbon.bpel.core.ode.integration.store.BPELDeploymentContext;
import org.wso2.carbon.bpel.core.ode.integration.store.BPELDeploymentException;
import org.wso2.carbon.bpel.core.ode.integration.store.ProcessConfigurationImpl;
import org.wso2.carbon.bpel.core.ode.integration.store.ProcessStoreImpl;
import org.wso2.carbon.bpel.core.ode.integration.store.TenantProcessStore;
import org.wso2.carbon.bpel.core.ode.integration.store.Utils;
import org.wso2.carbon.bpel.core.ode.integration.store.clustering.BPELProcessStateChangedCommand;
import org.wso2.carbon.bpel.core.ode.integration.store.repository.BPELPackageInfo;
import org.wso2.carbon.bpel.core.ode.integration.store.repository.BPELPackageRepository;
import org.wso2.carbon.bpel.core.ode.integration.store.repository.BPELPackageRepositoryUtils;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.ProcessManagementException;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryClientUtils;
import org.wso2.carbon.utils.FileManipulator;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class TenantProcessStoreImpl
implements TenantProcessStore {
    private static final Log log = LogFactory.getLog(TenantProcessStoreImpl.class);
    private static final Log deploymentLog = LogFactory.getLog((String)"org.wso2.carbon.bpel.deployment");
    private Integer tenantId;
    private ConfigurationContext tenantConfigContext;
    private Registry tenantConfigRegistry;
    private ProcessStoreImpl parentProcessStore;
    private final Map<String, DeploymentUnitDir> deploymentUnits = new ConcurrentHashMap<String, DeploymentUnitDir>();
    private final Map<QName, ProcessConfigurationImpl> processConfigMap = new ConcurrentHashMap<QName, ProcessConfigurationImpl>();
    private final Map<String, List<QName>> processesInDeploymentUnit = new ConcurrentHashMap<String, List<QName>>();
    private BPELPackageRepository repository;
    private File bpelDURepo;
    private File bpelArchiveRepo;
    private final Map<String, BAMServerProfile> bamProfiles = new ConcurrentHashMap<String, BAMServerProfile>();

    public TenantProcessStoreImpl(ConfigurationContext configContext, ProcessStoreImpl parent) throws RegistryException {
        this.tenantConfigContext = configContext;
        this.tenantId = MultitenantUtils.getTenantId((ConfigurationContext)configContext);
        this.tenantConfigRegistry = BPELServiceComponent.getRegistryService().getConfigSystemRegistry(this.tenantId.intValue());
        this.parentProcessStore = parent;
    }

    @Override
    public void init() throws Exception {
        SuperTenantCarbonContext.getCurrentContext().setTenantId(this.tenantId.intValue(), true);
        this.bpelDURepo = new File(this.parentProcessStore.getLocalDeploymentUnitRepo(), this.tenantId.toString());
        if (!this.bpelDURepo.exists() && !this.bpelDURepo.mkdirs()) {
            log.warn((Object)("Cannot create tenant " + this.tenantId + " BPEL deployment unit repository."));
        }
        this.repository = new BPELPackageRepository(this.tenantConfigRegistry, this.bpelDURepo, this.bpelArchiveRepo);
        this.repository.init();
    }

    @Override
    public void handleNewBPELPackageDeploymentNotification(String bpelPackageName) {
        try {
            this.repository.restoreBPELArchive(this.repository.getBPELPackageInfo("/bpel/packages/" + bpelPackageName));
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while deploying: " + bpelPackageName), (Throwable)e);
        }
    }

    @Override
    public void handleBPELPackageUndeploymentNotification(String bpelPackageName, List<String> versionsOfPackage) {
        this.updateLocalInstanceWithUndeployment(bpelPackageName, versionsOfPackage);
    }

    @Override
    public void handleBPELProcessStateChangedNotification(QName pid, ProcessState processState) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Changing state of the process " + pid + " to " + processState));
        }
        if (!this.isProcessExist(pid).booleanValue()) {
            String errMsg = "Process " + pid + " not found. Process state change failed.";
            log.error((Object)errMsg);
            return;
        }
        if (processState == null) {
            String errMessage = "Process State cannot be null. Process state change failed";
            log.error((Object)errMessage);
            return;
        }
        this.parentProcessStore.updateLocalInstanceWithStateChange(pid, processState);
    }

    @Override
    public void deploy(File bpelArchive) throws Exception {
        SuperTenantCarbonContext.getCurrentContext().setTenantId(this.tenantId.intValue(), true);
        log.info((Object)("Deploying BPEL archive: " + bpelArchive.getAbsolutePath()));
        long versionForThisDeployment = this.parentProcessStore.getCurrentVersion();
        BPELDeploymentContext deploymentContext = new BPELDeploymentContext(this.tenantId, this.parentProcessStore.getLocalDeploymentUnitRepo().getAbsolutePath(), bpelArchive, versionForThisDeployment);
        boolean isExistingPackage = this.repository.isExistingBPELPackage(deploymentContext);
        boolean isLoadOnly = this.repository.isBPELPackageReload(deploymentContext);
        deploymentContext.setExistingPackage(isExistingPackage);
        if (deploymentLog.isDebugEnabled()) {
            if (isExistingPackage) {
                deploymentLog.debug((Object)("Package: " + deploymentContext.getBpelPackageName() + " is already available"));
            } else {
                deploymentLog.debug((Object)("Package: " + deploymentContext.getBpelPackageName() + " is a new deployment"));
            }
            if (isLoadOnly) {
                deploymentLog.debug((Object)("Package: " + deploymentContext.getBpelPackageName() + " has already deployed. Therefore the package is reloaded"));
            } else {
                deploymentLog.debug((Object)("Package: " + deploymentContext.getBpelPackageName() + " is found as a new deployment"));
            }
        }
        if (isExistingPackage && isLoadOnly) {
            this.reloadExistingVersionsOfBPELPackage(deploymentContext);
            this.attachWithCapp(deploymentContext.getArchiveName(), deploymentContext.getBpelPackageName(), this.tenantId);
            return;
        }
        if (this.isConfigRegistryReadOnly()) {
            log.warn((Object)"This node seems to be a slave, since the configuration registry is in read-only mode, hence processes cannot be directly deployed in this node. Please deploy the process in Master node first.");
            return;
        }
        try {
            Utils.extractBPELArchive(deploymentContext);
        }
        catch (Exception e) {
            String errMsg = "Error extracting BPEL archive " + deploymentContext.getBpelArchive() + ".";
            deploymentContext.setDeploymentFailureCause(errMsg);
            deploymentContext.setStackTrace(e);
            deploymentContext.setFailed(true);
            this.handleDeploymentError(deploymentContext);
            return;
        }
        if (!this.validateBPELPackage(deploymentContext, isExistingPackage)) {
            deploymentContext.setFailed(true);
            this.handleDeploymentError(deploymentContext);
            return;
        }
        this.deployBPELPackageInODE(deploymentContext);
        if (isExistingPackage) {
            this.repository.handleBPELPackageUpdate(deploymentContext);
        } else {
            this.repository.handleNewBPELPackageAddition(deploymentContext);
        }
        this.attachWithCapp(deploymentContext.getArchiveName(), deploymentContext.getBpelPackageName(), this.tenantId);
    }

    private boolean isConfigRegistryReadOnly() {
        RegistryContext context = this.tenantConfigRegistry.getRegistryContext();
        try {
            if (context != null) {
                return context.isReadOnly();
            }
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while obtaining registry instance", (Throwable)e);
        }
        return false;
    }

    @Override
    public void undeploy(String bpelPackageName) throws RegistryException {
        List<String> versionsOfThePackage;
        SuperTenantCarbonContext.getCurrentContext().setTenantId(this.tenantId.intValue(), true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Undeploying BPEL package " + bpelPackageName + " ...."));
        }
        if (!this.repository.isExistingBPELPackage(bpelPackageName).booleanValue()) {
            String warningMsg = "Cannot find BPEL package with name " + bpelPackageName + " in the repository. If the bpel package is undeployed through the management" + " console or if this node is a member of a cluster, please ignore this warning.";
            log.warn((Object)warningMsg);
            return;
        }
        if (this.repository.isExistingBPELPackage(bpelPackageName).booleanValue() && this.isConfigRegistryReadOnly()) {
            log.warn((Object)"This node seems to be a slave, since the configuration registry is in read-only mode, hence processes cannot be directly undeployed from this node. Please undeploy the process in Master node first.");
            return;
        }
        try {
            versionsOfThePackage = this.repository.getAllVersionsForPackage(bpelPackageName);
        }
        catch (RegistryException re) {
            String errMessage = "Cannot get all versions of the package " + bpelPackageName + " from registry.";
            log.error((Object)errMessage);
            throw re;
        }
        for (String nameWithVersion : versionsOfThePackage) {
            this.parentProcessStore.deleteDeploymentUnitDataFromDB(nameWithVersion);
            Utils.deleteInstances(this.getProcessesInPackage(nameWithVersion));
            String bpelPackageLocation = this.parentProcessStore.getLocalDeploymentUnitRepo().getAbsolutePath() + File.separator + this.tenantId + File.separator + nameWithVersion;
            File bpelPackage = new File(bpelPackageLocation);
            this.deleteBpelPackageFromRepo(bpelPackage);
            for (QName pid : this.getProcessesInPackage(nameWithVersion)) {
                ProcessConfigurationImpl processConf = (ProcessConfigurationImpl)this.getProcessConfiguration(pid);
                processConf.setUndeploying(true);
            }
        }
        try {
            this.repository.handleBPELPackageUndeploy(bpelPackageName);
        }
        catch (RegistryException re) {
            String errMessage = "Cannot update the BPEL package repository for undeployment ofpackage " + bpelPackageName + ".";
            log.error((Object)errMessage);
            throw re;
        }
        this.updateLocalInstanceWithUndeployment(bpelPackageName, versionsOfThePackage);
    }

    private void deleteBpelPackageFromRepo(File bpelPackage) {
        log.info((Object)("Undeploying BPEL package. Deleting " + bpelPackage + " BPEL package"));
        if (bpelPackage.exists()) {
            FileManipulator.deleteDir((File)bpelPackage);
        } else {
            log.warn((Object)("BPEL package " + bpelPackage.getAbsolutePath() + " not found. This can happen if you delete " + "the BPEL package from the file system."));
        }
    }

    public void updateLocalInstanceWithUndeployment(String bpelPackageName, List<String> versionsOfThePackage) {
        this.deleteBpelArchive(bpelPackageName);
        ArrayList<QName> undeployedProcesses = new ArrayList<QName>();
        for (String nameWithVersion : versionsOfThePackage) {
            this.undeploySpecificVersionOfBPELPackage(nameWithVersion, undeployedProcesses);
        }
        this.parentProcessStore.updateMapsAndFireStateChangeEventsForUndeployedProcesses(this.tenantId, bpelPackageName, undeployedProcesses);
    }

    private void deleteBpelArchive(String bpelPackageName) {
        String bpelArchiveLocation = this.tenantConfigContext.getAxisConfiguration().getRepository().getPath() + File.separator + "bpel" + File.separator + bpelPackageName + "." + "zip";
        log.info((Object)("Undeploying BPEL package " + bpelPackageName + ". Deleting BPEL archive " + bpelArchiveLocation + "...."));
        File bpelArchive = new File(bpelArchiveLocation);
        if (bpelArchive.exists()) {
            if (!bpelArchive.delete()) {
                bpelArchive.deleteOnExit();
            }
        } else {
            log.warn((Object)("BPEL archive " + bpelArchive.getAbsolutePath() + " not found. This can happen if you delete " + "the BPEL archive from the file system."));
        }
    }

    private void undeploySpecificVersionOfBPELPackage(String packageName, Collection<QName> undeployedProcesses) {
        DeploymentUnitDir du = this.deploymentUnits.remove(packageName);
        this.processesInDeploymentUnit.remove(packageName);
        if (du != null) {
            long version = du.getVersion();
            for (QName name : du.getProcessNames()) {
                QName pid = Utils.toPid(name, version);
                undeployedProcesses.add(pid);
            }
        }
    }

    @Override
    public void handleTenantUnload() {
    }

    @Override
    public void hydrate() {
    }

    @Override
    public ProcessConf getProcessConfiguration(QName pid) {
        return this.processConfigMap.get(pid);
    }

    @Override
    public void setState(QName pid, ProcessState processState) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Changing state of the process " + pid + " to " + processState));
        }
        if (!this.isProcessExist(pid).booleanValue()) {
            String errMsg = "Process " + pid + " not found.";
            log.error((Object)errMsg);
            throw new Exception(errMsg);
        }
        if (processState == null) {
            String errMessage = "Process State cannot be null.";
            log.error((Object)errMessage);
            throw new Exception(errMessage);
        }
        this.parentProcessStore.setState(pid, processState);
        this.parentProcessStore.sendProcessDeploymentNotificationsToCluster(new BPELProcessStateChangedCommand(pid, processState, this.tenantId));
    }

    private Boolean isProcessExist(QName pid) {
        return this.processConfigMap.containsKey(pid);
    }

    public BPELPackageRepository getBPELPackageRepository() {
        return this.repository;
    }

    public Map<QName, ProcessConfigurationImpl> getProcessConfigMap() {
        return this.processConfigMap;
    }

    @Override
    public ProcessConf removeProcessConfiguration(QName pid) {
        return this.processConfigMap.remove(pid);
    }

    public List<QName> getProcessesInPackage(String packageName) {
        List processes = this.processesInDeploymentUnit.get(packageName);
        if (processes == null) {
            processes = Collections.EMPTY_LIST;
        }
        return processes;
    }

    public Boolean containsProcess(QName pid) {
        return this.processConfigMap.containsKey(pid);
    }

    @Override
    public void setBpelArchiveRepo(File bpelArchiveRepo) {
        this.bpelArchiveRepo = bpelArchiveRepo;
    }

    private void handleDeploymentError(BPELDeploymentContext deploymentContext) throws Exception {
        if (deploymentContext.getStackTrace() != null) {
            log.error((Object)deploymentContext.getDeploymentFailureCause(), deploymentContext.getStackTrace());
        } else {
            log.error((Object)deploymentContext.getDeploymentFailureCause());
        }
        this.repository.handleBPELPackageDeploymentError(deploymentContext);
    }

    private void reloadExistingVersionsOfBPELPackage(BPELDeploymentContext deploymentContext) throws RegistryException, ProcessManagementException {
        BPELPackageInfo bpelPackage = this.repository.getBPELPackageInfo(deploymentContext);
        for (String packageName : bpelPackage.getAvailableVersions()) {
            if (this.deploymentUnits.containsKey(packageName)) continue;
            this.loadExistingBPELPackage(packageName);
        }
    }

    private void deployBPELPackageInODE(BPELDeploymentContext deploymentContext) throws Exception {
        File bpelPackage = deploymentContext.getBPELPackageContent();
        log.info((Object)("Starting deployment of processes from directory " + bpelPackage.getAbsolutePath()));
        Date deployDate = new Date();
        DeploymentUnitDir du = new DeploymentUnitDir(bpelPackage);
        du.setVersion(du.getStaticVersion());
        try {
            du.compile();
        }
        catch (CompilationException ce) {
            String logMessage = "Deployment failed due to compilation issues. " + ce.getMessage();
            log.error((Object)logMessage, (Throwable)ce);
            deploymentContext.setFailed(true);
            deploymentContext.setDeploymentFailureCause(logMessage);
            deploymentContext.setStackTrace(ce);
            this.handleDeploymentError(deploymentContext);
            throw new BPELDeploymentException(logMessage, ce);
        }
        du.scan();
        DeployDocument dd = du.getDeploymentDescriptor();
        ArrayList<ProcessConfigurationImpl> processConfs = new ArrayList<ProcessConfigurationImpl>();
        ArrayList<QName> processIds = new ArrayList<QName>();
        if (this.deploymentUnits.containsKey(du.getName())) {
            String logMessage = "Aborting deployment. Duplicate Deployment unit " + du.getName() + ".";
            log.error((Object)logMessage);
            deploymentContext.setFailed(true);
            deploymentContext.setDeploymentFailureCause(logMessage);
            this.handleDeploymentError(deploymentContext);
            throw new BPELDeploymentException(logMessage);
        }
        this.validateBPELPackage(du);
        if (deploymentContext.isExistingPackage()) {
            this.reloadExistingVersionsOfBPELPackage(deploymentContext);
        }
        this.retirePreviousPackageVersions(du);
        for (TDeployment.Process processDD : dd.getDeploy().getProcessList()) {
            QName processId = Utils.toPid(processDD.getName(), du.getVersion());
            ProcessConfigurationImpl processConf = new ProcessConfigurationImpl(this.tenantId, processDD, du, deployDate, this.parentProcessStore.getEndpointReferenceContext(), this.tenantConfigContext);
            processConf.setAbsolutePathForBpelArchive(deploymentContext.getBpelArchive().getAbsolutePath());
            processIds.add(processId);
            processConfs.add(processConf);
        }
        this.deploymentUnits.put(du.getName(), du);
        this.processesInDeploymentUnit.put(du.getName(), processIds);
        for (ProcessConfigurationImpl processConf : processConfs) {
            this.processConfigMap.put(processConf.getProcessId(), processConf);
            deploymentContext.addProcessId(processConf.getProcessId());
        }
        try {
            this.parentProcessStore.onBPELPackageDeployment(this.tenantId, du.getName(), BPELPackageRepositoryUtils.getResourcePathForBPELPackageContent(deploymentContext), processConfs);
        }
        catch (ContextException ce) {
            deploymentContext.setDeploymentFailureCause("BPEL Package deployment failed at ODE layer. Possible cause: " + ce.getMessage());
            deploymentContext.setStackTrace(ce);
            deploymentContext.setFailed(true);
            this.handleDeploymentError(deploymentContext);
            throw ce;
        }
    }

    private void validateBPELPackage(DeploymentUnitDir du) throws BPELDeploymentException {
        DeployDocument dd = du.getDeploymentDescriptor();
        for (TDeployment.Process processDD : dd.getDeploy().getProcessList()) {
            QName processId = Utils.toPid(processDD.getName(), du.getVersion());
            if (this.processConfigMap.containsKey(processId)) {
                String logMessage = "Aborting deployment. Duplicate process ID " + processId + ".";
                log.error((Object)logMessage);
                throw new BPELDeploymentException(logMessage);
            }
            QName processType = Utils.getProcessType(processDD);
            DeploymentUnitDir.CBPInfo cbpInfo = du.getCBPInfo(processType);
            if (cbpInfo != null) continue;
            String logMessage = "Aborting deployment. Cannot find Process definition for type " + processType + ".";
            log.error((Object)logMessage);
            throw new BPELDeploymentException(logMessage);
        }
    }

    private void handleDeploymentErrorsAtODELayer(BPELDeploymentContext deploymentContext, String duName) {
        this.deploymentUnits.remove(duName);
        this.processesInDeploymentUnit.remove(duName);
        for (QName pid : deploymentContext.getProcessIdsForCurrentDeployment()) {
            this.processConfigMap.remove(pid);
        }
    }

    private void loadExistingBPELPackage(String bpelPackageName) throws RegistryException, ProcessManagementException, BPELDeploymentException {
        DeploymentUnitDAO duDAO = this.parentProcessStore.getDeploymentUnitDAO(bpelPackageName);
        if (duDAO == null) {
            String errMsg = "Cannot find DeploymentUnitDAO instance for package " + bpelPackageName + ".";
            log.error((Object)errMsg);
            throw new BPELDeploymentException(errMsg);
        }
        File bpelPackage = this.findBPELPackageInFileSystem(duDAO);
        if (bpelPackage == null || !bpelPackage.exists()) {
            throw new BPELDeploymentException("Deployed directory " + bpelPackage + " no longer there!");
        }
        DeploymentUnitDir du = new DeploymentUnitDir(bpelPackage);
        du.setVersion(du.getStaticVersion());
        du.scan();
        ArrayList<ProcessConfigurationImpl> loaded = new ArrayList<ProcessConfigurationImpl>();
        ArrayList<QName> processIds = new ArrayList<QName>();
        for (ProcessConfDAO pConfDAO : duDAO.getProcesses()) {
            TDeployment.Process processDD = du.getProcessDeployInfo(pConfDAO.getType());
            if (processDD == null) {
                log.warn((Object)("Cannot load " + pConfDAO.getPID() + "; cannot find descriptor."));
                continue;
            }
            ProcessConfigurationImpl pConf = new ProcessConfigurationImpl(this.tenantId, processDD, du, duDAO.getDeployDate(), this.parentProcessStore.getEndpointReferenceContext(), this.tenantConfigContext);
            pConf.setAbsolutePathForBpelArchive(bpelPackage.getAbsolutePath());
            pConf.setState(pConfDAO.getState());
            processIds.add(pConfDAO.getPID());
            this.readModifiedDDFromFile(pConf);
            TBAMServerProfiles bamServerProfiles = processDD.getBamServerProfiles();
            if (bamServerProfiles != null) {
                for (TBAMServerProfiles.Profile bamServerProfile : bamServerProfiles.getProfileList()) {
                    String location = bamServerProfile.getLocation();
                    if (!(location.startsWith("conf:") && location.startsWith("gov:") && location.startsWith("reg:") || !location.startsWith("file:"))) {
                        location = EndpointConfiguration.isAbsoutePath(location) ? "file:" + location : EndpointConfiguration.getAbsolutePath(du.getDeployDir().getAbsolutePath(), location);
                    }
                    BAMServerProfileBuilder builder = new BAMServerProfileBuilder(location);
                    BAMServerProfile profile = builder.build();
                    this.addBAMServerProfile(profile.getName(), profile);
                }
            }
            this.processConfigMap.put(pConf.getProcessId(), pConf);
            loaded.add(pConf);
        }
        this.deploymentUnits.put(du.getName(), du);
        this.processesInDeploymentUnit.put(du.getName(), processIds);
        this.parentProcessStore.onBPELPackageReload(this.tenantId, du.getName(), loaded);
    }

    private void readModifiedDDFromFile(ProcessConfigurationImpl pConf) {
        String bpelMetafilesLocation = this.tenantConfigContext.getAxisConfiguration().getRepository().getPath() + "bpelmetafiles";
        DeployDocument _dd = null;
        String encodedPath = null;
        try {
            encodedPath = URLEncoder.encode(pConf.getProcessId().toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ContextException("Couldn't encode path for file: " + pConf.getProcessId().toString(), (Throwable)e);
        }
        String ddFilePath = bpelMetafilesLocation + File.separator + encodedPath + ".xml";
        File deployDescDest = new File(ddFilePath);
        try {
            _dd = DeployDocument.Factory.parse((File)deployDescDest);
        }
        catch (FileNotFoundException e) {
            log.debug((Object)("Deployment Descriptor for " + encodedPath + " not updated at runtime."));
        }
        catch (Exception e) {
            throw new ContextException("Couldn't read deployment descriptor at location " + deployDescDest.getAbsolutePath(), (Throwable)e);
        }
        if (_dd != null) {
            TDeployment.Process process = _dd.getDeploy().getProcessArray(0);
            pConf.setIsTransient(process.getInMemory());
            pConf.setState(ProcessState.ACTIVE);
            if (process.getRetired()) {
                pConf.setState(ProcessState.RETIRED);
            } else if (!process.getActive()) {
                pConf.setState(ProcessState.DISABLED);
            }
            TProcessEvents processEvents = process.getProcessEvents();
            if (processEvents.getGenerate() != null) {
                TProcessEvents.Generate.Enum value = processEvents.getGenerate();
                pConf.setGenerateType(value);
            }
            pConf.setProcessEventsList(processEvents);
            List tCleanups = process.getCleanupList();
            pConf.setProcessCleanupConfImpl(tCleanups);
        }
    }

    private File findBPELPackageInFileSystem(DeploymentUnitDAO dudao) {
        String duName = dudao.getName();
        log.info((Object)("Looking for BPEL package in file system for deployment unit " + duName));
        File bpelDUDirectory = new File(this.bpelDURepo, duName);
        if (bpelDUDirectory.exists()) {
            return bpelDUDirectory;
        }
        String registryCollectionPath = dudao.getDeploymentUnitDir();
        try {
            if (this.tenantConfigRegistry.resourceExists(registryCollectionPath)) {
                if (!bpelDUDirectory.exists() && !bpelDUDirectory.mkdirs()) {
                    String errMsg = "Error creating BPEL deployment unit repository for tenant " + this.tenantId;
                    log.error((Object)errMsg);
                    log.error((Object)("Failed to load BPEL deployment unit " + duName + " due to above error."));
                    throw new BPELDeploymentException(errMsg);
                }
                boolean deployedOnCarbon310 = false;
                if (this.tenantConfigRegistry.resourceExists(registryCollectionPath + "/" + duName)) {
                    registryCollectionPath = registryCollectionPath + "/" + duName;
                    deployedOnCarbon310 = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found a carbon 3.1.0 compatible deployment unit at " + registryCollectionPath));
                    }
                }
                RegistryClientUtils.exportFromRegistry((File)bpelDUDirectory, (String)registryCollectionPath, (Registry)this.tenantConfigRegistry);
                if (deployedOnCarbon310) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Recompiling the carbon 3.1.0 compatible deployment unit at " + bpelDUDirectory));
                    }
                    DeploymentUnitDir du = new DeploymentUnitDir(bpelDUDirectory);
                    for (File file : du.allFiles()) {
                        if (!file.getAbsolutePath().endsWith(".cbp") || file.delete()) continue;
                        log.warn((Object)("Unable to delete " + file));
                    }
                    du.compile();
                }
                return bpelDUDirectory;
            }
            String errMsg = "Expected resource: " + registryCollectionPath + " not found in the registry";
            log.error((Object)errMsg);
            throw new BPELDeploymentException(errMsg);
        }
        catch (RegistryException re) {
            String errMsg = "Error while exporting deployment unit: " + duName + " to file system from the registry.";
            log.error((Object)errMsg, (Throwable)re);
            throw new BPELDeploymentException(errMsg, re);
        }
    }

    private void retirePreviousPackageVersions(DeploymentUnitDir du) {
        String[] nameParts = du.getName().split("/");
        nameParts[0] = nameParts[0].replaceAll("([-\\Q.\\E](\\d)+)?\\z", "");
        nameParts[0] = nameParts[0] + "([-\\Q.\\E](\\d)+)?";
        StringBuilder duNameRegExp = new StringBuilder(du.getName().length() * 2);
        int n = nameParts.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                duNameRegExp.append("/");
            }
            duNameRegExp.append(nameParts[i]);
        }
        Pattern duNamePattern = Pattern.compile(duNameRegExp.toString());
        for (String deployedDUname : this.deploymentUnits.keySet()) {
            Matcher matcher = duNamePattern.matcher(deployedDUname);
            if (!matcher.matches()) continue;
            this.parentProcessStore.setRetiredPackage(deployedDUname, true);
        }
    }

    private boolean validateBPELPackage(BPELDeploymentContext bpelDeploymentContext, boolean isExistingPackage) {
        DeploymentUnitDir du;
        try {
            du = new DeploymentUnitDir(bpelDeploymentContext.getBPELPackageContent());
        }
        catch (IllegalArgumentException e) {
            bpelDeploymentContext.setDeploymentFailureCause(e.getMessage());
            bpelDeploymentContext.setStackTrace(e);
            return false;
        }
        if (!isExistingPackage) {
            DeployDocument deployDocument = du.getDeploymentDescriptor();
            List processList = deployDocument.getDeploy().getProcessList();
            for (TDeployment.Process process : processList) {
                List provideList = process.getProvideList();
                for (TProvide provide : provideList) {
                    if (!this.getDeployedServices().containsKey(provide.getService().getName())) continue;
                    String errMsg = "Service: " + provide.getService().getName() + " already " + "used by another process. Try again with a different " + "service name";
                    bpelDeploymentContext.setDeploymentFailureCause(errMsg);
                    return false;
                }
            }
        }
        return true;
    }

    private void attachWithCapp(String bpelArchiveName, String bpelPackageName, int tenantId) {
        AppDeployerUtils.attachArtifactToOwnerApp((String)bpelArchiveName, (String)"bpel/workflow", (String)bpelPackageName, (int)tenantId);
    }

    @Override
    public Map<QName, Object> getDeployedServices() {
        return this.parentProcessStore.getServicesPublishedByTenant(this.tenantId);
    }

    public void addBAMServerProfile(String name, BAMServerProfile profile) {
        this.bamProfiles.put(name, profile);
    }

    @Override
    public BAMServerProfile getBAMServerProfile(String name) {
        return this.bamProfiles.get(name);
    }
}

