/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.store;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.state.StateClusteringCommand;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.iapi.ProcessStoreEvent;
import org.apache.ode.bpel.iapi.ProcessStoreListener;
import org.apache.ode.store.ConfStoreConnection;
import org.apache.ode.store.ConfStoreConnectionFactory;
import org.apache.ode.store.DeploymentUnitDAO;
import org.apache.ode.store.ProcessConfDAO;
import org.apache.ode.store.jpa.DbConfStoreConnectionFactory;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.hsqldb.jdbc.jdbcDataSource;
import org.w3c.dom.Node;
import org.wso2.carbon.bpel.cluster.notifier.BPELClusterNotifier;
import org.wso2.carbon.bpel.core.ode.integration.ODEConfigurationProperties;
import org.wso2.carbon.bpel.core.ode.integration.store.MultiTenantProcessStore;
import org.wso2.carbon.bpel.core.ode.integration.store.ProcessConfigurationImpl;
import org.wso2.carbon.bpel.core.ode.integration.store.TenantProcessStore;
import org.wso2.carbon.bpel.core.ode.integration.store.TenantProcessStoreImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ProcessStoreImpl
implements ProcessStore,
MultiTenantProcessStore {
    private static final Log log = LogFactory.getLog(ProcessStoreImpl.class);
    static final Comparator<ProcessConfigurationImpl> BY_DEPLOYEDDATE = new Comparator<ProcessConfigurationImpl>(){

        @Override
        public int compare(ProcessConfigurationImpl o1, ProcessConfigurationImpl o2) {
            return o1.getDeployDate().compareTo(o2.getDeployDate());
        }
    };
    private Map<Integer, TenantProcessStore> tenantProcessStores = new ConcurrentHashMap<Integer, TenantProcessStore>();
    private Map<Integer, TenatProcessStoreState> tenantProcessStoreState = new ConcurrentHashMap<Integer, TenatProcessStoreState>();
    private CopyOnWriteArrayList<ProcessStoreListener> processStoreListeners = new CopyOnWriteArrayList();
    private ConfStoreConnectionFactory connectionFactory;
    private CopyOnWriteArrayList<String> deploymentUnits = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<QName> processes = new CopyOnWriteArrayList();
    private Map<QName, Integer> processToTenantMap = new ConcurrentHashMap<QName, Integer>();
    private Map<String, Integer> deploymentUnitToTenantMap = new ConcurrentHashMap<String, Integer>();
    private Map<String, ArrayList<QName>> deploymentUnitToProcessesMap = new ConcurrentHashMap<String, ArrayList<QName>>();
    private Map<QName, String> processToDeploymentUnitMap = new ConcurrentHashMap<QName, String>();
    private Map<Integer, Map<QName, Object>> servicesPublishedByTenants = new ConcurrentHashMap<Integer, Map<QName, Object>>();
    private File bpelDURepo;
    private EndpointReferenceContext eprContext;
    private DataSource inMemDs;
    private ExecutorService executor = Executors.newSingleThreadExecutor(new SimpleThreadFactory());

    public ProcessStoreImpl(EndpointReferenceContext eprContext, DataSource ds, ODEConfigurationProperties configurationProps) {
        this.eprContext = eprContext;
        if (ds != null) {
            this.connectionFactory = new DbConfStoreConnectionFactory(ds, false, configurationProps.getTxFactoryClass());
        } else {
            String guid = new GUID().toString();
            DataSource hsqlds = ProcessStoreImpl.createInternalDS(guid);
            this.connectionFactory = new DbConfStoreConnectionFactory(hsqlds, true, configurationProps.getTxFactoryClass());
            this.inMemDs = hsqlds;
        }
    }

    public static DataSource createInternalDS(String guid) {
        jdbcDataSource hsqlds = new jdbcDataSource();
        hsqlds.setDatabase("jdbc:hsqldb:mem:" + guid);
        hsqlds.setUser("sa");
        hsqlds.setPassword("");
        return hsqlds;
    }

    public void shutdown() {
        if (this.inMemDs != null) {
            ProcessStoreImpl.shutdownInternalDB(this.inMemDs);
            this.inMemDs = null;
        }
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownInternalDB(DataSource ds) {
        Connection conn = null;
        try {
            conn = ds.getConnection();
            Statement stmt = conn.createStatement();
            try {
                stmt.execute("SHUTDOWN;");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error shutting down data base.", (Throwable)e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {
                log.warn((Object)"Unable to close the SQL connection.", (Throwable)se);
            }
        }
    }

    public Collection<QName> deploy(File file) {
        throw new UnsupportedOperationException("Operation deploy(File file) is not supported multi-tenant aware process store.");
    }

    public Collection<QName> undeploy(File file) {
        throw new UnsupportedOperationException("Operation undeploy(File file) is not supported multi-tenant aware process store.");
    }

    public void sendProcessDeploymentNotificationsToCluster(StateClusteringCommand command) throws AxisFault {
        BPELClusterNotifier.sendClusterNotification((StateClusteringCommand)command, (Object)this);
    }

    private void updateProcessAndDUMaps(Integer tenantId, String duName, Collection<QName> pids, boolean isDeploy) {
        if (isDeploy) {
            this.deploymentUnits.add(duName);
            for (QName pid : pids) {
                this.processes.add(pid);
            }
            this.deploymentUnitToTenantMap.put(duName, tenantId);
            this.populateProcessToTenatMap(tenantId, pids);
            this.populateDeploymentUnitToProcessMap(duName, pids);
        } else {
            for (QName pid : pids) {
                ProcessConfigurationImpl processConf = (ProcessConfigurationImpl)this.getProcessConfiguration(pid);
                if (processConf != null && processConf.isUndeploying()) {
                    this.processToTenantMap.remove(pid);
                }
                this.removeProcessConfiguration(pid, tenantId);
            }
            this.deploymentUnits.remove(duName);
            for (QName pid : pids) {
                this.processes.remove(pid);
            }
            this.deploymentUnitToTenantMap.remove(duName);
            this.deploymentUnitToProcessesMap.remove(duName);
        }
    }

    @Override
    public void removeFromProcessToTenantMap(QName pid) {
        this.processToTenantMap.remove(pid);
    }

    private void populateDeploymentUnitToProcessMap(String duName, Collection<QName> pids) {
        ArrayList<QName> processIds = new ArrayList<QName>();
        for (QName pid : pids) {
            processIds.add(pid);
        }
        this.deploymentUnitToProcessesMap.put(duName, processIds);
    }

    private void populateProcessToTenatMap(Integer tenantId, Collection<QName> pids) {
        for (QName pid : pids) {
            this.processToTenantMap.put(pid, tenantId);
        }
    }

    public DeploymentUnitDAO getDeploymentUnitDAO(final String bpelPackageName) {
        DeploymentUnitDAO duDAO = this.exec(new Callable<DeploymentUnitDAO>(){

            @Override
            public DeploymentUnitDAO call(ConfStoreConnection conn) {
                return conn.getDeploymentUnit(bpelPackageName);
            }
        });
        if (duDAO == null) {
            log.warn((Object)("Cannot find deployment unit information on DB for deployment unit " + bpelPackageName));
        }
        return duDAO;
    }

    public void onBPELPackageReload(Integer tenantId, String duName, List<ProcessConfigurationImpl> pConfs) {
        CopyOnWriteArrayList<QName> pids = new CopyOnWriteArrayList<QName>();
        for (ProcessConfigurationImpl pConf : pConfs) {
            pids.add(pConf.getProcessId());
        }
        this.updateProcessAndDUMaps(tenantId, duName, pids, true);
        Collections.sort(pConfs, BY_DEPLOYEDDATE);
        for (ProcessConfigurationImpl processConfiguration : pConfs) {
            try {
                this.fireStateChange(processConfiguration.getProcessId(), processConfiguration.getState(), duName);
            }
            catch (Exception e) {
                log.error((Object)("Error while firing state change event for process " + processConfiguration.getProcessId() + " in deployment unit " + duName + "."));
            }
        }
    }

    public void onBPELPackageDeployment(Integer tenantId, final String duName, final String duLocation, final List<ProcessConfigurationImpl> processConfs) {
        boolean status = this.exec(new Callable<Boolean>(){

            @Override
            public Boolean call(ConfStoreConnection conn) {
                DeploymentUnitDAO duDao = conn.getDeploymentUnit(duName);
                if (duDao != null) {
                    return true;
                }
                duDao = conn.createDeploymentUnit(duName);
                duDao.setDeploymentUnitDir(duLocation);
                for (ProcessConfigurationImpl pConf : processConfs) {
                    try {
                        ProcessConfDAO processConfDao = duDao.createProcess(pConf.getProcessId(), pConf.getType(), pConf.getVersion());
                        processConfDao.setState(pConf.getState());
                        for (Map.Entry prop : pConf.getProcessProperties().entrySet()) {
                            processConfDao.setProperty((QName)prop.getKey(), DOMUtils.domToString((Node)((Node)prop.getValue())));
                        }
                        conn.setVersion(pConf.getVersion());
                    }
                    catch (Exception e) {
                        String errmsg = "Error persisting deployment record for " + pConf.getProcessId() + "; process will not be available after restart!";
                        log.error((Object)errmsg, (Throwable)e);
                        return false;
                    }
                }
                return true;
            }
        });
        if (status) {
            CopyOnWriteArrayList<QName> pids = new CopyOnWriteArrayList<QName>();
            for (ProcessConfigurationImpl pConf : processConfs) {
                pids.add(pConf.getProcessId());
            }
            this.updateProcessAndDUMaps(tenantId, duName, pids, true);
            for (ProcessConfigurationImpl processConf : processConfs) {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.DEPLOYED, processConf.getProcessId(), duName));
                this.fireStateChange(processConf.getProcessId(), processConf.getState(), duName);
            }
        }
    }

    public void deleteDeploymentUnitDataFromDB(final String duName) {
        try {
            this.exec(new Callable<Boolean>(){

                @Override
                public Boolean call(ConfStoreConnection conn) {
                    DeploymentUnitDAO duDao = conn.getDeploymentUnit(duName);
                    if (duDao != null) {
                        duDao.delete();
                    }
                    return true;
                }
            });
        }
        catch (Exception ex) {
            log.error((Object)("Error synchronizing with data store; " + duName + " may be reappear after restart!"));
        }
    }

    public void updateMapsAndFireStateChangeEventsForUndeployedProcesses(Integer tenantId, String duName, Collection<QName> pids) {
        for (QName pid : pids) {
            this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.UNDEPLOYED, pid, duName));
            log.info((Object)("Process " + pid + " undeployed."));
        }
        this.updateProcessAndDUMaps(tenantId, duName, pids, false);
    }

    public Collection<String> getPackages() {
        return this.deploymentUnits;
    }

    public List<QName> listProcesses(String packageName) {
        return this.deploymentUnitToProcessesMap.get(packageName);
    }

    public List<QName> getProcesses() {
        return this.processes;
    }

    public ProcessConf getProcessConfiguration(QName pid) {
        TenantProcessStore tenantProcessStore;
        Integer tenantId = this.processToTenantMap.get(pid);
        if (tenantId != null && (tenantProcessStore = this.tenantProcessStores.get(tenantId)) != null) {
            return tenantProcessStore.getProcessConfiguration(pid);
        }
        return null;
    }

    private void removeProcessConfiguration(QName pid, int tenantId) {
        TenantProcessStore tenantProcessStore = this.tenantProcessStores.get(tenantId);
        if (tenantProcessStore != null) {
            tenantProcessStore.removeProcessConfiguration(pid);
        }
    }

    public void registerListener(ProcessStoreListener processStoreListener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering process store listner " + processStoreListener));
        }
        this.processStoreListeners.add(processStoreListener);
    }

    public void unregisterListener(ProcessStoreListener processStoreListener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistering process store listener " + processStoreListener));
        }
        this.processStoreListeners.remove(processStoreListener);
    }

    public void setProperty(final QName pid, final QName propName, final String value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting property " + propName + " on process " + propName));
        }
        if (this.processes.indexOf(pid) == -1) {
            String errMsg = "Process " + pid + " not found.";
            log.error((Object)errMsg);
            throw new ContextException(errMsg);
        }
        final String duName = this.getDeploymentUnitForProcess(pid);
        if (duName == null) {
            String errMsg = "Deployment unit for process " + pid + " not found.";
            log.error((Object)errMsg);
            throw new ContextException(errMsg);
        }
        this.exec(new Callable<Object>(){

            @Override
            public Object call(ConfStoreConnection conn) {
                DeploymentUnitDAO duDao = conn.getDeploymentUnit(duName);
                if (duDao == null) {
                    return null;
                }
                ProcessConfDAO pConfDao = duDao.getProcess(pid);
                if (pConfDao == null) {
                    return null;
                }
                pConfDao.setProperty(propName, value);
                return null;
            }
        });
        this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.PROPERTY_CHANGED, pid, duName));
    }

    private String getDeploymentUnitForProcess(QName pid) {
        if (this.processToDeploymentUnitMap.get(pid) != null) {
            return this.processToDeploymentUnitMap.get(pid);
        }
        for (Map.Entry<String, ArrayList<QName>> entry : this.deploymentUnitToProcessesMap.entrySet()) {
            if (!entry.getValue().contains(pid)) continue;
            this.processToDeploymentUnitMap.put(pid, entry.getKey());
            return entry.getKey();
        }
        return null;
    }

    public void setProperty(QName pid, QName propName, Node value) {
        this.setProperty(pid, propName, DOMUtils.domToStringLevel2((Node)value));
    }

    public void setState(final QName pid, final ProcessState processState) {
        this.validateMethodParameters(pid, processState);
        final String duName = this.getDeploymentUnitForProcess(pid);
        this.validateDeploymentUnitForTheProcess(duName, pid);
        ProcessState old = this.exec(new Callable<ProcessState>(){

            @Override
            public ProcessState call(ConfStoreConnection conn) {
                DeploymentUnitDAO duDao = conn.getDeploymentUnit(duName);
                if (duDao == null) {
                    String errMsg = "Deployment unit " + duName + " not found.";
                    log.error((Object)errMsg);
                    throw new ContextException(errMsg);
                }
                ProcessConfDAO pConfDao = duDao.getProcess(pid);
                if (pConfDao == null) {
                    String errMsg = "Process " + pid + " not found in deployment unit " + duName + ".";
                    log.error((Object)errMsg);
                    throw new ContextException(errMsg);
                }
                ProcessState old = pConfDao.getState();
                pConfDao.setState(processState);
                return old;
            }
        });
        ProcessConfigurationImpl pConf = (ProcessConfigurationImpl)this.getProcessConfiguration(pid);
        pConf.setState(processState);
        if (old != null && !old.equals((Object)processState)) {
            this.fireStateChange(pid, processState, duName);
        }
    }

    private void validateDeploymentUnitForTheProcess(String duName, QName pid) {
        if (duName == null) {
            String errMsg = "Deployment unit for process " + pid + " not found.";
            log.error((Object)errMsg);
            throw new ContextException(errMsg);
        }
    }

    private void validateMethodParameters(QName pid, ProcessState processState) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Changing process state for " + pid + " to " + processState));
        }
        if (processState == null) {
            String errMessage = "Process State cannot be null.";
            log.error((Object)errMessage);
            throw new ContextException(errMessage);
        }
        if (this.processes.indexOf(pid) == -1) {
            String errMsg = "Process " + pid + " not found.";
            log.error((Object)errMsg);
            throw new ContextException(errMsg);
        }
    }

    public void updateLocalInstanceWithStateChange(QName pid, ProcessState processState) {
        this.validateMethodParameters(pid, processState);
        String duName = this.getDeploymentUnitForProcess(pid);
        this.validateDeploymentUnitForTheProcess(duName, pid);
        ProcessConfigurationImpl pConf = (ProcessConfigurationImpl)this.getProcessConfiguration(pid);
        pConf.setState(processState);
        this.fireStateChange(pid, processState, duName);
    }

    public void setRetiredPackage(String packageName, boolean retired) {
        ArrayList<QName> processList = this.deploymentUnitToProcessesMap.get(packageName);
        if (processList == null) {
            throw new ContextException("Couldn't find the package " + packageName);
        }
        for (QName pid : processList) {
            this.setState(pid, retired ? ProcessState.RETIRED : ProcessState.ACTIVE);
        }
    }

    public long getCurrentVersion() {
        return this.exec(new Callable<Long>(){

            @Override
            public Long call(ConfStoreConnection conn) {
                return conn.getNextVersion();
            }
        });
    }

    public void refreshSchedules(String packageName) {
        List<QName> pids = this.listProcesses(packageName);
        if (pids != null) {
            for (QName pid : pids) {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.SCHEDULE_SETTINGS_CHANGED, pid, packageName));
            }
        }
    }

    @Override
    public TenantProcessStore createProcessStoreForTenant(ConfigurationContext tenantConfigurationContext) {
        Integer tenantId = MultitenantUtils.getTenantId((ConfigurationContext)tenantConfigurationContext);
        try {
            TenantProcessStoreImpl processStore = new TenantProcessStoreImpl(tenantConfigurationContext, this);
            this.tenantProcessStores.put(tenantId, processStore);
            this.tenantProcessStoreState.put(tenantId, TenatProcessStoreState.ACTIVE);
            if (log.isDebugEnabled()) {
                log.debug((Object)("TenantProcessStore created for tenant " + tenantId + "."));
            }
            return processStore;
        }
        catch (RegistryException re) {
            log.error((Object)("Error getting configuration registry for the tenant " + tenantId + "."));
            return null;
        }
    }

    public void unloadTenantProcessStore(Integer tenantId) {
        this.tenantProcessStoreState.put(tenantId, TenatProcessStoreState.INACTIVE);
        this.tenantProcessStores.remove(tenantId);
        this.removeServicesPublishedByTenat(tenantId);
    }

    public void setLocalBPELDeploymentUnitRepo(File bpelDURepo) {
        this.bpelDURepo = bpelDURepo;
    }

    @Override
    public File getLocalDeploymentUnitRepo() {
        return this.bpelDURepo;
    }

    @Override
    public TenantProcessStore getTenantsProcessStore(Integer tenantId) {
        return this.tenantProcessStores.get(tenantId);
    }

    public Map<QName, Object> getServicesPublishedByTenant(Integer tenantId) {
        if (this.servicesPublishedByTenants.get(tenantId) == null) {
            this.servicesPublishedByTenants.put(tenantId, new ConcurrentHashMap());
        }
        return this.servicesPublishedByTenants.get(tenantId);
    }

    public void removeServicesPublishedByTenat(Integer tenantId) {
        this.servicesPublishedByTenants.remove(tenantId);
    }

    @Override
    public Integer getTenantId(QName pid) {
        return this.processToTenantMap.get(pid);
    }

    public EndpointReferenceContext getEndpointReferenceContext() {
        return this.eprContext;
    }

    protected void fireStateChange(QName processId, ProcessState state, String duname) {
        switch (state) {
            case ACTIVE: {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.ACTIVATED, processId, duname));
                break;
            }
            case DISABLED: {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.DISABLED, processId, duname));
                break;
            }
            case RETIRED: {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.RETIRED, processId, duname));
            }
        }
    }

    protected void fireEvent(ProcessStoreEvent pse) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("firing event: " + pse));
        }
        for (ProcessStoreListener psl : this.processStoreListeners) {
            psl.onProcessStoreEvent(pse);
        }
    }

    private ConfStoreConnection getConnection() {
        return this.connectionFactory.getConnection();
    }

    synchronized <T> T exec(Callable<T> callable) {
        Future<T> future = this.executor.submit(callable);
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new ContextException("DbError", (Throwable)e);
        }
    }

    private static class SimpleThreadFactory
    implements ThreadFactory {
        private int threadNumber = 0;

        private SimpleThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            ++this.threadNumber;
            Thread t = new Thread(r, "ProcessStoreImpl-" + this.threadNumber);
            t.setDaemon(true);
            return t;
        }
    }

    abstract class Callable<V>
    implements java.util.concurrent.Callable<V> {
        Callable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V call() {
            boolean success = false;
            ProcessStoreImpl.this.connectionFactory.beginTransaction();
            ConfStoreConnection conn = ProcessStoreImpl.this.getConnection();
            try {
                V r = this.call(conn);
                ProcessStoreImpl.this.connectionFactory.commitTransaction();
                success = true;
                V v = r;
                return v;
            }
            finally {
                if (!success) {
                    try {
                        ProcessStoreImpl.this.connectionFactory.rollbackTransaction();
                    }
                    catch (Exception ex) {
                        log.error((Object)"DbError", (Throwable)ex);
                    }
                }
            }
        }

        abstract V call(ConfStoreConnection var1);
    }

    public static enum TenatProcessStoreState {
        ACTIVE,
        INACTIVE;

    }
}

