/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.mgt.services;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.dao.ActivityRecoveryDAO;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.FaultDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.ScopeStateEnum;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.DebuggerSupport;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evtproc.ActivityStateDocumentBuilder;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.pmapi.ActivityInfoDocument;
import org.apache.ode.bpel.pmapi.EventInfoListDocument;
import org.apache.ode.bpel.pmapi.ProcessNotFoundException;
import org.apache.ode.bpel.pmapi.ProcessingException;
import org.apache.ode.bpel.pmapi.TActivityInfo;
import org.apache.ode.bpel.pmapi.TActivityStatus;
import org.apache.ode.bpel.pmapi.TEventInfo;
import org.apache.ode.bpel.pmapi.TEventInfoList;
import org.apache.ode.bpel.pmapi.TFailureInfo;
import org.apache.ode.bpel.pmapi.TScopeStatus;
import org.apache.ode.il.OMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.bpel.core.ode.integration.BPELConstants;
import org.wso2.carbon.bpel.core.ode.integration.BPELServerImpl;
import org.wso2.carbon.bpel.core.ode.integration.store.ProcessConfigurationImpl;
import org.wso2.carbon.bpel.core.ode.integration.store.TenantProcessStoreImpl;
import org.wso2.carbon.bpel.core.ode.integration.utils.ActivityInfoWithEventsDocument;
import org.wso2.carbon.bpel.core.ode.integration.utils.ActivityLifeCycleEventsDocumentBuilder;
import org.wso2.carbon.bpel.core.ode.integration.utils.ActivityStateAndEventDocumentBuilder;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.InstanceManagementException;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.InstanceManagementServiceSkeletonInterface;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Action_type1;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ActivitiesWithEvents_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Activities_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ActivityInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ActivityInfoWithEventsType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ActivityLifeCycleEventsListType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ActivityLifeCycleEventsType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ActivityStatusType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ChildrenWithEvents_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Children_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.CorrelationPropertyType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.CorrelationSet_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.CorrelationSets_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Data_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.EventInfo;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.EventInfoList;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.FailureInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.FailuresInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.FaultInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.InstanceInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.InstanceInfoWithEventsType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.InstanceStatus;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.InstanceSummaryE;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.LimitedInstanceInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.PaginatedInstanceList;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ScopeInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ScopeInfoWithEventsType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ScopeStatusType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Value_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.VariableInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.VariableRefType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.VariablesWithEvents_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Variables_type0;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class InstanceManagementServiceSkeleton
extends AbstractAdmin
implements InstanceManagementServiceSkeletonInterface {
    private static Log log = LogFactory.getLog(InstanceManagementServiceSkeleton.class);
    private BPELServerImpl bpelServer = BPELServerImpl.getInstance();
    private Calendar calendar = Calendar.getInstance();
    private static Map<ScopeStateEnum, ScopeStatusType> scopeStatusMap = new HashMap<ScopeStateEnum, ScopeStatusType>();
    private static Map<TScopeStatus.Enum, ScopeStatusType> tscopeStatusMap = new HashMap<TScopeStatus.Enum, ScopeStatusType>();
    private static Map<TActivityStatus.Enum, ActivityStatusType> activityStatusMap = new HashMap<TActivityStatus.Enum, ActivityStatusType>();
    public static final String INSTANCE_STATUS_ACTIVE = "active";
    public static final String INSTANCE_STATUS_COMPLETED = "completed";
    public static final String INSTANCE_STATUS_FAILED = "failed";
    public static final String INSTANCE_STATUS_SUSPENDED = "suspended";
    public static final String INSTANCE_STATUS_TERMINATED = "terminated";

    public InstanceSummaryE getInstanceSummary() throws InstanceManagementException {
        InstanceSummaryE instanceSummary = new InstanceSummaryE();
        Integer tenantId = MultitenantUtils.getTenantId((ConfigurationContext)this.getConfigContext());
        TenantProcessStoreImpl tenantProcessStore = (TenantProcessStoreImpl)this.bpelServer.getMultiTenantProcessStore().getTenantsProcessStore(tenantId);
        instanceSummary.setActive(this.getInstanceCountByState(this.getTenantsProcessList(tenantProcessStore.getProcessConfigMap().keySet()), INSTANCE_STATUS_ACTIVE).intValue());
        instanceSummary.setCompleted(this.getInstanceCountByState(this.getTenantsProcessList(tenantProcessStore.getProcessConfigMap().keySet()), INSTANCE_STATUS_COMPLETED).intValue());
        instanceSummary.setFailed(this.getInstanceCountByState(this.getTenantsProcessList(tenantProcessStore.getProcessConfigMap().keySet()), INSTANCE_STATUS_FAILED).intValue());
        instanceSummary.setSuspended(this.getInstanceCountByState(this.getTenantsProcessList(tenantProcessStore.getProcessConfigMap().keySet()), INSTANCE_STATUS_SUSPENDED).intValue());
        instanceSummary.setTerminated(this.getInstanceCountByState(this.getTenantsProcessList(tenantProcessStore.getProcessConfigMap().keySet()), INSTANCE_STATUS_TERMINATED).intValue());
        return instanceSummary;
    }

    private boolean isProcessListEmpty(String processList) {
        return processList.trim().equals("pid=");
    }

    private Long getInstanceCountByState(String processList, String instanceState) throws InstanceManagementException {
        if (this.isProcessListEmpty(processList)) {
            return 0L;
        }
        final ArrayList instanceCountList = new ArrayList();
        StringBuilder filter = new StringBuilder();
        if (!this.isProcessListEmpty(processList)) {
            filter.append(processList);
        }
        filter.append("status=");
        filter.append(instanceState);
        final InstanceFilter instanceFilter = new InstanceFilter(filter.toString(), null, Integer.MAX_VALUE);
        try {
            BpelDatabase bpelDb = this.bpelServer.getODEBPELServer().getBpelDb();
            bpelDb.exec((BpelDatabase.Callable)new BpelDatabase.Callable<Object>(){

                public Object run(BpelDAOConnection conn) throws AxisFault {
                    instanceCountList.add(conn.instanceCount(instanceFilter));
                    return null;
                }
            });
        }
        catch (Exception e) {
            String errMsg = "Error querying instances from database. Filter: " + instanceFilter.toString();
            log.error((Object)errMsg, (Throwable)e);
            throw new InstanceManagementException(errMsg, (Throwable)e);
        }
        return (Long)instanceCountList.get(0);
    }

    public PaginatedInstanceList getPaginatedInstanceList(String filter, String order, int limit, final int page) throws InstanceManagementException {
        String tFilter = filter;
        final PaginatedInstanceList instanceList = new PaginatedInstanceList();
        Integer tenantId = MultitenantUtils.getTenantId((ConfigurationContext)this.getConfigContext());
        TenantProcessStoreImpl tenantProcessStore = (TenantProcessStoreImpl)this.bpelServer.getMultiTenantProcessStore().getTenantsProcessStore(tenantId);
        if (tenantProcessStore.getProcessConfigMap().size() <= 0) {
            instanceList.setPages(0);
            return instanceList;
        }
        if (!tFilter.contains(" pid=")) {
            tFilter = tFilter + this.getTenantsProcessList(tenantProcessStore.getProcessConfigMap().keySet());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Instance Filter:" + tFilter));
        }
        final InstanceFilter instanceFilter = new InstanceFilter(tFilter, order, limit);
        try {
            BpelDatabase bpelDb = this.bpelServer.getODEBPELServer().getBpelDb();
            bpelDb.exec((BpelDatabase.Callable)new BpelDatabase.Callable<Object>(){

                public Object run(BpelDAOConnection conn) throws InstanceManagementException {
                    Collection instances = conn.instanceQuery(instanceFilter);
                    int pageNum = page;
                    if (pageNum < 0 || pageNum == Integer.MAX_VALUE) {
                        pageNum = 0;
                    }
                    int startIndexOfCurrentPage = pageNum * BPELConstants.ITEMS_PER_PAGE;
                    int endIndexOfCurrentPage = (pageNum + 1) * BPELConstants.ITEMS_PER_PAGE;
                    int instanceListSize = instances.size();
                    int pages = (int)Math.ceil((double)instanceListSize / (double)BPELConstants.ITEMS_PER_PAGE.intValue());
                    instanceList.setPages(pages);
                    ProcessInstanceDAO[] instanceArray = instances.toArray(new ProcessInstanceDAO[instanceListSize]);
                    for (int i = startIndexOfCurrentPage; i < endIndexOfCurrentPage && i < instanceListSize; ++i) {
                        instanceList.addInstance(InstanceManagementServiceSkeleton.this.createLimitedInstanceInfoObject(instanceArray[i]));
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            String errMsg = "Error querying instances from database. Instance Filter:" + instanceFilter.toString();
            log.error((Object)errMsg, (Throwable)e);
            throw new InstanceManagementException(errMsg, (Throwable)e);
        }
        return instanceList;
    }

    public LimitedInstanceInfoType[] getLongRunningInstances(int limit) throws InstanceManagementException {
        final ArrayList longRunningInstances = new ArrayList();
        Integer tenantId = MultitenantUtils.getTenantId((ConfigurationContext)this.getConfigContext());
        TenantProcessStoreImpl tenantProcessStore = (TenantProcessStoreImpl)this.bpelServer.getMultiTenantProcessStore().getTenantsProcessStore(tenantId);
        if (tenantProcessStore.getProcessConfigMap().size() <= 0) {
            return longRunningInstances.toArray(new LimitedInstanceInfoType[longRunningInstances.size()]);
        }
        String filter = "status=ACTIVE";
        if (!filter.contains(" pid=")) {
            filter = filter + this.getTenantsProcessList(tenantProcessStore.getProcessConfigMap().keySet());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Instance Filter:" + filter));
        }
        String orderBy = "started";
        final InstanceFilter instanceFilter = new InstanceFilter(filter, orderBy, limit);
        try {
            BpelDatabase bpelDb = this.bpelServer.getODEBPELServer().getBpelDb();
            bpelDb.exec((BpelDatabase.Callable)new BpelDatabase.Callable<Object>(){

                public Object run(BpelDAOConnection conn) throws InstanceManagementException {
                    Collection instances = conn.instanceQuery(instanceFilter);
                    for (ProcessInstanceDAO piDAO : instances) {
                        longRunningInstances.add(InstanceManagementServiceSkeleton.this.createLimitedInstanceInfoObject(piDAO));
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            String errMsg = "Error querying instances from database. Instance Filter:" + instanceFilter.toString();
            log.error((Object)errMsg, (Throwable)e);
            throw new InstanceManagementException(errMsg, (Throwable)e);
        }
        return longRunningInstances.toArray(new LimitedInstanceInfoType[longRunningInstances.size()]);
    }

    public InstanceInfoType getInstanceInfo(long iid) throws InstanceManagementException {
        try {
            this.isOperationIsValidForTheCurrentTenant(iid);
        }
        catch (IllegalAccessException ex) {
            return this.handleError(ex);
        }
        return this.getInstanceInformation(iid);
    }

    private InstanceInfoType handleError(IllegalAccessException ex) throws InstanceManagementException {
        String errMsg = "You are trying to carry out unauthorized operation!";
        log.error((Object)errMsg);
        throw new InstanceManagementException(errMsg, (Throwable)ex);
    }

    public InstanceInfoWithEventsType getInstanceInfoWithEvents(long iid) throws InstanceManagementException {
        try {
            this.isOperationIsValidForTheCurrentTenant(iid);
        }
        catch (IllegalAccessException ex) {
            this.handleError(ex);
        }
        return this.getInstanceInformationWithEvents(iid);
    }

    public ActivityLifeCycleEventsType getActivityLifeCycleFilter(long iid) throws InstanceManagementException {
        try {
            this.isOperationIsValidForTheCurrentTenant(iid);
        }
        catch (IllegalAccessException ex) {
            this.handleError(ex);
        }
        return this.getActivityLifeCycleEvents(iid);
    }

    public void recoverActivity(final long iid, final long aid, final Action_type1 action) throws InstanceManagementException {
        try {
            this.dbexec(new BpelDatabase.Callable<QName>(){

                public QName run(BpelDAOConnection conn) throws Exception {
                    ProcessInstanceDAO instance = conn.getInstance(Long.valueOf(iid));
                    if (instance == null) {
                        return null;
                    }
                    for (ActivityRecoveryDAO recovery : instance.getActivityRecoveries()) {
                        BpelProcess process;
                        if (recovery.getActivityId() != aid || (process = (BpelProcess)((BpelEngineImpl)((InstanceManagementServiceSkeleton)InstanceManagementServiceSkeleton.this).bpelServer.getODEBPELServer().getEngine())._activeProcesses.get(instance.getProcess().getProcessId())) == null) continue;
                        if (action == Action_type1.cancel) {
                            process.recoverActivity(instance, recovery.getChannel(), aid, Action_type1.cancel.getValue(), null);
                            log.info((Object)("Activity retrying is canceled for activity: " + aid + " of instance: " + iid));
                            break;
                        }
                        if (action == Action_type1.retry) {
                            process.recoverActivity(instance, recovery.getChannel(), aid, Action_type1.retry.getValue(), null);
                            log.info((Object)("Activity is retried for activity: " + aid + " of instance: " + iid));
                            break;
                        }
                        log.warn((Object)("Invalid retry action: " + action + " for activity: " + aid + " of instance: " + iid));
                        break;
                    }
                    return instance.getProcess().getProcessId();
                }
            });
        }
        catch (Exception e) {
            String errMsg = "Exception occurred while recovering the activity: " + aid + " of ths instance: " + iid + " action: " + action.getValue();
            log.error((Object)errMsg, (Throwable)e);
            throw new InstanceManagementException(errMsg, (Throwable)e);
        }
    }

    private ActivityLifeCycleEventsType getActivityLifeCycleEvents(final long iid) throws InstanceManagementException {
        final ActivityLifeCycleEventsType activityLifeCycleEvents = new ActivityLifeCycleEventsType();
        activityLifeCycleEvents.setIid(Long.toString(iid));
        this.dbexec(new BpelDatabase.Callable<Object>(){

            public Object run(BpelDAOConnection conn) throws InstanceManagementException {
                ProcessInstanceDAO instance = conn.getInstance(Long.valueOf(iid));
                if (instance == null) {
                    String errMsg = "Instance " + iid + " not found.";
                    log.error((Object)errMsg);
                    throw new InstanceManagementException(errMsg);
                }
                InstanceManagementServiceSkeleton.this.fillActivityLifeCycleEvents(activityLifeCycleEvents, instance);
                return null;
            }
        });
        return activityLifeCycleEvents;
    }

    private void fillActivityLifeCycleEvents(ActivityLifeCycleEventsType eventInfoArray, ProcessInstanceDAO processInstance) throws InstanceManagementException {
        eventInfoArray.setPid(processInstance.getProcess().getProcessId().toString());
        if (processInstance.getRootScope() != null) {
            eventInfoArray.setEventInfoList(this.getActivityLifeCycleEventsFromScope(processInstance.getRootScope().getScopeInstanceId()));
        }
    }

    private ActivityLifeCycleEventsListType getActivityLifeCycleEventsFromScope(final long siid) throws InstanceManagementException {
        final ActivityLifeCycleEventsListType activityLifeCycleEventsList = new ActivityLifeCycleEventsListType();
        this.dbexec(new BpelDatabase.Callable<Object>(){

            public Object run(BpelDAOConnection conn) throws InstanceManagementException {
                ScopeDAO scope = conn.getScope(Long.valueOf(siid));
                if (scope == null) {
                    String errMsg = "Scope " + siid + " not found.";
                    log.error((Object)errMsg);
                    throw new InstanceManagementException(errMsg);
                }
                InstanceManagementServiceSkeleton.this.fillActivityLifeCycleEventsFromScope(activityLifeCycleEventsList, scope);
                return null;
            }
        });
        return activityLifeCycleEventsList;
    }

    private void fillActivityLifeCycleEventsFromScope(ActivityLifeCycleEventsListType activityLifeCycleEventsList, ScopeDAO scope) {
        List events = scope.listEvents();
        ActivityLifeCycleEventsDocumentBuilder docBuilder = new ActivityLifeCycleEventsDocumentBuilder();
        for (BpelEvent e : events) {
            docBuilder.onEvent(e);
        }
        EventInfoListDocument infoList = docBuilder.getActivityLifeCycleEvents();
        this.fillActivityLifeCycleEventsList(activityLifeCycleEventsList, infoList);
        for (ScopeDAO childScope : scope.getChildScopes()) {
            this.fillActivityLifeCycleEventsFromScope(activityLifeCycleEventsList, childScope);
        }
    }

    private void fillActivityLifeCycleEventsList(ActivityLifeCycleEventsListType activityLifeCycleEventsList, EventInfoListDocument infoList) {
        List list = infoList.getEventInfoList() == null ? infoList.addNewEventInfoList().getEventInfoList() : infoList.getEventInfoList().getEventInfoList();
        ArrayList<EventInfo> eventInfoList = new ArrayList<EventInfo>();
        HashMap<Long, Boolean> isFaultMap = new HashMap<Long, Boolean>();
        for (TEventInfo tInfo : list) {
            EventInfo info = new EventInfo();
            info.setType(tInfo.getType());
            info.setName(tInfo.getName());
            info.setLineNumber(tInfo.getLineNumber());
            info.setTimestamp(tInfo.getTimestamp());
            info.setActivityId(tInfo.getActivityId());
            info.setActivityName(tInfo.getActivityName());
            if (tInfo.getName().equals("ActivityFailureEvent")) {
                if (isFaultMap.get(tInfo.getActivityId()) == null) {
                    isFaultMap.put(tInfo.getActivityId(), true);
                }
            } else if (tInfo.getName().equals("ActivityExecEndEvent")) {
                if (isFaultMap.get(tInfo.getActivityId()) != null) {
                    isFaultMap.remove(tInfo.getActivityId());
                }
                isFaultMap.put(tInfo.getActivityId(), false);
            }
            info.setActivityType(tInfo.getActivityType());
            info.setScopeId(tInfo.getScopeId());
            info.setScopeName(tInfo.getScopeName());
            eventInfoList.add(info);
        }
        for (EventInfo info : eventInfoList) {
            boolean isFault = isFaultMap.get(info.getActivityId()) == null ? false : (Boolean)isFaultMap.get(info.getActivityId());
            info.setIsRecoveryRequired(isFault);
            activityLifeCycleEventsList.addEventInfo(info);
        }
    }

    public void resumeInstance(long iid) throws InstanceManagementException {
        try {
            this.isOperationIsValidForTheCurrentTenant(iid);
        }
        catch (IllegalAccessException ex) {
            this.handleError(ex);
        }
        DebuggerSupport debugSupport = this.getDebugger(iid);
        if (debugSupport == null) {
            String errMsg = "Cannot resume the instance " + iid + ", Debugger support not available";
            log.error((Object)errMsg);
            throw new InstanceManagementException(errMsg);
        }
        debugSupport.resume(Long.valueOf(iid));
    }

    public void suspendInstance(long iid) throws InstanceManagementException {
        try {
            this.isOperationIsValidForTheCurrentTenant(iid);
        }
        catch (IllegalAccessException ex) {
            this.handleError(ex);
        }
        DebuggerSupport debugSupport = this.getDebugger(iid);
        if (debugSupport == null) {
            String errMsg = "Cannot suspend the instance " + iid + ", Debugger support not available";
            log.error((Object)errMsg);
            throw new InstanceManagementException(errMsg);
        }
        debugSupport.suspend(Long.valueOf(iid));
    }

    public void terminateInstance(long iid) throws InstanceManagementException {
        try {
            this.isOperationIsValidForTheCurrentTenant(iid);
        }
        catch (IllegalAccessException ex) {
            this.handleError(ex);
        }
        DebuggerSupport debugSupport = this.getDebugger(iid);
        if (debugSupport == null) {
            String erMsg = "Cannot terminate the instance " + iid + ", Debugger support not available";
            log.error((Object)erMsg);
            throw new InstanceManagementException(erMsg);
        }
        debugSupport.terminate(Long.valueOf(iid));
    }

    public int deleteInstances(String filter, final boolean deleteMessageExchanges) throws InstanceManagementException {
        String tFilter = filter;
        Integer tenantId = MultitenantUtils.getTenantId((ConfigurationContext)this.getConfigContext());
        TenantProcessStoreImpl tenantProcessStore = (TenantProcessStoreImpl)this.bpelServer.getMultiTenantProcessStore().getTenantsProcessStore(tenantId);
        if (this.isInvalidFilter(tFilter)) {
            String errMsg = "Invalid instance filter: " + tFilter;
            log.error((Object)errMsg);
            throw new InstanceManagementException(errMsg);
        }
        if (!this.isSecureFilter(new InstanceFilter(tFilter), tenantProcessStore.getProcessConfigMap().keySet())) {
            String errMsg = "Instance deletion operation not permitted due to insecure filter: " + tFilter;
            log.error((Object)errMsg);
            throw new InstanceManagementException(errMsg);
        }
        if (!tFilter.contains(" pid=")) {
            tFilter = tFilter + this.getTenantsProcessList(tenantProcessStore.getProcessConfigMap().keySet());
        }
        final InstanceFilter instanceFilter = new InstanceFilter(tFilter);
        final LinkedList ret = new LinkedList();
        try {
            this.dbexec(new BpelDatabase.Callable<Object>(){

                public Object run(BpelDAOConnection conn) throws IllegalAccessException {
                    Collection instances = conn.instanceQuery(instanceFilter);
                    for (ProcessInstanceDAO instance : instances) {
                        InstanceManagementServiceSkeleton.this.isOperationIsValidForTheCurrentTenant(instance.getProcess().getProcessId());
                    }
                    for (ProcessInstanceDAO instance : instances) {
                        instance.delete(EnumSet.allOf(ProcessConf.CLEANUP_CATEGORY.class), deleteMessageExchanges);
                        ret.add(instance.getInstanceId());
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            String errMsg = "Exception during instance deletion. Filter: " + instanceFilter.toString();
            log.error((Object)errMsg, (Throwable)e);
            throw new InstanceManagementException(errMsg, (Throwable)e);
        }
        return ret.size();
    }

    private boolean isInvalidFilter(String filter) {
        if (filter == null) {
            return false;
        }
        Matcher expressionMatcher = Filter.__comparatorPattern.matcher(filter);
        return !filter.trim().equals("") && !expressionMatcher.find();
    }

    private QName getProcess(final Long iid) {
        QName processId;
        try {
            processId = this.dbexec(new BpelDatabase.Callable<QName>(){

                public QName run(BpelDAOConnection conn) throws Exception {
                    ProcessInstanceDAO instance = conn.getInstance(iid);
                    return instance == null ? null : instance.getProcess().getProcessId();
                }
            });
        }
        catch (Exception e) {
            String errMsg = "Exception during instance: " + iid + " retrieval";
            log.error((Object)errMsg, (Throwable)e);
            throw new ProcessingException(errMsg + ": " + e.toString(), (Throwable)e);
        }
        return processId;
    }

    private DebuggerSupport getDebugger(final Long iid) throws InstanceManagementException {
        QName processId;
        try {
            processId = (QName)this.bpelServer.getODEBPELServer().getBpelDb().exec((BpelDatabase.Callable)new BpelDatabase.Callable<QName>(){

                public QName run(BpelDAOConnection conn) throws Exception {
                    ProcessInstanceDAO instance = conn.getInstance(iid);
                    return instance == null ? null : instance.getProcess().getProcessId();
                }
            });
        }
        catch (Exception e) {
            String errMsg = "Exception during instance " + iid + " retrieval";
            log.error((Object)errMsg, (Throwable)e);
            throw new InstanceManagementException(errMsg, (Throwable)e);
        }
        return this.getDebugger(processId);
    }

    protected final DebuggerSupport getDebugger(QName processId) {
        BpelProcess process = (BpelProcess)((BpelEngineImpl)this.bpelServer.getODEBPELServer().getEngineUnsecured())._activeProcesses.get(processId);
        if (process == null) {
            String errMsg = "The process \"" + processId + "\" does not exist.";
            throw new ProcessNotFoundException(errMsg);
        }
        return process.getDebuggerSupport();
    }

    private InstanceInfoType getInstanceInformation(final long iid) throws InstanceManagementException {
        final InstanceInfoType instanceInfo = new InstanceInfoType();
        instanceInfo.setIid(Long.toString(iid));
        this.dbexec(new BpelDatabase.Callable<Object>(){

            public Object run(BpelDAOConnection conn) throws InstanceManagementException {
                ProcessInstanceDAO instance = conn.getInstance(Long.valueOf(iid));
                if (instance == null) {
                    String errMsg = "Instance " + iid + " not found.";
                    log.error((Object)errMsg);
                    throw new InstanceManagementException(errMsg);
                }
                InstanceManagementServiceSkeleton.this.fillInstanceInfo(instanceInfo, instance);
                return null;
            }
        });
        return instanceInfo;
    }

    private InstanceInfoWithEventsType getInstanceInformationWithEvents(final long iid) throws InstanceManagementException {
        final InstanceInfoWithEventsType instanceInfoWithEvents = new InstanceInfoWithEventsType();
        instanceInfoWithEvents.setIid(Long.toString(iid));
        this.dbexec(new BpelDatabase.Callable<Object>(){

            public Object run(BpelDAOConnection conn) throws InstanceManagementException {
                ProcessInstanceDAO instance = conn.getInstance(Long.valueOf(iid));
                if (instance == null) {
                    String errMsg = "Instance " + iid + " not found.";
                    log.error((Object)errMsg);
                    throw new InstanceManagementException(errMsg);
                }
                InstanceManagementServiceSkeleton.this.fillInstanceInfoWithEvents(instanceInfoWithEvents, instance);
                return null;
            }
        });
        return instanceInfoWithEvents;
    }

    private void fillInstanceInfo(InstanceInfoType instanceInfo, ProcessInstanceDAO processInstance) throws InstanceManagementException {
        instanceInfo.setIid(processInstance.getInstanceId().toString());
        instanceInfo.setPid(processInstance.getProcess().getProcessId().toString());
        instanceInfo.setDateStarted(this.toCalendar(processInstance.getCreateTime()));
        instanceInfo.setDateLastActive(this.toCalendar(processInstance.getLastActiveTime()));
        instanceInfo.setStatus(this.odeInstanceStatusToManagementAPIStatus(processInstance.getState()));
        instanceInfo.setIsEventsEnabled(((ProcessConfigurationImpl)this.getTenantProcessForCurrentSession().getProcessConfiguration(QName.valueOf(instanceInfo.getPid()))).getEventsEnabled());
        this.fillFaultAndFailure(processInstance, instanceInfo);
        if (processInstance.getRootScope() != null) {
            instanceInfo.setRootScope(this.getScopeInfo(processInstance.getRootScope().getScopeInstanceId()));
        }
    }

    private void fillInstanceInfoWithEvents(InstanceInfoWithEventsType instanceInfoWithEvents, ProcessInstanceDAO processInstance) throws InstanceManagementException {
        instanceInfoWithEvents.setIid(processInstance.getInstanceId().toString());
        instanceInfoWithEvents.setPid(processInstance.getProcess().getProcessId().toString());
        instanceInfoWithEvents.setDateStarted(this.toCalendar(processInstance.getCreateTime()));
        instanceInfoWithEvents.setDateLastActive(this.toCalendar(processInstance.getLastActiveTime()));
        instanceInfoWithEvents.setStatus(this.odeInstanceStatusToManagementAPIStatus(processInstance.getState()));
        this.fillFaultAndFailure(processInstance, instanceInfoWithEvents);
        if (processInstance.getRootScope() != null) {
            instanceInfoWithEvents.setRootScope(this.getScopeInfoWithEvents(processInstance.getRootScope().getScopeInstanceId()));
        }
    }

    private void fillFaultAndFailure(ProcessInstanceDAO instance, InstanceInfoWithEventsType instanceInfoWithEvents) {
        InstanceInfoType instanceInfo = new InstanceInfoType();
        this.fillFaultAndFailure(instance, instanceInfo);
        if (instance.getFault() != null) {
            instanceInfoWithEvents.setFaultInfo(instanceInfo.getFaultInfo());
        }
        if (instance.getActivityFailureCount() > 0) {
            instanceInfoWithEvents.setFailuresInfo(instanceInfo.getFailuresInfo());
        }
    }

    private void fillFaultAndFailure(ProcessInstanceDAO instance, InstanceInfoType instanceInfo) {
        if (instance.getFault() != null) {
            FaultDAO fault = instance.getFault();
            FaultInfoType faultInfo = new FaultInfoType();
            faultInfo.setName(fault.getName());
            faultInfo.setExplanation(fault.getExplanation());
            faultInfo.setLineNumber(fault.getLineNo());
            faultInfo.setAiid(fault.getActivityId());
            Data_type0 data = new Data_type0();
            if (fault.getData() == null) {
                OMFactory omFac = OMAbstractFactory.getOMFactory();
                OMElement faultDataEle = omFac.createOMElement("no-data", null);
                faultDataEle.setText("No data available.");
                data.addExtraElement(faultDataEle);
            } else {
                data.addExtraElement(OMUtils.toOM((Element)fault.getData(), (OMFactory)OMAbstractFactory.getOMFactory()));
            }
            faultInfo.setData(data);
            instanceInfo.setFaultInfo(faultInfo);
        }
        if (instance.getActivityFailureCount() > 0) {
            FailuresInfoType failuresInfo = new FailuresInfoType();
            failuresInfo.setCount(instance.getActivityFailureCount());
            failuresInfo.setDateFailure(this.toCalendar(instance.getActivityFailureDateTime()));
            instanceInfo.setFailuresInfo(failuresInfo);
        }
    }

    private <T> T dbexec(BpelDatabase.Callable<T> callable) throws InstanceManagementException {
        try {
            BpelDatabase bpelDb = this.bpelServer.getODEBPELServer().getBpelDb();
            return (T)bpelDb.exec(callable);
        }
        catch (Exception ex) {
            String errMsg = "Exception during database operation";
            log.error((Object)errMsg, (Throwable)ex);
            throw new InstanceManagementException(errMsg, (Throwable)ex);
        }
    }

    private InstanceStatus odeInstanceStatusToManagementAPIStatus(short status) throws InstanceManagementException {
        switch (status) {
            case 0: 
            case 10: 
            case 20: {
                return InstanceStatus.ACTIVE;
            }
            case 30: {
                return InstanceStatus.COMPLETED;
            }
            case 40: {
                return InstanceStatus.FAILED;
            }
            case 50: {
                return InstanceStatus.SUSPENDED;
            }
            case 60: {
                return InstanceStatus.TERMINATED;
            }
        }
        String errMsg = "Encountered unexpected instance state: " + status;
        log.error((Object)errMsg);
        throw new InstanceManagementException(errMsg);
    }

    private ScopeStatusType odeScopeStatusToManagementAPIStatus(ScopeStateEnum status) {
        return scopeStatusMap.get(status);
    }

    private LimitedInstanceInfoType createLimitedInstanceInfoObject(ProcessInstanceDAO instanceDAO) throws InstanceManagementException {
        LimitedInstanceInfoType instanceInfo = new LimitedInstanceInfoType();
        instanceInfo.setIid(Long.toString(instanceDAO.getInstanceId()));
        instanceInfo.setPid(instanceDAO.getProcess().getProcessId().toString());
        instanceInfo.setStatus(this.odeInstanceStatusToManagementAPIStatus(instanceDAO.getState()));
        instanceInfo.setDateLastActive(this.toCalendar(instanceDAO.getLastActiveTime()));
        instanceInfo.setDateStarted(this.toCalendar(instanceDAO.getCreateTime()));
        return instanceInfo;
    }

    private String getTenantsProcessList(Set<QName> processIds) {
        StringBuilder tenantsProcessList = new StringBuilder();
        tenantsProcessList.append(" ");
        tenantsProcessList.append("pid=");
        for (QName pid : processIds) {
            tenantsProcessList.append(pid.toString());
            tenantsProcessList.append("|");
        }
        tenantsProcessList.append(" ");
        return tenantsProcessList.toString();
    }

    private Calendar toCalendar(Date dtime) {
        if (dtime == null) {
            return null;
        }
        Calendar c = (Calendar)this.calendar.clone();
        c.setTime(dtime);
        return c;
    }

    private ScopeInfoType getScopeInfo(final long siid) throws InstanceManagementException {
        final ScopeInfoType scopeInfo = new ScopeInfoType();
        this.dbexec(new BpelDatabase.Callable<Object>(){

            public Object run(BpelDAOConnection conn) throws InstanceManagementException {
                ScopeDAO scope = conn.getScope(Long.valueOf(siid));
                if (scope == null) {
                    String errMsg = "Scope " + siid + " not found.";
                    log.error((Object)errMsg);
                    throw new InstanceManagementException(errMsg);
                }
                InstanceManagementServiceSkeleton.this.fillScopeInfo(scopeInfo, scope);
                return null;
            }
        });
        return scopeInfo;
    }

    private ScopeInfoWithEventsType getScopeInfoWithEvents(final long siid) throws InstanceManagementException {
        final ScopeInfoWithEventsType scopeInfoWithEvents = new ScopeInfoWithEventsType();
        this.dbexec(new BpelDatabase.Callable<Object>(){

            public Object run(BpelDAOConnection conn) throws InstanceManagementException {
                ScopeDAO scope = conn.getScope(Long.valueOf(siid));
                if (scope == null) {
                    String errMsg = "Scope " + siid + " not found.";
                    log.error((Object)errMsg);
                    throw new InstanceManagementException(errMsg);
                }
                InstanceManagementServiceSkeleton.this.fillScopeInfoWithEvents(scopeInfoWithEvents, scope);
                return null;
            }
        });
        return scopeInfoWithEvents;
    }

    private void fillScopeInfo(ScopeInfoType scopeInfo, ScopeDAO scope) {
        scopeInfo.setSiid(scope.getScopeInstanceId().toString());
        scopeInfo.setName(scope.getName());
        scopeInfo.setStatus(this.odeScopeStatusToManagementAPIStatus(scope.getState()));
        Children_type0 childScopes = new Children_type0();
        for (ScopeDAO childScope : scope.getChildScopes()) {
            ScopeInfoType childScopeInfo = new ScopeInfoType();
            this.fillScopeInfo(childScopeInfo, childScope);
            childScopes.addChildRef(childScopeInfo);
        }
        scopeInfo.setChildren(childScopes);
        scopeInfo.setVariables(this.getVariables(scope));
        if (!scope.getCorrelationSets().isEmpty()) {
            scopeInfo.setCorrelationSets(this.getCorrelationPropertires(scope));
        }
        scopeInfo.setActivities(this.getActivities(scope));
    }

    private void fillScopeInfoWithEvents(ScopeInfoWithEventsType scopeInfoWithEvents, ScopeDAO scope) {
        scopeInfoWithEvents.setSiid(scope.getScopeInstanceId().toString());
        scopeInfoWithEvents.setName(scope.getName());
        scopeInfoWithEvents.setStatus(this.odeScopeStatusToManagementAPIStatus(scope.getState()));
        ChildrenWithEvents_type0 childScopesWithEvents = new ChildrenWithEvents_type0();
        for (ScopeDAO childScope : scope.getChildScopes()) {
            ScopeInfoWithEventsType childScopeInfoWithEvents = new ScopeInfoWithEventsType();
            this.fillScopeInfoWithEvents(childScopeInfoWithEvents, childScope);
            childScopesWithEvents.addChildWithEventsRef(childScopeInfoWithEvents);
        }
        scopeInfoWithEvents.setChildrenWithEvents(childScopesWithEvents);
        scopeInfoWithEvents.setVariablesWithEvents(this.getVariablesWithEvents(scope));
        scopeInfoWithEvents.setActivitiesWithEvents(this.getActivitiesWithEvents(scope));
    }

    private VariablesWithEvents_type0 getVariablesWithEvents(ScopeDAO scope) {
        scope.listEvents();
        return null;
    }

    private Activities_type0 getActivities(ScopeDAO scope) {
        Activities_type0 activities = new Activities_type0();
        Collection recoveries = scope.getProcessInstance().getActivityRecoveries();
        List events = scope.listEvents();
        ActivityStateDocumentBuilder b = new ActivityStateDocumentBuilder();
        for (BpelEvent e : events) {
            b.onEvent(e);
        }
        for (ActivityInfoDocument ai : b.getActivities()) {
            for (ActivityRecoveryDAO recovery : recoveries) {
                if (!String.valueOf(recovery.getActivityId()).equals(ai.getActivityInfo().getAiid())) continue;
                TFailureInfo failure = ai.getActivityInfo().addNewFailure();
                failure.setReason(recovery.getReason());
                failure.setDtFailure(this.toCalendar(recovery.getDateTime()));
                failure.setActions(recovery.getActions());
                failure.setRetries(recovery.getRetries());
                ai.getActivityInfo().setStatus(TActivityStatus.FAILURE);
            }
            ActivityInfoType activity = new ActivityInfoType();
            this.fillActivityInfo(activity, ai.getActivityInfo());
            activities.addActivityInfo(activity);
        }
        return activities;
    }

    private ActivitiesWithEvents_type0 getActivitiesWithEvents(ScopeDAO scope) {
        ActivitiesWithEvents_type0 activitiesWithEvents = new ActivitiesWithEvents_type0();
        Collection recoveries = scope.getProcessInstance().getActivityRecoveries();
        List events = scope.listEvents();
        ActivityStateAndEventDocumentBuilder docBuilder = new ActivityStateAndEventDocumentBuilder();
        for (BpelEvent e : events) {
            docBuilder.onEvent(e);
        }
        for (ActivityInfoWithEventsDocument aweDoc : docBuilder.getActivitiesWithEvents()) {
            for (ActivityRecoveryDAO recovery : recoveries) {
                if (!String.valueOf(recovery.getActivityId()).equals(aweDoc.getActivityInfoDoc().getActivityInfo().getAiid())) continue;
                TFailureInfo failure = aweDoc.getActivityInfoDoc().getActivityInfo().addNewFailure();
                failure.setReason(recovery.getReason());
                failure.setDtFailure(this.toCalendar(recovery.getDateTime()));
                failure.setActions(recovery.getActions());
                failure.setRetries(recovery.getRetries());
                aweDoc.getActivityInfoDoc().getActivityInfo().setStatus(TActivityStatus.FAILURE);
            }
            ActivityInfoWithEventsType activityWE = new ActivityInfoWithEventsType();
            TActivityInfo actInfoDoc = aweDoc.getActivityInfoDoc().getActivityInfo();
            TEventInfoList evtInfoList = aweDoc.getEventInfoList().getEventInfoList();
            ActivityInfoType activity = this.fillActivityInfo(new ActivityInfoType(), actInfoDoc);
            EventInfoList eventList = this.fillEventInfo(new EventInfoList(), evtInfoList);
            activityWE.setActivityInfo(activity);
            activityWE.setActivityEventsList(eventList);
            activitiesWithEvents.addActivityInfoWithEvents(activityWE);
        }
        return activitiesWithEvents;
    }

    private EventInfoList fillEventInfo(EventInfoList eventInfoList, TEventInfoList infoList) {
        EventInfo[] infoArray = new EventInfo[infoList.sizeOfEventInfoArray()];
        List list = infoList.getEventInfoList();
        for (int i = 0; i < list.size(); ++i) {
            infoArray[i] = new EventInfo();
            EventInfo eventInfo = infoArray[i];
            TEventInfo listElem = (TEventInfo)list.get(i);
            eventInfo.setName(listElem.getName());
            eventInfo.setType(listElem.getType());
            eventInfo.setLineNumber(listElem.getLineNumber());
            eventInfo.setTimestamp(listElem.getTimestamp());
        }
        eventInfoList.setEventInfo(infoArray);
        return eventInfoList;
    }

    private CorrelationSets_type0 getCorrelationPropertires(ScopeDAO scope) {
        CorrelationSets_type0 correlationSets = new CorrelationSets_type0();
        for (CorrelationSetDAO correlationSetDAO : scope.getCorrelationSets()) {
            CorrelationSet_type0 correlationset = new CorrelationSet_type0();
            correlationset.setCsetid(correlationSetDAO.getCorrelationSetId().toString());
            correlationset.setName(correlationSetDAO.getName());
            for (Map.Entry property : correlationSetDAO.getProperties().entrySet()) {
                CorrelationPropertyType prop = new CorrelationPropertyType();
                prop.setCsetid(correlationSetDAO.getCorrelationSetId().toString());
                prop.setPropertyName((QName)property.getKey());
                prop.setString((String)property.getValue());
                correlationset.addCorrelationProperty(prop);
            }
            correlationSets.addCorrelationSet(correlationset);
        }
        return correlationSets;
    }

    private Variables_type0 getVariables(ScopeDAO scope) {
        Variables_type0 variables = new Variables_type0();
        for (XmlDataDAO var : scope.getVariables()) {
            OMFactory omFac;
            VariableRefType varRef = new VariableRefType();
            varRef.setIid(var.getScopeDAO().getProcessInstance().getInstanceId().toString());
            varRef.setSiid(var.getScopeDAO().getScopeInstanceId().toString());
            varRef.setName(var.getName());
            VariableInfoType varInfoType = new VariableInfoType();
            varInfoType.setSelf(varRef);
            Node val = var.get();
            Value_type0 value = new Value_type0();
            if (val == null) {
                omFac = OMAbstractFactory.getOMFactory();
                OMElement emptyEle = omFac.createOMElement("empty-value", null);
                emptyEle.setText("Nil");
                value.addExtraElement(emptyEle);
            } else if (val.getNodeType() == 3) {
                omFac = OMAbstractFactory.getOMFactory();
                OMElement tempSimpleTypeWrapper = omFac.createOMElement(var.getName(), null);
                tempSimpleTypeWrapper.setText(val.getTextContent());
                value.addExtraElement(tempSimpleTypeWrapper);
            } else {
                value.addExtraElement(OMUtils.toOM((Element)((Element)val), (OMFactory)OMAbstractFactory.getOMFactory()));
            }
            varInfoType.setValue(value);
            variables.addVariableInfo(varInfoType);
        }
        return variables;
    }

    private ActivityInfoType fillActivityInfo(ActivityInfoType activity, TActivityInfo actInfo) {
        activity.setAiid(actInfo.getAiid());
        activity.setDateCompleted(actInfo.getDtCompleted());
        activity.setDateEnabled(actInfo.getDtEnabled());
        activity.setDateStarted(actInfo.getDtStarted());
        activity.setName(actInfo.getName());
        activity.setType(actInfo.getType());
        TFailureInfo failure = actInfo.getFailure();
        if (failure != null) {
            FailureInfoType failureInfo = new FailureInfoType();
            failureInfo.setActions(failure.getActions());
            failureInfo.setDateFailure(failure.getDtFailure());
            failureInfo.setReason(failure.getReason());
            failureInfo.setRetries(failure.getRetries());
            activity.setFailure(failureInfo);
        }
        activity.setStatus(activityStatusMap.get(actInfo.getStatus()));
        return activity;
    }

    private void isOperationIsValidForTheCurrentTenant(long iid) throws IllegalAccessException, ProcessingException {
        QName processId = this.getProcess(iid);
        TenantProcessStoreImpl processStore = this.getTenantProcessForCurrentSession();
        if (!processStore.containsProcess(processId).booleanValue()) {
            log.error((Object)("Trying to invoke a illegal operation. Instance ID:" + iid));
            throw new IllegalAccessException("Operation is not permitted.");
        }
    }

    private void isOperationIsValidForTheCurrentTenant(QName pid) throws IllegalAccessException {
        if (!this.getTenantProcessForCurrentSession().containsProcess(pid).booleanValue()) {
            log.error((Object)("Trying to invoke a illegal operation. Process ID:" + pid));
            throw new IllegalAccessException("Operation is not permitted.");
        }
    }

    private TenantProcessStoreImpl getTenantProcessForCurrentSession() {
        Integer tenantId = MultitenantUtils.getTenantId((ConfigurationContext)this.getConfigContext());
        return (TenantProcessStoreImpl)this.bpelServer.getMultiTenantProcessStore().getTenantsProcessStore(tenantId);
    }

    private boolean isSecureFilter(InstanceFilter filter, Set<QName> processIds) {
        List pids = filter.getPidFilter();
        HashSet<String> strPids = new HashSet<String>();
        if (pids != null) {
            for (QName pidQName : processIds) {
                strPids.add(pidQName.toString());
            }
            for (String pid : pids) {
                if (strPids.contains(pid)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        scopeStatusMap.put(ScopeStateEnum.ACTIVE, ScopeStatusType.ACTIVE);
        scopeStatusMap.put(ScopeStateEnum.NEW, ScopeStatusType.NEW);
        scopeStatusMap.put(ScopeStateEnum.COMPLETED, ScopeStatusType.COMPLETED);
        scopeStatusMap.put(ScopeStateEnum.FAULT, ScopeStatusType.FAULTED);
        tscopeStatusMap.put(TScopeStatus.ACTIVE, ScopeStatusType.ACTIVE);
        tscopeStatusMap.put(TScopeStatus.COMPENSATED, ScopeStatusType.COMPENSATED);
        tscopeStatusMap.put(TScopeStatus.COMPENSATING, ScopeStatusType.COMPENSATING);
        tscopeStatusMap.put(TScopeStatus.COMPLETED, ScopeStatusType.COMPLETED);
        tscopeStatusMap.put(TScopeStatus.FAULTED, ScopeStatusType.FAULTED);
        tscopeStatusMap.put(TScopeStatus.FAULTHANDLING, ScopeStatusType.FAULTHANDLING);
        activityStatusMap.put(TActivityStatus.COMPLETED, ActivityStatusType.COMPLETED);
        activityStatusMap.put(TActivityStatus.ENABLED, ActivityStatusType.ENABLED);
        activityStatusMap.put(TActivityStatus.FAILURE, ActivityStatusType.FAILURE);
        activityStatusMap.put(TActivityStatus.STARTED, ActivityStatusType.STARTED);
    }
}

