/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.mgt.services;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.core.ode.integration.BPELConstants;
import org.wso2.carbon.bpel.core.ode.integration.BPELServerImpl;
import org.wso2.carbon.bpel.core.ode.integration.store.TenantProcessStoreImpl;
import org.wso2.carbon.bpel.core.ode.integration.store.repository.BPELPackageInfo;
import org.wso2.carbon.bpel.core.ode.integration.store.repository.BPELPackageRepository;
import org.wso2.carbon.bpel.core.ode.integration.utils.AdminServiceUtils;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.BPELPackageManagementServiceSkeletonInterface;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.PackageManagementException;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.DeployedPackagesPaginated;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.PackageStatusType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.PackageType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Processes_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.UndeployStatus_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Version_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Versions_type0;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class BPELPackageManagementServiceSkeleton
extends AbstractAdmin
implements BPELPackageManagementServiceSkeletonInterface {
    private static Log log = LogFactory.getLog(BPELPackageManagementServiceSkeleton.class);

    public PackageType listProcessesInPackage(String packageName) throws PackageManagementException {
        TenantProcessStoreImpl tenantProcessStore = this.getTenantProcessStore();
        BPELPackageRepository packageRepo = tenantProcessStore.getBPELPackageRepository();
        try {
            return this.getPackageInfo(packageRepo.getBPELPackageInfoForPackage(packageName));
        }
        catch (Exception e) {
            String errMsg = "BPEL package: " + packageName + " failed to load from registry.";
            log.error((Object)errMsg, (Throwable)e);
            throw new PackageManagementException(errMsg, (Throwable)e);
        }
    }

    public UndeployStatus_type0 undeployBPELPackage(String packageName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting undeployment of BPEL package " + packageName));
        }
        TenantProcessStoreImpl tenantProcessStore = this.getTenantProcessStore();
        try {
            tenantProcessStore.undeploy(packageName);
        }
        catch (Exception e) {
            log.error((Object)("Undeploying BPEL package " + packageName + " failed."), (Throwable)e);
            return UndeployStatus_type0.FAILED;
        }
        return UndeployStatus_type0.SUCCESS;
    }

    public DeployedPackagesPaginated listDeployedPackagesPaginated(int page) throws PackageManagementException {
        List<BPELPackageInfo> packages;
        int tPage = page;
        DeployedPackagesPaginated paginatedPackages = new DeployedPackagesPaginated();
        TenantProcessStoreImpl tenantProcessStore = this.getTenantProcessStore();
        BPELPackageRepository packageRepo = tenantProcessStore.getBPELPackageRepository();
        try {
            packages = packageRepo.getBPELPackages();
        }
        catch (Exception e) {
            String errorMessage = "Cannot get the BPEL Package list from repository.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new PackageManagementException(errorMessage, (Throwable)e);
        }
        if (packages != null) {
            if (tPage < 0 || tPage == Integer.MAX_VALUE) {
                tPage = 0;
            }
            int startIndex = tPage * BPELConstants.ITEMS_PER_PAGE;
            int endIndex = (tPage + 1) * BPELConstants.ITEMS_PER_PAGE;
            int numberOfPackages = packages.size();
            int totalPackages = 0;
            BPELPackageInfo[] packagesArray = packages.toArray(new BPELPackageInfo[numberOfPackages]);
            for (int i = 0; i < numberOfPackages; ++i) {
                int count = this.getPackageVersionCount(packagesArray[i]);
                if (totalPackages + count > startIndex && totalPackages < endIndex) {
                    int maxRemainingPackages = totalPackages < startIndex && totalPackages + count > startIndex ? startIndex - (totalPackages + count) : endIndex - totalPackages;
                    PackageType packageType = this.getPackageInfo(packagesArray[i], maxRemainingPackages);
                    paginatedPackages.add_package(packageType);
                }
                totalPackages += count;
            }
            int pages = (int)Math.ceil((double)totalPackages / (double)BPELConstants.ITEMS_PER_PAGE.intValue());
            paginatedPackages.setPages(pages);
        } else {
            paginatedPackages.setPages(0);
        }
        return paginatedPackages;
    }

    private PackageType getPackageInfo(BPELPackageInfo packageInfo, int maxRemainingPackages) throws PackageManagementException {
        PackageType bpelPackage = new PackageType();
        bpelPackage.setName(packageInfo.getName());
        bpelPackage.setState(this.convertToPackageStatusType(packageInfo.getStatus()));
        bpelPackage.setVersions(this.getAllVersionsOfPackage(packageInfo, maxRemainingPackages));
        bpelPackage.setErrorLog(packageInfo.getCauseForDeploymentFailure());
        return bpelPackage;
    }

    private Versions_type0 getAllVersionsOfPackage(BPELPackageInfo packageInfo, int maxRemainingPackages) throws PackageManagementException {
        Versions_type0 versionsList = new Versions_type0();
        List<String> versions = packageInfo.getAvailableVersions();
        Collections.reverse(versions);
        int count = 0;
        int startIndex = maxRemainingPackages < 0 ? versions.size() + maxRemainingPackages : 0;
        int endIndex = versions.size() - 1;
        for (int i = startIndex; i <= endIndex && Math.abs(maxRemainingPackages) > count; ++count, ++i) {
            String version = versions.get(i);
            Version_type0 packageVersion = new Version_type0();
            packageVersion.setName(version);
            packageVersion.setProcesses(this.getProcessesForPackage(version));
            if (version.equals(packageInfo.getName() + "-" + packageInfo.getLatestVersion())) {
                packageVersion.setIsLatest(true);
            } else {
                packageVersion.setIsLatest(false);
            }
            versionsList.addVersion(packageVersion);
        }
        return versionsList;
    }

    private int getPackageVersionCount(BPELPackageInfo bpelPackageInfo) {
        return bpelPackageInfo.getAvailableVersions().size();
    }

    private PackageType getPackageInfo(BPELPackageInfo packageInfo) throws PackageManagementException {
        return this.getPackageInfo(packageInfo, packageInfo.getAvailableVersions().size());
    }

    private Processes_type0 getProcessesForPackage(String version) throws PackageManagementException {
        Processes_type0 processes = new Processes_type0();
        try {
            List<QName> processIds = this.getTenantProcessStore().getProcessesInPackage(version);
            for (QName pid : processIds) {
                processes.addProcess(AdminServiceUtils.createLimitedProcessInfoObject(AdminServiceUtils.getTenantProcessStore().getProcessConfiguration(pid)));
            }
        }
        catch (Exception e) {
            String errMsg = "Error occurred while listing processes in BPEL package: " + version;
            log.error((Object)errMsg, (Throwable)e);
            throw new PackageManagementException(errMsg, (Throwable)e);
        }
        return processes;
    }

    private PackageStatusType convertToPackageStatusType(BPELPackageInfo.Status status) {
        if (status.equals((Object)BPELPackageInfo.Status.DEPLOYED)) {
            return PackageStatusType.DEPLOYED;
        }
        if (status.equals((Object)BPELPackageInfo.Status.UNDEPLOYED)) {
            return PackageStatusType.UNDEPLOYED;
        }
        if (status.equals((Object)BPELPackageInfo.Status.FAILED)) {
            return PackageStatusType.FAILED;
        }
        if (status.equals((Object)BPELPackageInfo.Status.UPDATED)) {
            return PackageStatusType.UPDATED;
        }
        return PackageStatusType.UNDEFINED;
    }

    private TenantProcessStoreImpl getTenantProcessStore() {
        ConfigurationContext configContext = this.getConfigContext();
        Integer tenantId = MultitenantUtils.getTenantId((ConfigurationContext)configContext);
        BPELServerImpl bpelServer = BPELServerImpl.getInstance();
        return (TenantProcessStoreImpl)bpelServer.getMultiTenantProcessStore().getTenantsProcessStore(tenantId);
    }
}

