/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.config.bam;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.core.ode.integration.config.bam.BAMKey;
import org.wso2.carbon.bpel.core.ode.integration.config.bam.BAMServerProfile;
import org.wso2.carbon.bpel.core.ode.integration.config.bam.BAMStreamConfiguration;
import org.wso2.carbon.bpel.core.ode.integration.store.BPELDeploymentException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;

public class BAMServerProfileBuilder {
    private String profileLocation;
    private static Log log = LogFactory.getLog(BAMServerProfileBuilder.class);

    public BAMServerProfileBuilder(String profileLocation) {
        this.profileLocation = profileLocation;
    }

    public BAMServerProfile build() {
        BAMServerProfile bamServerProfile = new BAMServerProfile();
        if (this.profileLocation.startsWith("conf:")) {
            Registry registry = CarbonContext.getCurrentContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
            String location = this.profileLocation.substring(this.profileLocation.indexOf("conf:") + "conf:".length());
            this.loadBAMProfileFromRegistry(bamServerProfile, registry, location);
        } else if (this.profileLocation.startsWith("gov:")) {
            Registry registry = CarbonContext.getCurrentContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
            String location = this.profileLocation.substring(this.profileLocation.indexOf("gov:") + "gov:".length());
            this.loadBAMProfileFromRegistry(bamServerProfile, registry, location);
        } else if (this.profileLocation.startsWith("reg:")) {
            Registry registry = CarbonContext.getCurrentContext().getRegistry(RegistryType.LOCAL_REPOSITORY);
            String location = this.profileLocation.substring(this.profileLocation.indexOf("reg:") + "reg:".length());
            this.loadBAMProfileFromRegistry(bamServerProfile, registry, location);
        } else if (!this.profileLocation.startsWith("file:")) {
            String errMsg = "Invalid bam profile location: " + this.profileLocation;
            this.handleError(errMsg);
        }
        return bamServerProfile;
    }

    private void loadBAMProfileFromRegistry(BAMServerProfile bamServerProfile, Registry registry, String location) {
        try {
            if (registry.resourceExists(location)) {
                Resource resource = registry.get(location);
                String resourceContent = new String((byte[])resource.getContent());
                OMElement resourceElement = new StAXOMBuilder((InputStream)new ByteArrayInputStream(resourceContent.getBytes())).getDocumentElement();
                this.processBAMServerProfileName(resourceElement, bamServerProfile);
                this.processCredentialElement(resourceElement, bamServerProfile);
                this.processConnectionElement(resourceElement, bamServerProfile);
                this.processKeyStoreElement(resourceElement, bamServerProfile);
                this.processStreamsElement(resourceElement, bamServerProfile);
            } else {
                String errMsg = "The resource: " + location + " does not exist.";
                this.handleError(errMsg);
            }
        }
        catch (RegistryException e) {
            String errMsg = "Error occurred while reading the resource from registry: " + location + " to build the BAM server profile: " + this.profileLocation;
            this.handleError(errMsg, (Exception)((Object)e));
        }
        catch (XMLStreamException e) {
            String errMsg = "Error occurred while creating the OMElement out of BAM server profile: " + this.profileLocation;
            this.handleError(errMsg, e);
        }
    }

    private void processBAMServerProfileName(OMElement bamServerConfig, BAMServerProfile bamServerProfile) {
        OMAttribute name = bamServerConfig.getAttribute(new QName("name"));
        if (name != null) {
            bamServerProfile.setName(name.getAttributeValue());
        } else {
            String errMsg = "Name attribute not found for BAM server profile: " + this.profileLocation;
            this.handleError(errMsg);
        }
    }

    private void processCredentialElement(OMElement bamServerConfig, BAMServerProfile bamServerProfile) {
        OMElement credentialElement = bamServerConfig.getFirstChildWithName(new QName("http://wso2.org/bam/2.0", "Credential"));
        if (credentialElement != null) {
            OMAttribute userNameAttr = credentialElement.getAttribute(new QName("userName"));
            OMAttribute passwordAttr = credentialElement.getAttribute(new QName("password"));
            if (userNameAttr != null && passwordAttr != null && !userNameAttr.getAttributeValue().equals("") && !passwordAttr.getAttributeValue().equals("")) {
                bamServerProfile.setUserName(userNameAttr.getAttributeValue());
                bamServerProfile.setPassword(passwordAttr.getAttributeValue());
            } else {
                String errMsg = "Username or Password not found for BAM server profile: " + this.profileLocation;
                this.handleError(errMsg);
            }
        } else {
            String errMsg = "Credentials not found for BAM server profile: " + this.profileLocation;
            this.handleError(errMsg);
        }
    }

    private void processConnectionElement(OMElement bamServerConfig, BAMServerProfile bamServerProfile) {
        OMElement connectionElement = bamServerConfig.getFirstChildWithName(new QName("http://wso2.org/bam/2.0", "Connection"));
        if (connectionElement != null) {
            OMAttribute secureAttr = connectionElement.getAttribute(new QName("secure"));
            OMAttribute ipAttr = connectionElement.getAttribute(new QName("ip"));
            OMAttribute authenticationPortAttr = connectionElement.getAttribute(new QName("authPort"));
            OMAttribute receiverPortAttr = connectionElement.getAttribute(new QName("receiverPort"));
            if (!(ipAttr == null || secureAttr == null || authenticationPortAttr == null || receiverPortAttr == null || ipAttr.getAttributeValue().equals("") || secureAttr.getAttributeValue().equals("") || authenticationPortAttr.getAttributeValue().equals("") || receiverPortAttr.getAttributeValue().equals(""))) {
                bamServerProfile.setIp(ipAttr.getAttributeValue());
                if ("true".equals(secureAttr.getAttributeValue())) {
                    bamServerProfile.setSecurityEnabled(true);
                } else if ("false".equals(secureAttr.getAttributeValue())) {
                    bamServerProfile.setSecurityEnabled(false);
                } else {
                    String errMsg = "Invalid value found for secure element in BAM server profile: " + this.profileLocation;
                    this.handleError(errMsg);
                }
                bamServerProfile.setAuthenticationPort(authenticationPortAttr.getAttributeValue());
                bamServerProfile.setReceiverPort(receiverPortAttr.getAttributeValue());
            } else {
                String errMsg = "Connection details are missing for BAM server profile: " + this.profileLocation;
                this.handleError(errMsg);
            }
        } else {
            String errMsg = "Connection details not found for BAM server profile: " + this.profileLocation;
            this.handleError(errMsg);
        }
    }

    private void processKeyStoreElement(OMElement bamServerConfig, BAMServerProfile bamServerProfile) {
        OMElement keyStoreElement = bamServerConfig.getFirstChildWithName(new QName("http://wso2.org/bam/2.0", "KeyStore"));
        if (keyStoreElement != null) {
            OMAttribute locationAttr = keyStoreElement.getAttribute(new QName("location"));
            OMAttribute passwordAttr = keyStoreElement.getAttribute(new QName("password"));
            if (locationAttr != null && passwordAttr != null && !locationAttr.getAttributeValue().equals("") && !passwordAttr.getAttributeValue().equals("")) {
                bamServerProfile.setKeyStoreLocation(locationAttr.getAttributeValue());
                bamServerProfile.setKeyStorePassword(passwordAttr.getAttributeValue());
            } else {
                String errMsg = "Key store details location or password not found for BAM server profile: " + this.profileLocation;
                this.handleError(errMsg);
            }
        } else {
            String errMsg = "Key store element not found for BAM server profile: " + this.profileLocation;
            this.handleError(errMsg);
        }
    }

    private void processStreamsElement(OMElement bamServerConfigElement, BAMServerProfile bamServerProfile) {
        OMElement streamsElement = bamServerConfigElement.getFirstChildWithName(new QName("http://wso2.org/bam/2.0", "Streams"));
        if (streamsElement == null) {
            log.warn((Object)("No Streams found for BAM server profile: " + this.profileLocation));
        } else {
            Iterator itr = streamsElement.getChildrenWithName(new QName("http://wso2.org/bam/2.0", "Stream"));
            while (itr.hasNext()) {
                OMElement streamElement = (OMElement)itr.next();
                this.processStreamElement(streamElement, bamServerProfile);
            }
        }
    }

    private void processStreamElement(OMElement streamElement, BAMServerProfile bamServerProfile) {
        OMAttribute nameAttr = streamElement.getAttribute(new QName("name"));
        OMAttribute versionAttr = streamElement.getAttribute(new QName("version"));
        OMAttribute nickNameAttr = streamElement.getAttribute(new QName("nickName"));
        OMAttribute descriptionAttr = streamElement.getAttribute(new QName("description"));
        if (!(nameAttr == null || nickNameAttr == null || descriptionAttr == null || nameAttr.getAttributeValue().equals("") || nickNameAttr.getAttributeValue().equals("") || descriptionAttr.getAttributeValue().equals(""))) {
            BAMStreamConfiguration streamConfiguration = new BAMStreamConfiguration(nameAttr.getAttributeValue(), nickNameAttr.getAttributeValue(), descriptionAttr.getAttributeValue(), versionAttr.getAttributeValue());
            OMElement dataElement = streamElement.getFirstChildWithName(new QName("http://wso2.org/bam/2.0", "Data"));
            if (dataElement == null) {
                String errMsg = "Data element is not available for BAM server profile: " + this.profileLocation;
                this.handleError(errMsg);
            }
            Iterator itr = dataElement.getChildrenWithName(new QName("http://wso2.org/bam/2.0", "Key"));
            while (itr.hasNext()) {
                OMElement keyElement = (OMElement)itr.next();
                this.processKeyElement(keyElement, streamConfiguration);
            }
            bamServerProfile.addBAMStreamConfiguration(streamConfiguration.getName(), streamConfiguration);
        } else {
            String errMsg = "One or many of the attributes of Stream element is not available for BAM server profile: " + this.profileLocation;
            this.handleError(errMsg);
        }
    }

    private void processKeyElement(OMElement keyElement, BAMStreamConfiguration streamConfiguration) {
        String errMsg;
        BAMKey bamKey;
        OMAttribute variableAttribute;
        BAMKey.BAMKeyType type;
        String part = null;
        String query = null;
        OMAttribute nameAttribute = keyElement.getAttribute(new QName("name"));
        if (nameAttribute == null || "".equals(nameAttribute.getAttributeValue())) {
            String errMsg2 = "name attribute of Key element cannot be null for BAM server profile: " + this.profileLocation;
            this.handleError(errMsg2);
        }
        String name = nameAttribute.getAttributeValue();
        OMAttribute typeAttribute = keyElement.getAttribute(new QName("type"));
        if (typeAttribute == null || "".equals(typeAttribute.getAttributeValue())) {
            type = BAMKey.BAMKeyType.PAYLOAD;
            log.debug((Object)("type attribute of Key element: " + name + " is not available. " + "Type is default to payload"));
        }
        type = BAMKey.BAMKeyType.valueOf(typeAttribute.getAttributeType());
        OMElement fromElement = keyElement.getFirstChildWithName(new QName("http://wso2.org/bam/2.0", "From"));
        if (fromElement == null) {
            String errMsg3 = "From element not found for Key element: " + name + " for BAM server " + "profile: " + this.profileLocation;
            this.handleError(errMsg3);
        }
        if ((variableAttribute = fromElement.getAttribute(new QName("variable"))) != null && !"".equals(variableAttribute.getAttributeValue())) {
            OMElement queryElement;
            String variable = variableAttribute.getAttributeValue();
            OMAttribute partAttribute = fromElement.getAttribute(new QName("part"));
            if (partAttribute != null) {
                part = partAttribute.getAttributeValue();
            }
            if ((queryElement = fromElement.getFirstChildWithName(new QName("http://wso2.org/bam/2.0", "Query"))) == null || "".equals(queryElement.getText())) {
                query = queryElement.getText();
            }
            bamKey = new BAMKey(name, variable, part, query, type);
        } else {
            if (fromElement.getText() == null || "".equals(fromElement.getText())) {
                errMsg = "Variable name or XPath expression not found for From of Key: " + name + " for BAM server profile: " + this.profileLocation;
                this.handleError(errMsg);
            }
            String expression = fromElement.getText().trim();
            bamKey = new BAMKey(name, type);
            bamKey.setExpression(expression);
        }
        switch (bamKey.getType()) {
            case PAYLOAD: {
                streamConfiguration.addPayloadBAMKey(bamKey);
                break;
            }
            case CORRELATION: {
                streamConfiguration.addCorrelationBAMKey(bamKey);
                break;
            }
            case META: {
                streamConfiguration.addMetaBAMKey(bamKey);
                break;
            }
            default: {
                errMsg = "Unknown BAM key type: " + (Object)((Object)type) + " with BAM key name: " + bamKey.getName() + " in stream: " + streamConfiguration.getName();
                this.handleError(errMsg);
            }
        }
    }

    private void handleError(String errMsg) {
        log.error((Object)errMsg);
        throw new BPELDeploymentException(errMsg);
    }

    private void handleError(String errMsg, Exception e) {
        log.error((Object)errMsg, (Throwable)e);
        throw new BPELDeploymentException(errMsg, e);
    }
}

