/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.config;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.core.ode.integration.config.EndpointConfiguration;
import org.wso2.carbon.bpel.core.ode.integration.utils.Messages;

public final class EndpointConfigBuilder {
    private static Log log = LogFactory.getLog(EndpointConfigBuilder.class);

    private EndpointConfigBuilder() {
    }

    public static EndpointConfiguration buildEndpointConfiguration(OMElement ele, String basePath) {
        String mexTimeout;
        EndpointConfiguration endPointConfig = new EndpointConfiguration();
        endPointConfig.setBasePath(basePath);
        String endpointRef = ele.getAttributeValue(new QName(null, "endpointReference"));
        endPointConfig.setUnifiedEndPointReference(endpointRef);
        log.info((Object)("Endpoint reference file:" + endpointRef));
        if (ele.getFirstChildWithName(new QName("http://www.w3.org/2005/08/addressing", "EndpointReference")) != null) {
            log.info((Object)"Found in-line unified endpoint. This will take precedence over the reference");
            endPointConfig.setUepOM(ele.getFirstChildWithName(new QName("http://www.w3.org/2005/08/addressing", "EndpointReference")));
        }
        if ((mexTimeout = EndpointConfigBuilder.getElementAttributeValue("mex-timeout", "value", ele)) != null) {
            endPointConfig.setMexTimeout(mexTimeout);
        }
        return endPointConfig;
    }

    private static String getElementAttributeValue(String elementName, String attributeName, OMElement parentEle) {
        OMElement ele = parentEle.getFirstChildWithName(new QName("http://wso2.org/bps/bpel/endpoint/config", elementName));
        if (ele != null) {
            Iterator attributes = ele.getAllAttributes();
            while (attributes.hasNext()) {
                OMAttribute attribute = (OMAttribute)attributes.next();
                if (!attribute.getLocalName().equals(attributeName)) continue;
                return attribute.getAttributeValue();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.msgElementAttributeValueNotFound(elementName, attributeName));
        }
        return null;
    }
}

