/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.axis2.receivers;

import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.receivers.AbstractInMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.skeleton.AttachmentMgtException;
import org.wso2.carbon.attachment.mgt.skeleton.types.TAttachment;
import org.wso2.carbon.bpel.core.internal.BPELServerHolder;
import org.wso2.carbon.bpel.core.ode.integration.BPELMessageContext;
import org.wso2.carbon.bpel.core.ode.integration.BPELProcessProxy;
import org.wso2.carbon.bpel.core.ode.integration.utils.BPELMessageContextFactory;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class BPELMessageReceiver
extends AbstractInMessageReceiver {
    private static Log log = LogFactory.getLog(BPELMessageReceiver.class);
    private static Log messageTraceLog = LogFactory.getLog((String)"org.wso2.carbon.bpel.messagetrace");
    private BPELProcessProxy processProxy;

    private List<String> persistAttachments(Attachments attachmentsMap) {
        ArrayList<String> attachmentIdList = new ArrayList<String>();
        for (String id : attachmentsMap.getAllContentIDs()) {
            DataHandler attachmentContent = attachmentsMap.getDataHandler(id);
            try {
                String attachmentID = BPELServerHolder.getInstance().getAttachmentService().getAttachmentService().add(this.createAttachmentDTO(attachmentContent));
                attachmentIdList.add(attachmentID);
                log.info((Object)("Attachment added. ID : " + attachmentID));
            }
            catch (AttachmentMgtException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return attachmentIdList;
    }

    private TAttachment createAttachmentDTO(DataHandler attachmentHandler) {
        TAttachment attachment = new TAttachment();
        String attachmentName = attachmentHandler.getName();
        attachment.setName(attachmentName);
        log.warn((Object)("Couldn't determine the name of BPEL client. So the owner of the attachment:" + attachmentName + " " + "will be the default bpel client" + "AnonymousBPELClient"));
        attachment.setCreatedBy("AnonymousBPELClient");
        attachment.setContentType(attachmentHandler.getContentType());
        attachment.setContent(attachmentHandler);
        return attachment;
    }

    protected final void invokeBusinessLogic(MessageContext inMessageContext) throws AxisFault {
        CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId());
        if (messageTraceLog.isDebugEnabled()) {
            messageTraceLog.debug((Object)("Message received: " + inMessageContext.getAxisService().getName() + "." + inMessageContext.getAxisOperation().getName()));
            if (messageTraceLog.isTraceEnabled()) {
                messageTraceLog.trace((Object)("Request message: " + inMessageContext.getEnvelope()));
            }
        }
        SOAPFactory soapFactory = this.getSOAPFactory(inMessageContext);
        BPELMessageContext bpelMessageContext = BPELMessageContextFactory.createBPELMessageContext(inMessageContext, this.processProxy, soapFactory);
        List<String> attachmentIDs = this.persistAttachments(inMessageContext.getAttachmentMap());
        if (attachmentIDs != null && !attachmentIDs.isEmpty()) {
            bpelMessageContext.setAttachmentIDList(attachmentIDs);
        }
        if (BPELMessageContextFactory.hasResponse(inMessageContext.getAxisOperation())) {
            this.handleInOutOperation(bpelMessageContext);
            if (messageTraceLog.isDebugEnabled()) {
                messageTraceLog.debug((Object)("Reply Sent: " + inMessageContext.getAxisService().getName() + "." + inMessageContext.getAxisOperation().getName()));
                if (messageTraceLog.isTraceEnabled()) {
                    messageTraceLog.trace((Object)("Response message: " + bpelMessageContext.getOutMessageContext().getEnvelope()));
                }
            }
        } else {
            this.handleInOnlyOperation(bpelMessageContext);
        }
    }

    public final void setProcessProxy(BPELProcessProxy processProxy) {
        this.processProxy = processProxy;
    }

    private void handleInOutOperation(BPELMessageContext bpelMessageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received request message for " + bpelMessageContext.getInMessageContext().getAxisService().getName() + "." + bpelMessageContext.getInMessageContext().getAxisOperation().getName()));
        }
        this.processProxy.onAxisServiceInvoke(bpelMessageContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reply for " + bpelMessageContext.getInMessageContext().getAxisService().getName() + "." + bpelMessageContext.getInMessageContext().getAxisOperation().getName()));
            log.debug((Object)("\tReply message " + bpelMessageContext.getOutMessageContext().getEnvelope()));
        }
        AxisEngine.send((MessageContext)bpelMessageContext.getOutMessageContext());
    }

    private void handleInOnlyOperation(BPELMessageContext bpelMessageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received one-way message for " + bpelMessageContext.getInMessageContext().getAxisService().getName() + "." + bpelMessageContext.getInMessageContext().getAxisOperation().getName()));
        }
        this.processProxy.onAxisServiceInvoke(bpelMessageContext);
    }
}

