/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration;

import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.il.OMUtils;
import org.w3c.dom.Element;
import org.wso2.carbon.bpel.core.ode.integration.BPELMessageContext;
import org.wso2.carbon.bpel.core.ode.integration.axis2.WSDLAwareSOAPProcessor;
import org.wso2.carbon.bpel.core.ode.integration.utils.AxisServiceUtils;
import org.wso2.carbon.bpel.core.ode.integration.utils.Messages;

public class HTTPBindingHandler {
    private ConfigurationContext configurationContext;
    private QName serviceName;
    private String portName;
    private Binding httpBinding;
    private Definition wsdl;

    public HTTPBindingHandler(ConfigurationContext configurationContext, QName serviceName, String portName, Definition wsdl) throws AxisFault {
        this.configurationContext = configurationContext;
        this.serviceName = serviceName;
        this.portName = portName;
        this.wsdl = wsdl;
        this.inferBinding();
    }

    public HTTPBindingResponse invoke(PartnerRoleMessageExchange partnerRoleMessageExchange, BPELMessageContext bpelMessageContext) throws AxisFault {
        OperationClient operationClient = AxisServiceUtils.getOperationClient(bpelMessageContext, this.configurationContext);
        operationClient.getOptions().setAction("\"\"");
        operationClient.getOptions().setExceptionToBeThrownOnSOAPFault(true);
        this.addPropertyToOperationClient(operationClient, "whttp:queryParameterSeparator", "&");
        this.addPropertyToOperationClient(operationClient, "enableREST", true);
        this.addPropertyToOperationClient(operationClient, "HTTP_METHOD", this.getVerb().trim());
        this.addPropertyToOperationClient(operationClient, "whttp:location", this.getHTTPLocation(partnerRoleMessageExchange.getOperationName()));
        this.addPropertyToOperationClient(operationClient, "ContentType", this.inferContentType(this.getVerb()));
        this.addPropertyToOperationClient(operationClient, "messageType", this.inferContentType(this.getVerb()));
        SOAPEnvelope soapEnvelope = HTTPBindingHandler.getFactory(operationClient.getOptions().getSoapVersionURI()).getDefaultEnvelope();
        MessageContext messageContext = new MessageContext();
        this.populateSOAPBody(soapEnvelope, partnerRoleMessageExchange);
        messageContext.setEnvelope(soapEnvelope);
        operationClient.addMessageContext(messageContext);
        String mexEndpointUrl = ((MutableEndpoint)partnerRoleMessageExchange.getEndpointReference()).getUrl();
        if (!mexEndpointUrl.equals(this.getServiceLocation())) {
            operationClient.getOptions().setTo(new EndpointReference(mexEndpointUrl));
        }
        operationClient.getOptions().setTo((EndpointReference)bpelMessageContext.getUep());
        operationClient.execute(true);
        MessageContext responseMessageContext = operationClient.getMessageContext("In");
        MessageContext faultMessageContext = operationClient.getMessageContext("Fault");
        return new HTTPBindingResponse(responseMessageContext, faultMessageContext);
    }

    private void populateSOAPBody(SOAPEnvelope soapEnvelope, PartnerRoleMessageExchange partnerRoleMessageExchange) {
        Message messageToSend = partnerRoleMessageExchange.getRequest();
        if (messageToSend.getParts().size() != 1) {
            throw new IllegalArgumentException("HTTP Binding doesn't support multiple message part as the input.");
        }
        soapEnvelope.getBody().addChild((OMNode)OMUtils.toOM((Element)this.getPartContent(messageToSend.getPart((String)messageToSend.getParts().get(0))), (OMFactory)soapEnvelope.getOMFactory()));
    }

    private Element getPartContent(Element part) {
        if (part.getFirstChild().getNodeType() == 1) {
            return (Element)part.getFirstChild();
        }
        throw new IllegalArgumentException("Cannot find message content in part element of ODE request to the external service.");
    }

    private static SOAPFactory getFactory(String soapVersionURI) {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        throw new RuntimeException(org.apache.axis2.i18n.Messages.getMessage((String)"unknownsoapversion"));
    }

    private String getVerb() {
        ExtensibilityElement extElement = WSDLAwareSOAPProcessor.getBindingExtension(this.httpBinding);
        if (extElement instanceof HTTPBinding) {
            return ((HTTPBinding)extElement).getVerb();
        }
        throw new IllegalArgumentException("Current binding is not a HTTP Binding.");
    }

    private String inferContentType(String httpVerb) {
        if (httpVerb.trim().equals("GET") || httpVerb.trim().equals("DELETE")) {
            return "application/x-www-form-urlencoded";
        }
        return "application/xml";
    }

    private String getHTTPLocation(String operationName) {
        for (Object bindingOperation : this.httpBinding.getBindingOperations()) {
            if (!((BindingOperation)bindingOperation).getName().equals(operationName)) continue;
            List extElements = ((BindingOperation)bindingOperation).getExtensibilityElements();
            if (extElements.size() == 0) {
                throw new RuntimeException();
            }
            if (extElements.size() > 1) {
                throw new RuntimeException();
            }
            return ((HTTPOperation)extElements.get(0)).getLocationURI();
        }
        throw new NullPointerException("HTTP Operation's location attribute is null.");
    }

    private void addPropertyToOperationClient(OperationClient operationClient, String propertyKey, Object propertyValue) {
        operationClient.getOptions().setProperty(propertyKey, propertyValue);
    }

    protected void addPropertyToOperationClient(OperationClient operationClient, String propertyKey, boolean value) {
        this.addPropertyToOperationClient(operationClient, propertyKey, (Object)value);
    }

    private String getServiceLocation() {
        for (Object extElement : this.getPortDefinition().getExtensibilityElements()) {
            if (!(extElement instanceof HTTPAddress)) continue;
            return ((HTTPAddress)extElement).getLocationURI();
        }
        throw new NullPointerException("Service Location is null. Cannot find HTTP Address from WSDL definition");
    }

    private Port getPortDefinition() {
        Service serviceDef = this.wsdl.getService(this.serviceName);
        if (serviceDef == null) {
            throw new NullPointerException(Messages.msgServiceDefinitionNotFound(this.serviceName.getLocalPart()));
        }
        return serviceDef.getPort(this.portName);
    }

    private void inferBinding() {
        Service serviceDef = this.wsdl.getService(this.serviceName);
        if (serviceDef == null) {
            throw new NullPointerException(Messages.msgServiceDefinitionNotFound(this.serviceName.getLocalPart()));
        }
        Port port = serviceDef.getPort(this.portName);
        if (port == null) {
            throw new NullPointerException(Messages.msgServicePortNotFound(this.serviceName.getLocalPart(), this.portName));
        }
        this.httpBinding = port.getBinding();
        if (this.httpBinding == null) {
            throw new NullPointerException(Messages.msgBindingNotFound(this.serviceName.getLocalPart(), this.portName));
        }
    }

    public static class HTTPBindingResponse {
        private MessageContext responseMessageContext;
        private MessageContext faultMessageContext;

        public HTTPBindingResponse(MessageContext responseMessageContext, MessageContext faultMessageContext) {
            this.responseMessageContext = responseMessageContext;
            this.faultMessageContext = faultMessageContext;
        }

        public boolean isFault() {
            return this.faultMessageContext != null;
        }

        public MessageContext getReponseMessageContext() {
            return this.responseMessageContext;
        }

        public MessageContext getFaultMessageContext() {
            return this.faultMessageContext;
        }
    }
}

