/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration;

import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.agents.memory.SizingAgent;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.wso2.carbon.bpel.core.ode.integration.BPELProcessProxy;
import org.wso2.carbon.bpel.core.ode.integration.BPELServerImpl;
import org.wso2.carbon.bpel.core.ode.integration.PartnerService;
import org.wso2.carbon.bpel.core.ode.integration.store.MultiTenantProcessConfiguration;
import org.wso2.carbon.bpel.core.ode.integration.store.ProcessConfigurationImpl;
import org.wso2.carbon.bpel.core.ode.integration.store.TenantProcessStore;
import org.wso2.carbon.bpel.core.ode.integration.utils.AxisServiceUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class BPELBindingContextImpl
implements BindingContext {
    private static final Log log = LogFactory.getLog(BPELBindingContextImpl.class);
    private BPELServerImpl bpelServer;
    private MultiKeyMap services = new MultiKeyMap();
    private Map<BPELProcessProxy, EndpointReference> serviceEprMap = new HashMap<BPELProcessProxy, EndpointReference>();

    public BPELBindingContextImpl(BPELServerImpl bpelServer) {
        this.bpelServer = bpelServer;
    }

    public EndpointReference activateMyRoleEndpoint(QName processId, Endpoint myRoleEndpoint) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Activating MyRole endpoint for process: " + processId + " endpoint: " + myRoleEndpoint));
            }
            ProcessConf processConfiguration = ((ProcessStore)this.bpelServer.getMultiTenantProcessStore()).getProcessConfiguration(processId);
            BPELProcessProxy processProxy = this.publishAxisService(processConfiguration, myRoleEndpoint.serviceName, myRoleEndpoint.portName);
            this.serviceEprMap.put(processProxy, (EndpointReference)processProxy.getServiceReference());
            this.updateServiceList(this.getTenantId(processId), myRoleEndpoint, STATE.ADD);
            return processProxy.getServiceReference();
        }
        catch (AxisFault af) {
            String errMsg = "Could not activate endpoint for service " + myRoleEndpoint.serviceName + " and port " + myRoleEndpoint.portName;
            log.error((Object)errMsg, (Throwable)af);
            throw new ContextException(errMsg, (Throwable)af);
        }
    }

    public void deactivateMyRoleEndpoint(QName processID, Endpoint endpoint) {
        Integer tenantId;
        BPELProcessProxy processProxy;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deactivating my role endpoint for process: " + processID + " service: " + endpoint.serviceName + " and port: " + endpoint.portName));
        }
        if ((processProxy = this.getBPELProcessProxy((tenantId = this.bpelServer.getMultiTenantProcessStore().getTenantId(processID)).toString(), endpoint.serviceName, endpoint.portName)) != null) {
            ProcessConfigurationImpl processConf = (ProcessConfigurationImpl)processProxy.getProcessConfiguration();
            if (processConf.isUndeploying()) {
                AxisService service = processProxy.getAxisService();
                Parameter param = service.getParameter("preserveServiceHistory");
                param.setValue((Object)"false");
            }
            this.removeBPELProcessProxyAndAxisService(tenantId.toString(), endpoint.serviceName, endpoint.portName);
            this.updateServiceList(((ProcessConfigurationImpl)processProxy.getProcessConfiguration()).getTenantId(), endpoint, STATE.REMOVE);
            this.serviceEprMap.remove(processProxy);
        }
    }

    public PartnerRoleChannel createPartnerRoleChannel(QName processId, PortType portType, Endpoint initialPartnerEndpoint) {
        ProcessConf processConfiguration = ((ProcessStore)this.bpelServer.getMultiTenantProcessStore()).getProcessConfiguration(processId);
        Definition wsdl = processConfiguration.getDefinitionForService(initialPartnerEndpoint.serviceName);
        if (wsdl == null) {
            throw new ContextException("Cannot find definition for service " + initialPartnerEndpoint.serviceName + " in the context of process " + processId);
        }
        return this.createPartnerService(processConfiguration, initialPartnerEndpoint.serviceName, initialPartnerEndpoint.portName);
    }

    public long calculateSizeofService(EndpointReference endpointReference) {
        if (this.bpelServer.getOdeConfigurationProperties().isProcessSizeThrottled()) {
            for (Map.Entry<BPELProcessProxy, EndpointReference> entry : this.serviceEprMap.entrySet()) {
                if (!endpointReference.equals(entry.getValue())) continue;
                return SizingAgent.deepSizeOf((Object)entry.getKey());
            }
        }
        return 0L;
    }

    private Integer getTenantId(QName processId) {
        ProcessConf processConfiguration = ((ProcessStore)this.bpelServer.getMultiTenantProcessStore()).getProcessConfiguration(processId);
        return MultitenantUtils.getTenantId((ConfigurationContext)((MultiTenantProcessConfiguration)processConfiguration).getTenantConfigurationContext());
    }

    private PartnerService createPartnerService(ProcessConf pConf, QName serviceName, String portName) throws ContextException {
        PartnerService partnerService;
        Definition def = pConf.getDefinitionForService(serviceName);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating external service " + serviceName));
            }
            partnerService = new PartnerService(def, serviceName, portName, this.getConfigurationContextFromProcessConfiguration(pConf), pConf, this.bpelServer.getHttpConnectionManager());
        }
        catch (Exception ex) {
            log.error((Object)"Could not create external service.", (Throwable)ex);
            throw new ContextException("Error creating external service! name:" + serviceName + ", port:" + portName, (Throwable)ex);
        }
        if (partnerService == null) {
            throw new ContextException("Only SOAP and HTTP binding supported!");
        }
        log.debug((Object)("Created external service " + serviceName));
        return partnerService;
    }

    private BPELProcessProxy publishAxisService(ProcessConf processConfiguration, QName serviceName, String portName) throws AxisFault {
        AxisService axisService;
        BPELProcessProxy processProxy = new BPELProcessProxy(processConfiguration, this.bpelServer, serviceName, portName);
        ConfigurationContext tenantConfigCtx = this.getConfigurationContextFromProcessConfiguration(processConfiguration);
        try {
            axisService = AxisServiceUtils.createAxisService(tenantConfigCtx.getAxisConfiguration(), processProxy);
        }
        catch (AxisFault e) {
            log.error((Object)("Error occurred creating the axis service " + serviceName.toString()));
            throw new DeploymentException("BPEL Package deployment failed.", (Throwable)e);
        }
        processProxy.setAxisService(axisService);
        this.removeBPELProcessProxyAndAxisService(processConfiguration.getDeployer(), serviceName, portName);
        this.services.put((Object)processConfiguration.getDeployer(), (Object)serviceName, (Object)portName, (Object)processProxy);
        tenantConfigCtx.getAxisConfiguration().addServiceGroup(this.createServiceGroupForService(axisService));
        if (log.isDebugEnabled()) {
            log.debug((Object)("BPELProcessProxy created for process " + processConfiguration.getProcessId()));
            log.debug((Object)("AxisService " + serviceName + " created for BPEL process " + processConfiguration.getProcessId()));
        }
        return processProxy;
    }

    private AxisServiceGroup createServiceGroupForService(AxisService svc) throws AxisFault {
        AxisServiceGroup svcGroup = new AxisServiceGroup();
        svcGroup.setServiceGroupName(svc.getName());
        svcGroup.addService(svc);
        if (svc.getParameter("preserveServiceHistory") != null && svc.getParameter("confgiuredUsingBpelPkgFiles") == null) {
            svcGroup.addParameter(new Parameter("preserveServiceHistory", (Object)"true"));
        }
        return svcGroup;
    }

    private BPELProcessProxy getBPELProcessProxy(String processDeployer, QName serviceName, String portName) {
        return (BPELProcessProxy)this.services.get((Object)processDeployer, (Object)serviceName, (Object)portName);
    }

    private void removeBPELProcessProxyAndAxisService(String processDeployer, QName serviceName, String portName) {
        BPELProcessProxy processProxy;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing service " + serviceName.toString() + " port " + portName));
        }
        if ((processProxy = (BPELProcessProxy)this.services.remove((Object)processDeployer, (Object)serviceName, (Object)portName)) != null) {
            try {
                String axisServiceName = processProxy.getAxisService().getName();
                AxisConfiguration axisConfig = processProxy.getAxisService().getAxisConfiguration();
                AxisService axisService = axisConfig.getService(axisServiceName);
                if (axisService != null) {
                    axisService.releaseSchemaList();
                    axisConfig.stopService(axisServiceName);
                    axisConfig.removeServiceGroup(axisServiceName);
                }
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Couldn't remove service " + serviceName));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Couldn't find service " + serviceName + " port " + portName + " to remove."));
        }
    }

    private ConfigurationContext getConfigurationContextFromProcessConfiguration(ProcessConf processConf) {
        if (processConf instanceof ProcessConfigurationImpl) {
            return ((ProcessConfigurationImpl)processConf).getTenantConfigurationContext();
        }
        throw new RuntimeException("ProcessConf implementatoin type mismatch. ProcessConf implentation should be a instance of org.wso2.carbon.bpel.core.ode.integration.store.ProcessConfigurationImpl.");
    }

    private void updateServiceList(int tenantId, Endpoint myRoleEndpoint, STATE state) {
        TenantProcessStore tenantProcessStore = this.bpelServer.getMultiTenantProcessStore().getTenantsProcessStore(tenantId);
        if (tenantProcessStore == null) {
            throw new RuntimeException("TenantProcessStore null for tenant " + tenantId + ".");
        }
        switch (state) {
            case ADD: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding published service information for service: " + myRoleEndpoint.serviceName));
                }
                tenantProcessStore.getDeployedServices().put(myRoleEndpoint.serviceName, new Object());
                break;
            }
            case REMOVE: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing published service information for service: " + myRoleEndpoint.serviceName));
                }
                tenantProcessStore.getDeployedServices().remove(myRoleEndpoint.serviceName);
            }
        }
    }

    private static enum STATE {
        ADD,
        REMOVE;

    }
}

