/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.Literal;
import org.axiondb.Selectable;
import org.axiondb.event.DatabaseSequenceEvent;
import org.axiondb.event.SequenceModificationListener;
import org.axiondb.types.IntegerType;

public class Sequence
extends Literal
implements Selectable {
    private String _name = null;
    private Integer _val = null;
    private List _listeners = null;

    public Sequence(String name) {
        this(name, 0);
    }

    public Sequence(String name, int startVal) {
        super((DataType)new IntegerType());
        this._name = name.toUpperCase();
        this._val = new Integer(startVal);
        this._listeners = new ArrayList();
    }

    public String getName() {
        return this._name;
    }

    public Object getValue() throws AxionException {
        return this._val;
    }

    public Object evaluate() throws AxionException {
        this._val = new Integer(this._val + 1);
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            SequenceModificationListener cur = (SequenceModificationListener)it.next();
            cur.sequenceIncremented(new DatabaseSequenceEvent(this));
        }
        return this._val;
    }

    public void addSequenceModificationListener(SequenceModificationListener listener) {
        this._listeners.add(listener);
    }
}

