/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import java.util.Map;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.DataType;
import org.axiondb.Row;
import org.axiondb.Selectable;

public class RowDecorator {
    private Row _row = null;
    private Map _fieldMap = null;
    private int _rowndx = -1;

    public RowDecorator(Map selectableToFieldMap) {
        this._fieldMap = selectableToFieldMap;
    }

    public void setRow(Row row) {
        this.setRow(-1, row);
    }

    public void setRow(int rowndx, Row row) {
        this._rowndx = rowndx;
        this._row = row;
    }

    public Row getRow() {
        return this._row;
    }

    public Object get(ColumnIdentifier colid) {
        Object obj = this._row.get(this.getFieldIndex(colid));
        DataType type = colid.getDataType();
        if (null != type) {
            return type.convert(obj);
        }
        return obj;
    }

    public int getRowIndex() throws AxionException {
        if (this._rowndx == -1) {
            throw new AxionException("Row index not available.");
        }
        return this._rowndx;
    }

    public int getFieldIndex(Selectable sel) {
        Integer val = (Integer)this._fieldMap.get(sel);
        if (null == val) {
            throw new IllegalArgumentException("Field " + sel + " not found.");
        }
        return val;
    }
}

