/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import org.axiondb.Selectable;
import org.axiondb.TableIdentifier;

public class FromNode {
    public static final int TYPE_SINGLE = 0;
    public static final int TYPE_INNER = 1;
    public static final int TYPE_LEFT = 2;
    public static final int TYPE_RIGHT = 3;
    private Object _left = null;
    private Object _right = null;
    private int _type = 0;
    private Selectable _condition = null;

    public void setLeft(TableIdentifier table) {
        this._left = table;
    }

    public void setLeft(FromNode join) {
        this._left = join;
    }

    public void setRight(TableIdentifier table) {
        this._right = table;
    }

    public void setRight(FromNode join) {
        this._right = join;
    }

    public void setType(int type) {
        this._type = type;
    }

    public void setCondition(Selectable condition) {
        this._condition = condition;
    }

    public Object getLeft() {
        return this._left;
    }

    public boolean hasLeft() {
        return null != this.getLeft();
    }

    public Object getRight() {
        return this._right;
    }

    public boolean hasRight() {
        return null != this.getRight();
    }

    public int getType() {
        return this._type;
    }

    public boolean isLeftOrInnerJoin() {
        return this.getType() == 1 || this.getType() == 2;
    }

    public boolean isRightJoin() {
        return this.getType() == 3;
    }

    public Selectable getCondition() {
        return this._condition;
    }

    public boolean hasCondition() {
        return null != this.getCondition();
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String prefix) {
        FromNode node;
        TableIdentifier table;
        String result = "\n";
        result = result + prefix + "Type : " + this.getType() + "\n";
        if (this._left instanceof TableIdentifier) {
            table = (TableIdentifier)this._left;
            result = result + prefix + "Left : " + " TableIdentifier " + table.getTableName() + "\n";
        }
        if (this._left instanceof FromNode) {
            node = (FromNode)this._left;
            result = result + prefix + "Left : " + " FromNode " + node.toString(prefix + "\t") + "\n";
        }
        if (this._right instanceof TableIdentifier) {
            table = (TableIdentifier)this._right;
            result = result + prefix + "Right: " + " TableIdentifier " + table.getTableName() + "\n";
        }
        if (this._right instanceof FromNode) {
            node = (FromNode)this._right;
            result = result + prefix + "Right: " + " FromNode " + node.toString(prefix + "\t") + "\n";
        }
        return result;
    }

    public int getTableCount() {
        return FromNode.getTableCount(this.getLeft()) + FromNode.getTableCount(this.getRight());
    }

    private static int getTableCount(Object child) {
        if (null == child) {
            return 0;
        }
        if (child instanceof TableIdentifier) {
            return 1;
        }
        return ((FromNode)child).getTableCount();
    }

    public TableIdentifier[] toTableArray() {
        TableIdentifier[] tables = new TableIdentifier[this.getTableCount()];
        this.toTableArray(tables, 0);
        return tables;
    }

    private int toTableArray(TableIdentifier[] tables, int pos) {
        pos = FromNode.toTableArray(tables, pos, this.getLeft());
        pos = FromNode.toTableArray(tables, pos, this.getRight());
        return pos;
    }

    private static int toTableArray(TableIdentifier[] tables, int pos, Object child) {
        if (null == child) {
            return pos;
        }
        if (child instanceof TableIdentifier) {
            tables[pos] = (TableIdentifier)child;
            return pos + 1;
        }
        return ((FromNode)child).toTableArray(tables, pos);
    }
}

