/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import java.io.File;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FromNode;
import org.axiondb.Index;
import org.axiondb.IndexFactory;
import org.axiondb.Selectable;
import org.axiondb.Sequence;
import org.axiondb.Table;
import org.axiondb.TableFactory;
import org.axiondb.TableIdentifier;
import org.axiondb.TransactionManager;
import org.axiondb.event.DatabaseModificationListener;
import org.axiondb.functions.ConcreteFunction;

public interface Database {
    public String getName();

    public Table getTable(String var1) throws AxionException;

    public Table getTable(TableIdentifier var1) throws AxionException;

    public boolean hasTable(String var1) throws AxionException;

    public boolean hasTable(TableIdentifier var1) throws AxionException;

    public void dropTable(String var1) throws AxionException;

    public void addTable(Table var1) throws AxionException;

    public void addIndex(Index var1, Table var2) throws AxionException;

    public void dropIndex(String var1) throws AxionException;

    public boolean hasIndex(String var1) throws AxionException;

    public ConcreteFunction getFunction(String var1);

    public DataType getDataType(String var1);

    public IndexFactory getIndexFactory(String var1);

    public TableFactory getTableFactory(String var1);

    public File getTableDirectory();

    public Selectable resolveSelectable(Selectable var1, TableIdentifier[] var2) throws AxionException;

    public Selectable resolveSelectable(Selectable var1, List var2, TableIdentifier[] var3) throws AxionException;

    public void resolveFromNode(FromNode var1, List var2, TableIdentifier[] var3) throws AxionException;

    public void checkpoint() throws AxionException;

    public void shutdown() throws AxionException;

    public void remount(File var1) throws AxionException;

    public boolean isReadOnly();

    public void createSequence(Sequence var1) throws AxionException;

    public Sequence getSequence(String var1);

    public void dropSequence(String var1) throws AxionException;

    public boolean hasSequence(String var1) throws AxionException;

    public TransactionManager getTransactionManager();

    public void tableAltered(Table var1) throws AxionException;

    public void addDatabaseModificationListener(DatabaseModificationListener var1);

    public List getDatabaseModificationListeners();
}

