/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.NamedIdentifier;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.TableIdentifier;
import org.axiondb.VariableContext;
import org.axiondb.types.AnyType;

public class ColumnIdentifier
extends NamedIdentifier
implements Selectable {
    private TableIdentifier _table = null;
    private String _column = null;
    private String _columnAlias = null;
    private DataType _type = null;
    private static final long serialVersionUID = -5021851410960110853L;

    public ColumnIdentifier(String column) {
        this(null, column);
    }

    public ColumnIdentifier(TableIdentifier table, String columnName) {
        this(table, columnName, null);
    }

    public ColumnIdentifier(TableIdentifier table, String columnName, String columnAlias) {
        this(table, columnName, columnAlias, null);
    }

    public ColumnIdentifier(TableIdentifier table, String columnName, String columnAlias, DataType type) {
        this.setName(columnName);
        if (null == this.getTableIdentifier()) {
            this.setTableIdentifier(table);
        }
        this.setAlias(columnAlias);
        this.setDataType((DataType)(null == type ? new AnyType() : type));
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        if (null == row) {
            throw new AxionException("Expected non-null RowDecorator here.");
        }
        return row.get(this);
    }

    public String getLabel() {
        String result = this.getAlias();
        if (result == null) {
            result = this.getName();
        }
        return result;
    }

    private void setName(String column) {
        int pivot;
        this._column = this.toUpperOrNull(column);
        if (this._column != null && (pivot = this._column.indexOf(".")) != -1) {
            this.setTableIdentifier(new TableIdentifier(this._column.substring(0, pivot)));
            this._column = this._column.substring(pivot + 1);
        }
    }

    public String getName() {
        return this._column;
    }

    public void setAlias(String column) {
        this._columnAlias = this.toUpperOrNull(column);
    }

    public String getAlias() {
        return this._columnAlias;
    }

    public void setTableIdentifier(TableIdentifier table) {
        this._table = table;
    }

    public TableIdentifier getTableIdentifier() {
        return this._table;
    }

    public String getTableName() {
        return null == this._table ? null : this._table.getTableName();
    }

    public String getTableAlias() {
        return null == this._table ? null : this._table.getTableAlias();
    }

    public DataType getDataType() {
        return this._type;
    }

    public void setDataType(DataType type) {
        this._type = type;
    }

    public boolean equals(Object otherobject) {
        if (otherobject instanceof ColumnIdentifier) {
            ColumnIdentifier that = (ColumnIdentifier)otherobject;
            return (null == this.getName() ? null == that.getName() : this.getName().equals(that.getName())) && (null == this.getTableIdentifier() ? null == that.getTableIdentifier() : this.getTableIdentifier().equals(that.getTableIdentifier()));
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (null != this.getName()) {
            hashCode ^= this.getName().hashCode();
        }
        if (null != this.getTableIdentifier()) {
            hashCode ^= this.getTableIdentifier().hashCode() << 4;
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.getTableIdentifier() != null) {
            result.append("(");
            result.append(this.getTableIdentifier().toString());
            result.append(").");
        }
        result.append(this.getName());
        return result.toString();
    }

    public void setVariableContext(VariableContext ctx) {
    }
}

