/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.axiondb.DataType;
import org.axiondb.Selectable;

public class Column
implements Serializable {
    private Map _config = null;
    private static final long serialVersionUID = -9163914166152422736L;
    public static final String COLUMN_SQL_TYPE_CONFIG_KEY = "sqlType";
    public static final String COLUMN_SCALE_CONFIG_KEY = "scale";
    public static final String COLUMN_PRECISION_CONFIG_KEY = "precision";
    public static final String DEFAULT_VALUE_CONFIG_KEY = "defaultValue";
    public static final String NAME_CONFIG_KEY = "name";
    public static final String DATA_TYPE_CONFIG_KEY = "type";

    public Column(String name, DataType type) throws NullPointerException {
        this(name, type, null);
    }

    public Column(String name, DataType type, Selectable defaultValue) throws NullPointerException {
        if (null == name) {
            throw new NullPointerException("name parameter must not be null");
        }
        if (null == type) {
            throw new NullPointerException("type parameter must not be null");
        }
        this._config = new HashMap();
        this.getConfiguration().put(NAME_CONFIG_KEY, name);
        this.getConfiguration().put(DATA_TYPE_CONFIG_KEY, type);
        this.getConfiguration().put(DEFAULT_VALUE_CONFIG_KEY, defaultValue);
    }

    public String getName() {
        return (String)this.getConfiguration().get(NAME_CONFIG_KEY);
    }

    public DataType getDataType() {
        return (DataType)this.getConfiguration().get(DATA_TYPE_CONFIG_KEY);
    }

    public void setSize(Integer size) {
        this.getConfiguration().put(COLUMN_PRECISION_CONFIG_KEY, size);
    }

    public int getSize() {
        Integer sizeInt = (Integer)this.getConfiguration().get(COLUMN_PRECISION_CONFIG_KEY);
        if (sizeInt == null) {
            return 0;
        }
        return sizeInt;
    }

    public void setScale(Integer size) {
        this.getConfiguration().put(COLUMN_SCALE_CONFIG_KEY, size);
    }

    public int getScale() {
        Integer scaleInt = (Integer)this.getConfiguration().get(COLUMN_SCALE_CONFIG_KEY);
        if (scaleInt == null) {
            return 0;
        }
        return scaleInt;
    }

    public String getSqlType() {
        return (String)this.getConfiguration().get(COLUMN_SQL_TYPE_CONFIG_KEY);
    }

    public void setSqlType(String type) {
        this.getConfiguration().put(COLUMN_SQL_TYPE_CONFIG_KEY, type);
    }

    public boolean hasDefault() {
        return null != this.getDefault();
    }

    public Selectable getDefault() {
        return (Selectable)this.getConfiguration().get(DEFAULT_VALUE_CONFIG_KEY);
    }

    public boolean equals(Object that) {
        if (that instanceof Column) {
            Column col = (Column)that;
            return this.getName().equals(col.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public Map getConfiguration() {
        return this._config;
    }
}

