/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.deployer;

import java.io.File;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.core.ode.integration.BPELServer;
import org.wso2.carbon.bpel.core.ode.integration.store.TenantProcessStore;
import org.wso2.carbon.bpel.deployer.internal.BPELDeployerServiceComponent;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class BPELDeployer
extends AbstractDeployer {
    private static Log log = LogFactory.getLog(BPELDeployer.class);
    private TenantProcessStore tenantProcessStore;

    public void init(ConfigurationContext configurationContext) {
        log.info((Object)("Initializing BPEL Deployer for tenant " + MultitenantUtils.getTenantId((ConfigurationContext)configurationContext) + "."));
        BPELDeployerServiceComponent.getTenantRegistryLoader().loadTenantRegistry(MultitenantUtils.getTenantId((ConfigurationContext)configurationContext));
        File bpelRepo = null;
        try {
            bpelRepo = this.createBPELRepository(configurationContext);
        }
        catch (DeploymentException e) {
            log.warn((Object)"BPEL repository creation failed.", (Throwable)e);
        }
        BPELServer bpsServer = BPELDeployerServiceComponent.getBPELServer();
        this.tenantProcessStore = bpsServer.getMultiTenantProcessStore().createProcessStoreForTenant(configurationContext);
        this.tenantProcessStore.setBpelArchiveRepo(bpelRepo);
        configurationContext.setProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER", (Object)bpsServer.getHttpConnectionManager());
        try {
            this.tenantProcessStore.init();
        }
        catch (Exception re) {
            log.warn((Object)("Initialization of tenant process store failed for tenant: " + MultitenantUtils.getTenantId((ConfigurationContext)configurationContext) + " This can cause issues in deployment of BPEL packages."), (Throwable)re);
        }
    }

    private File createBPELRepository(ConfigurationContext configCtx) throws DeploymentException {
        boolean status;
        String axisRepoPath = configCtx.getAxisConfiguration().getRepository().getPath();
        if (CarbonUtils.isURL((String)axisRepoPath)) {
            throw new DeploymentException("URL Repositories are not supported: " + axisRepoPath);
        }
        File tenantsRepository = new File(axisRepoPath);
        File bpelRepo = new File(tenantsRepository, "bpel");
        if (!bpelRepo.exists() && !(status = bpelRepo.mkdir())) {
            throw new DeploymentException("Failed to create BPEL repository directory " + bpelRepo.getAbsolutePath() + ".");
        }
        return bpelRepo;
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        try {
            this.tenantProcessStore.deploy(deploymentFileData.getFile());
        }
        catch (Exception e) {
            String errorMessage = "Error deploying BPEL package: " + deploymentFileData.getName();
            log.error((Object)errorMessage, (Throwable)e);
            throw new DeploymentException(errorMessage, (Throwable)e);
        }
    }

    public void setDirectory(String repoDir) {
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String bpelArchivePath) throws DeploymentException {
        File bpelArchiveFile = new File(bpelArchivePath);
        if (bpelArchiveFile.exists()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Assumption: this as an update of the bpel package: " + bpelArchivePath + ", Therefore no need to do undeploy"));
            }
            return;
        }
        log.info((Object)("Undeploying BPEL archive " + bpelArchivePath));
        try {
            String archiveName = bpelArchivePath.substring(bpelArchivePath.lastIndexOf(File.separator) + 1);
            String bpelPackageName = archiveName.substring(0, archiveName.lastIndexOf(".zip"));
            this.tenantProcessStore.undeploy(bpelPackageName);
        }
        catch (Exception e) {
            String errMsg = "BPEL Package: " + bpelArchivePath + " undeployment failed.";
            log.error((Object)errMsg, (Throwable)e);
            throw new DeploymentException(errMsg, (Throwable)e);
        }
    }
}

