/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.common;

import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.bpel.common.DOMUtils;
import org.wso2.carbon.bpel.common.NSContext;

public final class OMUtils {
    private OMUtils() {
    }

    public static Element toDOM(OMElement element) {
        return OMUtils.toDOM(element, DOMUtils.newDocument());
    }

    public static Element toDOM(OMElement element, Document doc) {
        return OMUtils.toDOM(element, doc, true);
    }

    public static Element toDOM(OMElement element, Document doc, boolean deepNS) {
        Iterator i;
        Element domElement = doc.createElementNS(element.getQName().getNamespaceURI(), element.getQName().getLocalPart());
        if (deepNS) {
            NSContext nscontext = new NSContext();
            OMUtils.buildNScontext(nscontext, element);
            DOMUtils.injectNamespaces(domElement, nscontext);
        } else if (element.getAllDeclaredNamespaces() != null) {
            i = element.getAllDeclaredNamespaces();
            while (i.hasNext()) {
                OMNamespace omns = (OMNamespace)i.next();
                if (omns.getPrefix().equals("")) {
                    domElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", omns.getNamespaceURI() == null ? "" : omns.getNamespaceURI());
                    continue;
                }
                domElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + omns.getPrefix(), omns.getNamespaceURI());
            }
        }
        i = element.getAllAttributes();
        while (i.hasNext()) {
            OMNamespace attrValNs;
            OMAttribute attr = (OMAttribute)i.next();
            Attr newAttr = attr.getNamespace() != null ? doc.createAttributeNS(attr.getNamespace().getNamespaceURI(), attr.getLocalName()) : doc.createAttributeNS(null, attr.getLocalName());
            newAttr.appendChild(doc.createTextNode(attr.getAttributeValue()));
            domElement.setAttributeNodeNS(newAttr);
            int colonIdx = attr.getAttributeValue().indexOf(":");
            if (colonIdx <= 0 || (attrValNs = element.findNamespaceURI(attr.getAttributeValue().substring(0, colonIdx))) == null) continue;
            domElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + attrValNs.getPrefix(), attrValNs.getNamespaceURI());
        }
        i = element.getChildren();
        while (i.hasNext()) {
            OMNode omn = (OMNode)i.next();
            switch (omn.getType()) {
                case 12: {
                    domElement.appendChild(doc.createCDATASection(((OMText)omn).getText()));
                    break;
                }
                case 4: {
                    domElement.appendChild(doc.createTextNode(((OMText)omn).getText()));
                    break;
                }
                case 1: {
                    domElement.appendChild(OMUtils.toDOM((OMElement)omn, doc, false));
                }
            }
        }
        return domElement;
    }

    private static void buildNScontext(NSContext nscontext, OMElement element) {
        if (element == null) {
            return;
        }
        if (element.getParent() instanceof OMElement) {
            OMUtils.buildNScontext(nscontext, (OMElement)element.getParent());
        }
        if (element.getAllDeclaredNamespaces() != null) {
            Iterator i = element.getAllDeclaredNamespaces();
            while (i.hasNext()) {
                OMNamespace omn = (OMNamespace)i.next();
                nscontext.register(omn.getPrefix(), omn.getNamespaceURI());
            }
        }
        if (element.getDefaultNamespace() != null) {
            nscontext.register("", element.getDefaultNamespace().getNamespaceURI());
        }
    }
}

