/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LoggingErrorHandler
implements ErrorHandler {
    private static final Log log = LogFactory.getLog(LoggingErrorHandler.class);
    private Log l = log;
    private static final String WARNING = "WARNING";
    private static final String ERROR = "ERROR";
    private static final String FATAL = "FATAL";

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.l.isDebugEnabled()) {
            this.l.debug((Object)this.formatMessage(WARNING, exception));
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (this.l.isDebugEnabled()) {
            this.l.debug((Object)this.formatMessage(ERROR, exception));
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.l.isDebugEnabled()) {
            this.l.debug((Object)this.formatMessage(FATAL, exception));
        }
    }

    private String formatMessage(String level, SAXParseException spe) {
        StringBuilder sb = new StringBuilder(64);
        if (spe.getSystemId() != null) {
            sb.append(spe.getSystemId());
        }
        sb.append(':');
        sb.append(spe.getLineNumber());
        sb.append(':');
        sb.append(spe.getColumnNumber());
        sb.append(':');
        sb.append(level);
        sb.append(':');
        sb.append(spe.getMessage());
        return sb.toString();
    }
}

