/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.common;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.bpel.common.LoggingErrorHandler;
import org.wso2.carbon.bpel.common.NSContext;

public final class DOMUtils {
    private static ThreadLocal<DocumentBuilder> builders = new ThreadLocal();
    private static final DocumentBuilderFactory documentBuilderFactory = new DocumentBuilderFactoryImpl();
    private static Log log = LogFactory.getLog(DOMUtils.class);
    public static final String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";

    private DOMUtils() {
    }

    private static void initDocumentBuilderFactory() {
        documentBuilderFactory.setNamespaceAware(true);
    }

    public static Document newDocument() {
        DocumentBuilder db = DOMUtils.getBuilder();
        return db.newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilder getBuilder() {
        DocumentBuilder builder = builders.get();
        if (builder == null) {
            DocumentBuilderFactory documentBuilderFactory = DOMUtils.documentBuilderFactory;
            synchronized (documentBuilderFactory) {
                try {
                    builder = DOMUtils.documentBuilderFactory.newDocumentBuilder();
                    builder.setErrorHandler(new LoggingErrorHandler());
                }
                catch (ParserConfigurationException e) {
                    String errMsg = "Error occurred while building the document";
                    log.error((Object)errMsg, (Throwable)e);
                    throw new RuntimeException(errMsg, e);
                }
            }
            builders.set(builder);
        }
        return builder;
    }

    public static void injectNamespaces(Element domElement, NSContext nscontext) {
        for (String uri : nscontext.getUriSet()) {
            String prefix = nscontext.getPrefix(uri);
            if (prefix == null || "".equals(prefix)) {
                domElement.setAttributeNS(NS_URI_XMLNS, "xmlns", uri);
                continue;
            }
            domElement.setAttributeNS(NS_URI_XMLNS, "xmlns:" + prefix, uri);
        }
    }

    public static Element findChildByName(Element parent, QName name, boolean recurse) {
        if (parent == null) {
            throw new IllegalArgumentException("null parent");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String nodeName;
            Node c = nl.item(i);
            if (c.getNodeType() != 1) continue;
            String string = nodeName = c.getLocalName() != null ? c.getLocalName() : c.getNodeName();
            if (!new QName(c.getNamespaceURI(), nodeName).equals(name)) continue;
            return (Element)c;
        }
        if (recurse) {
            NodeList cnl = parent.getChildNodes();
            for (int i = 0; i < cnl.getLength(); ++i) {
                Element result;
                Node c = cnl.item(i);
                if (c.getNodeType() != 1 || (result = DOMUtils.findChildByName((Element)c, name, recurse)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public static Node findChildNode(Element parent, short nodeType, boolean recurse) {
        if (parent == null) {
            throw new IllegalArgumentException("null parent");
        }
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node c = nl.item(i);
            if (c.getNodeType() != nodeType) continue;
            return c;
        }
        if (recurse) {
            NodeList cnl = parent.getChildNodes();
            for (int i = 0; i < cnl.getLength(); ++i) {
                Node result;
                Node c = cnl.item(i);
                if (c.getNodeType() != 1 || (result = DOMUtils.findChildNode((Element)c, nodeType, recurse)) == null) continue;
                return result;
            }
        }
        return null;
    }

    static {
        DOMUtils.initDocumentBuilderFactory();
    }
}

