/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.b4p.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.OdeFault;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.il.OMUtils;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.stl.CollectionsX;
import org.w3c.dom.Element;
import org.wso2.carbon.bpel.b4p.extension.BPEL4PeopleConstants;

public class SOAPHelper {
    private static Log log = LogFactory.getLog(SOAPHelper.class);
    private Binding binding;
    private SOAPFactory soapFactory;
    private boolean isRPC;

    public SOAPHelper(Binding binding, SOAPFactory soapFactory, boolean isRPC) {
        this.binding = binding;
        this.soapFactory = soapFactory;
        this.isRPC = isRPC;
    }

    public static ExtensibilityElement getBindingExtension(Binding binding) {
        ArrayList bindings = new ArrayList();
        CollectionsX.filter(bindings, (Collection)binding.getExtensibilityElements(), HTTPBinding.class);
        CollectionsX.filter(bindings, (Collection)binding.getExtensibilityElements(), SOAPBinding.class);
        CollectionsX.filter(bindings, (Collection)binding.getExtensibilityElements(), SOAP12Binding.class);
        if (bindings.size() == 0) {
            return null;
        }
        if (bindings.size() > 1) {
            throw new IllegalArgumentException("Multiple bindings: " + binding.getQName());
        }
        return (ExtensibilityElement)bindings.iterator().next();
    }

    public void createSoapRequest(MessageContext msgCtx, Element message, Operation op, List<Long> attachmentIDList) throws AxisFault {
        this.createSoapRequest(msgCtx, message, op);
        SOAPHeader header = msgCtx.getEnvelope().getHeader();
        if (attachmentIDList != null && !attachmentIDList.isEmpty()) {
            this.addAttachmentIDHeader(header, attachmentIDList);
        }
    }

    private void addAttachmentIDHeader(SOAPHeader header, List<Long> attachmentIDList) {
        String NAMESPACE = "http://wso2.org/bps/attachments";
        String NAMESPACE_PREFIX = "attch";
        String PARENT_ELEMENT_NAME = "attachmentIDs";
        String CHILD_ELEMENT_NAME = "attachmentID";
        OMNamespace omNs = this.soapFactory.createOMNamespace("http://wso2.org/bps/attachments", "attch");
        OMElement headerElement = this.soapFactory.createOMElement("attachmentIDs", omNs);
        for (Long id : attachmentIDList) {
            OMElement idElement = this.soapFactory.createOMElement("attachmentID", omNs);
            idElement.setText(String.valueOf(id));
            headerElement.addChild((OMNode)idElement);
        }
        header.addChild((OMNode)headerElement);
    }

    public void createSoapRequest(MessageContext msgCtx, Element message, Operation op) throws AxisFault {
        SOAPBody soapBody;
        if (op == null) {
            throw new NullPointerException("Null operation");
        }
        if (op.getInput().getMessage().getParts().size() > 0 && message == null) {
            throw new NullPointerException("Null message.");
        }
        if (msgCtx == null) {
            throw new NullPointerException("Null msgCtx");
        }
        BindingOperation bop = this.binding.getBindingOperation(op.getName(), null, null);
        if (bop == null) {
            throw new OdeFault("BindingOperation not found.");
        }
        BindingInput bi = bop.getBindingInput();
        if (bi == null) {
            throw new OdeFault("BindingInput not found.");
        }
        SOAPEnvelope soapEnv = msgCtx.getEnvelope();
        if (soapEnv == null) {
            soapEnv = this.soapFactory.getDefaultEnvelope();
            msgCtx.setEnvelope(soapEnv);
        }
        if ((soapBody = SOAPHelper.getSOAPBody((ElementExtensible)bi)) != null) {
            org.apache.axiom.soap.SOAPBody sb = soapEnv.getBody() == null ? this.soapFactory.createSOAPBody(soapEnv) : soapEnv.getBody();
            this.createSoapBody(sb, soapBody, op.getInput().getMessage(), message, op.getName());
        }
    }

    public void createSoapBody(org.apache.axiom.soap.SOAPBody sb, SOAPBody soapBody, Message msgDef, Element message, String rpcWrapper) throws AxisFault {
        org.apache.axiom.soap.SOAPBody partHolder = this.isRPC ? this.soapFactory.createOMElement(new QName(soapBody.getNamespaceURI(), rpcWrapper, "odens"), (OMContainer)sb) : sb;
        List parts = msgDef.getOrderedParts(soapBody.getParts());
        for (Part part : parts) {
            Element srcPartEl = DOMUtils.findChildByName((Element)message, (QName)new QName(null, part.getName()));
            if (srcPartEl == null) {
                throw new AxisFault("Missing required part in ODE Message");
            }
            OMElement omPart = OMUtils.toOM((Element)srcPartEl, (OMFactory)this.soapFactory);
            if (this.isRPC) {
                partHolder.addChild((OMNode)omPart);
                continue;
            }
            Iterator i = omPart.getChildren();
            while (i.hasNext()) {
                partHolder.addChild((OMNode)i.next());
            }
        }
    }

    public static String parseResponseFeedback(org.apache.axiom.soap.SOAPBody soapBody) throws FaultException {
        Iterator srcParts = soapBody.getChildElements();
        if (srcParts.hasNext()) {
            OMElement srcPart = (OMElement)srcParts.next();
            if (!srcPart.getQName().equals(new QName(null, "part"))) {
                throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Unexpected element in SOAP body: " + srcPart.toString());
            }
            OMElement hifb = srcPart.getFirstChildWithName(new QName("http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803", "correlation"));
            if (hifb == null) {
                throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Unexpected element in SOAP body: " + srcPart.toString());
            }
            OMElement taskIDele = hifb.getFirstChildWithName(new QName("http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803", "taskid"));
            if (taskIDele == null) {
                throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Unexpected element in SOAP body: " + srcPart.toString());
            }
            return taskIDele.getText();
        }
        throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "TaskID not found in the feedback message");
    }

    public static SOAPBody getSOAPBody(ElementExtensible ee) {
        return SOAPHelper.getFirstExtensibilityElement(ee, SOAPBody.class);
    }

    public static <T> T getFirstExtensibilityElement(ElementExtensible parent, Class<T> cls) {
        Collection ee = CollectionsX.filter((Collection)parent.getExtensibilityElements(), cls);
        return ee.isEmpty() ? null : (T)ee.iterator().next();
    }
}

