/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.b4p.extension;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.dao.AttachmentDAO;
import org.apache.ode.bpel.dd.DeployDocument;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.dd.TInvoke;
import org.apache.ode.bpel.dd.TProvide;
import org.apache.ode.bpel.engine.MessageExchangeImpl;
import org.apache.ode.bpel.epr.WSDL11Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.extension.ExtensionContext;
import org.apache.ode.store.DeploymentUnitDir;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.bpel.b4p.extension.BPEL4PeopleConstants;
import org.wso2.carbon.bpel.b4p.extension.InteractionType;
import org.wso2.carbon.bpel.b4p.internal.B4PServiceComponent;
import org.wso2.carbon.bpel.b4p.utils.SOAPHelper;
import org.wso2.carbon.bpel.common.config.EndpointConfiguration;
import org.wso2.carbon.bpel.core.ode.integration.BPELMessageContext;
import org.wso2.carbon.bpel.core.ode.integration.store.ProcessConfigurationImpl;
import org.wso2.carbon.bpel.core.ode.integration.utils.AxisServiceUtils;
import org.wso2.carbon.unifiedendpoint.core.UnifiedEndpoint;

public class PeopleActivity {
    private final Log log = LogFactory.getLog(PeopleActivity.class);
    private String name;
    private String inputVarName;
    private String outputVarName;
    private boolean isSkipable = false;
    private String partnerLinkName;
    private String operation;
    private String callbackOperationName;
    private String serviceURI;
    private String servicePort;
    private String callbackServicePort;
    private InteractionType activityType;
    private QName processId;
    private boolean isRPC = false;
    private boolean isTwoWay = true;
    private QName serviceName;
    private QName callbackServiceName;
    private Definition hiWSDL;
    private AttachmentPropagation attachmentPropagation;
    private static final long serialVersionUID = -89894857418738012L;

    public PeopleActivity(ExtensionContext extensionContext, Element element) throws FaultException {
        this.init(extensionContext, element);
    }

    public Operation getOperation(ExtensionContext extensionContext) {
        BpelRuntimeContext runTimeContext = extensionContext.getInternalInstance();
        OProcess process = runTimeContext.getProcessModel();
        OPartnerLink partnerLink = process.getPartnerLink(this.partnerLinkName);
        return partnerLink.getPartnerRoleOperation(this.operation);
    }

    public String getOperationName() {
        return this.operation;
    }

    public String getServicePort() {
        return this.servicePort;
    }

    public String getOutputVarName() {
        return this.outputVarName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    private void parseLocalTask(Node localTaskNode) {
        this.activityType = InteractionType.NOTIFICATION;
        String warnMsg = localTaskNode.getLocalName() + " is not supported yet!";
        this.log.warn((Object)warnMsg);
        throw new RuntimeException(warnMsg);
    }

    private void parseLocalNotification(Node localNotificationNode) {
        this.activityType = InteractionType.NOTIFICATION;
        String warnMsg = localNotificationNode.getLocalName() + " is not supported yet!";
        this.log.warn((Object)warnMsg);
        throw new RuntimeException(warnMsg);
    }

    private void parseRemoteNotification(Node remoteNotificationNode) {
        this.activityType = InteractionType.NOTIFICATION;
        if (remoteNotificationNode.getNodeType() == 1) {
            Element remoteTaskEle = (Element)remoteNotificationNode;
            this.partnerLinkName = remoteTaskEle.getAttribute("partnerLink");
            this.operation = remoteTaskEle.getAttribute("operation");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("name: " + this.name + " inputVarName: " + this.inputVarName + " partnerLinkName: " + this.partnerLinkName + " operation: " + this.operation));
            }
        }
    }

    private void parseRemoteTask(Node remoteTaskNode) {
        this.activityType = InteractionType.TASK;
        if (remoteTaskNode.getNodeType() == 1) {
            Element remoteTaskEle = (Element)remoteTaskNode;
            this.partnerLinkName = remoteTaskEle.getAttribute("partnerLink");
            this.operation = remoteTaskEle.getAttribute("operation");
            this.callbackOperationName = remoteTaskEle.getAttribute("responseOperation");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("name: " + this.name + " inputVarName: " + this.inputVarName + " outPutVarName: " + this.outputVarName + " isSkipable: " + this.isSkipable + " partnerLinkName: " + this.partnerLinkName + " operation: " + this.operation + " responseOperation: " + this.callbackOperationName));
            }
        }
    }

    private String getTypeOfStandardElement(Node element) throws FaultException {
        if (element.getLocalName().equals("remoteTask")) {
            return "remoteTask";
        }
        if (element.getLocalName().equals("remoteNotification")) {
            return "remoteNotification";
        }
        if (element.getLocalName().equals("localNotification")) {
            return "localNotification";
        }
        if (element.getLocalName().equals("localTask")) {
            return "localTask";
        }
        throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "The given element:" + element.getLocalName() + " is not a standard Element.");
    }

    private String extractStandardElementType(Element parentElement) throws FaultException {
        NodeList taskList = parentElement.getChildNodes();
        String elementType = null;
        int standardElementCounter = 0;
        for (int i = 0; i < taskList.getLength(); ++i) {
            if (taskList.item(i).getNodeType() != 1) continue;
            try {
                elementType = this.getTypeOfStandardElement(taskList.item(i));
                if (++standardElementCounter <= 1) continue;
                throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "There is exist more than one standard child elements in peopleActivity");
            }
            catch (FaultException e) {
                // empty catch block
            }
        }
        if (elementType != null) {
            return elementType;
        }
        throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "There is no standard child elements defined in peopleActivity");
    }

    private void processStandardElement(Element peopleActivityElement) throws FaultException {
        String elementType = this.extractStandardElementType(peopleActivityElement);
        if (elementType.equals("remoteTask")) {
            Node node = peopleActivityElement.getElementsByTagNameNS("http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803", "remoteTask").item(0);
            if (node == null) {
                throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Namespace for element:" + elementType + " is not " + "http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803");
            }
            this.parseRemoteTask(node);
        } else if (elementType.equals("remoteNotification")) {
            Node node = peopleActivityElement.getElementsByTagNameNS("http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803", "remoteNotification").item(0);
            if (node == null) {
                throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Namespace for element:" + elementType + " is not " + "http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803");
            }
            this.parseRemoteNotification(node);
        } else if (elementType.equals("localNotification")) {
            Node node = peopleActivityElement.getElementsByTagNameNS("http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803", "localNotification").item(0);
            if (node == null) {
                throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Namespace for element:" + elementType + " is not " + "http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803");
            }
            this.parseLocalNotification(node);
        } else if (elementType.equals("localTask")) {
            Node node = peopleActivityElement.getElementsByTagNameNS("http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803", "localTask").item(0);
            if (node == null) {
                throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Namespace for element:" + elementType + " is not " + "http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803");
            }
            this.parseLocalTask(node);
        }
    }

    private void processAttachmentPropagationElement(Element peopleActivityElement) throws FaultException {
        NodeList attachmentElementList = peopleActivityElement.getElementsByTagNameNS("http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803", "attachmentPropagation");
        if (attachmentElementList.getLength() > 1) {
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "More than one elements defined for:attachmentPropagation inside peopleActivity");
        }
        if (attachmentElementList.getLength() == 1) {
            Node attachmentPropagationElement = attachmentElementList.item(0);
            this.attachmentPropagation = new AttachmentPropagation((Element)attachmentPropagationElement);
        } else if (attachmentElementList.getLength() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No attachmentPropagation activities found. Hence assuming the default values defined by specification.");
            }
            this.attachmentPropagation = new AttachmentPropagation();
        } else if (peopleActivityElement.getElementsByTagName("attachmentPropagation").getLength() > 0) {
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Namespace defined for :attachmentPropagation inside peopleActivity is wrong.");
        }
    }

    private void init(ExtensionContext extensionContext, Element element) throws FaultException {
        if (!element.getLocalName().equals("peopleActivity") || !element.getNamespaceURI().equals("http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803")) {
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "No peopleActivity activity found");
        }
        this.name = element.getAttribute("name");
        this.inputVarName = element.getAttribute("inputVariable");
        this.outputVarName = element.getAttribute("outputVariable");
        this.isSkipable = "yes".equalsIgnoreCase(element.getAttribute("isSkipable"));
        this.processStandardElement(element);
        this.processAttachmentPropagationElement(element);
        DeploymentUnitDir du = new DeploymentUnitDir(new File(extensionContext.getDUDir()));
        this.processId = new QName(extensionContext.getProcessModel().getQName().getNamespaceURI(), extensionContext.getProcessModel().getQName().getLocalPart() + "-" + du.getStaticVersion());
        this.isTwoWay = this.activityType.equals((Object)InteractionType.TASK);
        this.deriveServiceEPR(du, extensionContext);
    }

    private void deriveServiceEPR(DeploymentUnitDir du, ExtensionContext extensionContext) throws FaultException {
        DeployDocument deployDocument = du.getDeploymentDescriptor();
        BpelRuntimeContext runTimeContext = extensionContext.getInternalInstance();
        OProcess oProcess = runTimeContext.getProcessModel();
        TDeployment.Process hiProcess = null;
        List processList = deployDocument.getDeploy().getProcessList();
        for (TDeployment.Process process : processList) {
            if (!process.getName().equals(oProcess.getQName())) continue;
            hiProcess = process;
            break;
        }
        if (hiProcess == null) {
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Related process: " + oProcess.getQName() + " not found");
        }
        List tInvokeList = hiProcess.getInvokeList();
        for (TInvoke tInvoke : tInvokeList) {
            if (!tInvoke.getPartnerLink().equals(this.partnerLinkName)) continue;
            this.serviceName = tInvoke.getService().getName();
            this.servicePort = tInvoke.getService().getPort();
            break;
        }
        if (this.serviceName == null || this.servicePort == null) {
            this.log.error((Object)"service and port for human interaction is not found in the deploy.xml");
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Service or port for human interaction is not found in the deploy.xml");
        }
        if (this.activityType.equals((Object)InteractionType.TASK)) {
            List tProvideList = hiProcess.getProvideList();
            for (TProvide tProvide : tProvideList) {
                if (!tProvide.getPartnerLink().equals(this.partnerLinkName)) continue;
                this.callbackServiceName = tProvide.getService().getName();
                this.callbackServicePort = tProvide.getService().getPort();
                break;
            }
            if (this.callbackServiceName == null || this.callbackServicePort == null) {
                throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Service or port for human task callback is not found in the deploy.xml");
            }
        }
        this.hiWSDL = du.getDefinitionForService(this.serviceName);
        Service service = this.hiWSDL.getService(this.serviceName);
        Port port = service.getPort(this.servicePort);
        List extList = port.getExtensibilityElements();
        for (Object extEle : extList) {
            if (!(extEle instanceof SOAPAddressImpl)) continue;
            SOAPAddressImpl soapAddress = (SOAPAddressImpl)extEle;
            this.serviceURI = soapAddress.getLocationURI();
            break;
        }
        if (this.serviceURI == null) {
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Service URI is not available");
        }
    }

    public Binding getBinding() throws FaultException {
        Service serviceDef = this.hiWSDL.getService(this.serviceName);
        if (serviceDef == null) {
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Service definition is not available for service " + this.serviceName);
        }
        Port port = serviceDef.getPort(this.getServicePort());
        if (port == null) {
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Service port is not available for service " + this.serviceName + " and port " + this.getServicePort());
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Service binding is not available for service " + this.serviceName + " and port " + this.getServicePort());
        }
        return binding;
    }

    public SOAPFactory getSoapFactory() throws FaultException {
        Binding binding = this.getBinding();
        ExtensibilityElement bindingType = SOAPHelper.getBindingExtension(binding);
        if (!(bindingType instanceof SOAPBinding || bindingType instanceof SOAP12Binding || bindingType instanceof HTTPBinding)) {
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Service binding is not supported for service " + this.serviceName + " and port " + this.getServicePort());
        }
        if (bindingType instanceof SOAPBinding) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        return OMAbstractFactory.getSOAP12Factory();
    }

    public UnifiedEndpoint getUnifiedEndpoint() throws FaultException {
        int tenantId = B4PServiceComponent.getBPELServer().getMultiTenantProcessStore().getTenantId(this.processId);
        ProcessConfigurationImpl processConf = (ProcessConfigurationImpl)B4PServiceComponent.getBPELServer().getMultiTenantProcessStore().getTenantsProcessStore(Integer.valueOf(tenantId)).getProcessConfiguration(this.processId);
        EndpointConfiguration epConf = processConf.getEndpointConfiguration((EndpointReference)new WSDL11Endpoint(this.serviceName, this.servicePort));
        try {
            return epConf.getUnifiedEndpoint();
        }
        catch (AxisFault axisFault) {
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Error occurred while reading UnifiedEndpoint for service " + this.serviceName, (Throwable)axisFault);
        }
    }

    public ConfigurationContext getConfigurationContext() throws FaultException {
        int tenantId = B4PServiceComponent.getBPELServer().getMultiTenantProcessStore().getTenantId(this.processId);
        ProcessConfigurationImpl processConf = (ProcessConfigurationImpl)B4PServiceComponent.getBPELServer().getMultiTenantProcessStore().getTenantsProcessStore(Integer.valueOf(tenantId)).getProcessConfiguration(this.processId);
        return processConf.getTenantConfigurationContext();
    }

    private Collection<Long> getAttachmentIDs(ExtensionContext extensionContext) {
        ArrayList<Long> attachmentIDs = new ArrayList<Long>();
        Collection mexList = extensionContext.getInternalInstance().getMessageExchangeDAOs();
        for (MessageExchange mex : mexList) {
            MessageExchangeImpl mexImpl = (MessageExchangeImpl)mex;
            Collection attachmentDAOList = mexImpl.getDAO().getAttachments();
            for (AttachmentDAO dao : attachmentDAOList) {
                attachmentIDs.add(dao.getId());
            }
        }
        this.log.warn((Object)"Here we return a one level list, so the client doesn't knows which attachment ids are bind to which message exchanges");
        return attachmentIDs;
    }

    private List<Long> extractAttachmentIDsToBeSentToHumanTask(ExtensionContext extensionContext, BPELMessageContext taskMessageContext) {
        List<Long> attachmentIDList = new ArrayList<Long>();
        if (this.attachmentPropagation != null && this.attachmentPropagation.isInitialized) {
            if (FromProcessSpec.all.toString().equals(this.attachmentPropagation.getFromProcess())) {
                attachmentIDList = (List)this.getAttachmentIDs(extensionContext);
                taskMessageContext.setAttachmentIDList(attachmentIDList);
            } else if (FromProcessSpec.none.toString().equals(this.attachmentPropagation.getFromProcess()) && this.log.isDebugEnabled()) {
                this.log.debug((Object)("No attachments will be propagated to the human-task as attribute value of fromProcess is " + (Object)((Object)FromProcessSpec.none)));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"AttachmentPropagation element is not initialized yet. So attachments are ignored by the BPEL4People extension runtime.");
        }
        return attachmentIDList;
    }

    public String invoke(ExtensionContext extensionContext) throws FaultException {
        BPELMessageContext taskMessageContext = new BPELMessageContext(this.hiWSDL);
        try {
            List<Long> attachmentIDList = this.extractAttachmentIDsToBeSentToHumanTask(extensionContext, taskMessageContext);
            taskMessageContext.setOperationName(this.getOperationName());
            SOAPHelper soapHelper = new SOAPHelper(this.getBinding(), this.getSoapFactory(), this.isRPC);
            MessageContext messageContext = new MessageContext();
            soapHelper.createSoapRequest(messageContext, (Element)extensionContext.readVariable(this.inputVarName), this.getOperation(extensionContext), attachmentIDList);
            taskMessageContext.setInMessageContext(messageContext);
            taskMessageContext.setPort(this.getServicePort());
            taskMessageContext.setService(this.getServiceName());
            taskMessageContext.setRPCStyleOperation(this.isRPC);
            taskMessageContext.setTwoWay(this.isTwoWay);
            taskMessageContext.setSoapFactoryForCurrentMessageFlow(this.getSoapFactory());
            taskMessageContext.setWsdlBindingForCurrentMessageFlow(this.getBinding());
            taskMessageContext.setUep(this.getUnifiedEndpoint());
            taskMessageContext.setCaller(this.processId.getLocalPart());
            AxisServiceUtils.invokeService((BPELMessageContext)taskMessageContext, (ConfigurationContext)this.getConfigurationContext());
        }
        catch (AxisFault axisFault) {
            this.log.error((Object)axisFault, (Throwable)axisFault);
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Error occurred while invoking service " + this.serviceName, (Throwable)axisFault);
        }
        if (taskMessageContext.getFaultMessageContext() != null || taskMessageContext.getOutMessageContext().isFault()) {
            MessageContext faultContext = taskMessageContext.getFaultMessageContext() != null ? taskMessageContext.getFaultMessageContext() : taskMessageContext.getOutMessageContext();
            this.log.warn((Object)("SOAP Fault: " + faultContext.getEnvelope().toString()));
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, faultContext.getEnvelope().toString());
        }
        return SOAPHelper.parseResponseFeedback(taskMessageContext.getOutMessageContext().getEnvelope().getBody());
    }

    public String inferCorrelatorId(ExtensionContext extensionContext) throws FaultException {
        PartnerLinkInstance plink = extensionContext.getPartnerLinkInstance(this.partnerLinkName);
        return plink.partnerLink.getName() + "." + this.callbackOperationName;
    }

    static enum ToProcessSpec {
        all,
        newOnly,
        none;

    }

    static enum FromProcessSpec {
        all,
        none;

    }

    class AttachmentPropagation {
        private String fromProcess;
        private String toProcess;
        private boolean isInitialized;

        public boolean isInitialized() {
            return this.isInitialized;
        }

        public String getFromProcess() {
            return this.fromProcess;
        }

        public String getToProcess() {
            return this.toProcess;
        }

        public AttachmentPropagation() throws FaultException {
            this.init();
        }

        private AttachmentPropagation(Element element) throws FaultException {
            this.init(element);
        }

        private void init() throws FaultException {
            this.fromProcess = this.extractFromProcessValue(FromProcessSpec.all.toString());
            this.toProcess = this.extractToProcessValue(ToProcessSpec.newOnly.toString());
            this.isInitialized = true;
        }

        private void init(Element element) throws FaultException {
            if (!element.getLocalName().equals("attachmentPropagation") || !element.getNamespaceURI().equals("http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803")) {
                throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "No attachmentPropagation found");
            }
            this.fromProcess = this.extractFromProcessValue(element.getAttribute("fromProcess"));
            this.toProcess = this.extractToProcessValue(element.getAttribute("toProcess"));
            this.isInitialized = true;
        }

        private String extractFromProcessValue(String fromProcessValue) throws FaultException {
            if (FromProcessSpec.all.toString().equals(fromProcessValue) || FromProcessSpec.none.toString().equals(fromProcessValue)) {
                return fromProcessValue;
            }
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Assigned value for fromProcess attribute is not compliant with the specification.");
        }

        private String extractToProcessValue(String toProcessValue) throws FaultException {
            if (ToProcessSpec.all.toString().equals(toProcessValue) || ToProcessSpec.none.toString().equals(toProcessValue) || ToProcessSpec.newOnly.toString().equals(toProcessValue)) {
                return toProcessValue;
            }
            throw new FaultException(BPEL4PeopleConstants.B4P_FAULT, "Assigned value for toProcess attribute is not compliant with the specification.");
        }
    }
}

