/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.mgt.ui.utils;

import java.text.SimpleDateFormat;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.mgt.stub.beans.xsd.BillingPeriod;
import org.wso2.carbon.billing.mgt.stub.beans.xsd.Discount;
import org.wso2.carbon.billing.mgt.stub.beans.xsd.MultitenancyInvoice;
import org.wso2.carbon.billing.mgt.stub.beans.xsd.OutstandingBalanceInfoBean;
import org.wso2.carbon.billing.mgt.stub.beans.xsd.PaginatedBalanceInfoBean;
import org.wso2.carbon.billing.mgt.stub.beans.xsd.Payment;
import org.wso2.carbon.billing.mgt.ui.clients.BillingServiceClient;
import org.wso2.carbon.registry.common.ui.UIException;

public class BillingUtil {
    private static final Log log = LogFactory.getLog(BillingUtil.class);

    public static BillingPeriod[] getAvailableBillingPeriods(ServletConfig config, HttpSession session) throws UIException {
        try {
            BillingServiceClient serviceClient = new BillingServiceClient(config, session);
            return serviceClient.getAvailableBillingPeriods();
        }
        catch (Exception e) {
            String msg = "Failed to get available billing periods.";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static BillingPeriod[] getAvailableBillingPeriodsBySuperTenant(ServletConfig config, HttpSession session, String tenantDomain) throws UIException {
        try {
            BillingServiceClient client = new BillingServiceClient(config, session);
            return client.getBillingPeriodsBySuperTenant(tenantDomain);
        }
        catch (Exception e) {
            String msg = "Error occurred while getting available invoice dates for tenant: " + tenantDomain;
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static String[] getAvailableBillingMonths(ServletConfig config, HttpSession session) throws UIException {
        return BillingUtil.getAvailableBillingMonths(BillingUtil.getAvailableBillingPeriods(config, session));
    }

    public static MultitenancyInvoice getPastInvoice(ServletConfig config, HttpSession session, int invoiceId) throws UIException {
        try {
            BillingServiceClient serviceClient = new BillingServiceClient(config, session);
            return serviceClient.getPastInvoice(invoiceId);
        }
        catch (Exception e) {
            String msg = "Failed to get past invoice for invoice id:" + invoiceId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static MultitenancyInvoice getCurrentInvoice(ServletConfig config, HttpSession session) throws UIException {
        try {
            BillingServiceClient serviceClient = new BillingServiceClient(config, session);
            return serviceClient.getCurrentInvoice();
        }
        catch (Exception e) {
            String msg = "Failed to get the current invoice.";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static String[] getAvailableBillingMonths(BillingPeriod[] billingPeriods) {
        if (billingPeriods == null || billingPeriods.length == 0) {
            return new String[0];
        }
        String[] billingMonths = new String[billingPeriods.length];
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MMM-dd");
        int index = 0;
        for (BillingPeriod period : billingPeriods) {
            billingMonths[index++] = yearMonthFormat.format(period.getInvoiceDate());
        }
        return billingMonths;
    }

    public static int addPaymentDetails(ServletConfig config, HttpSession session, Payment payment, String amount) throws UIException {
        try {
            BillingServiceClient serviceClient = new BillingServiceClient(config, session);
            return serviceClient.addPayment(payment, amount);
        }
        catch (Exception exp) {
            String msg = "Failed to add the payment record " + payment.getDescription();
            log.error((Object)msg, (Throwable)exp);
            throw new UIException(msg, (Throwable)exp);
        }
    }

    public static int makeAdjustment(ServletConfig config, HttpSession session, Payment payment, String amount) throws UIException {
        try {
            BillingServiceClient serviceClient = new BillingServiceClient(config, session);
            return serviceClient.makeAdjustment(payment, amount);
        }
        catch (Exception exp) {
            String msg = "Failed to add the payment record " + payment.getDescription();
            log.error((Object)msg, (Throwable)exp);
            throw new UIException(msg, (Throwable)exp);
        }
    }

    public static PaginatedBalanceInfoBean getPaginatedBalanceInfo(ServletConfig config, HttpSession session, int pageNumber) throws UIException {
        try {
            BillingServiceClient serviceClient = new BillingServiceClient(config, session);
            return serviceClient.getPaginatedBalanceInfo(pageNumber);
        }
        catch (Exception exp) {
            String msg = "Failed to get paginated balance info ";
            log.error((Object)msg, (Throwable)exp);
            throw new UIException(msg, (Throwable)exp);
        }
    }

    public static OutstandingBalanceInfoBean[] getOutstandingBalance(ServletConfig config, HttpSession session, String tenantDomain) throws UIException {
        try {
            BillingServiceClient serviceClient = new BillingServiceClient(config, session);
            return serviceClient.getOutstandingBalance(tenantDomain);
        }
        catch (Exception exp) {
            String msg = "Failed to get balance info for domain: " + tenantDomain;
            log.error((Object)msg, (Throwable)exp);
            throw new UIException(msg, (Throwable)exp);
        }
    }

    public static boolean addDiscount(ServletConfig config, HttpSession session, Discount discount, String tenantDomain) throws UIException {
        try {
            BillingServiceClient serviceClient = new BillingServiceClient(config, session);
            return serviceClient.addDiscount(discount, tenantDomain);
        }
        catch (Exception exp) {
            String msg = "Failed to failed to add the discount for tenant: " + discount.getTenantId();
            log.error((Object)msg, (Throwable)exp);
            throw new UIException(msg, (Throwable)exp);
        }
    }
}

