/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.mgt.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.billing.core.BillingEngine;
import org.wso2.carbon.billing.core.BillingException;
import org.wso2.carbon.billing.core.BillingHandler;
import org.wso2.carbon.billing.core.BillingManager;
import org.wso2.carbon.billing.core.DataAccessManager;
import org.wso2.carbon.billing.mgt.api.DefaultTenantBilling;
import org.wso2.carbon.billing.mgt.api.MultitenancyBillingInfo;
import org.wso2.carbon.billing.mgt.handlers.MultitenancySubscriptionFeedingHandler;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.stratos.common.TenantBillingService;
import org.wso2.carbon.throttling.agent.ThrottlingAgent;
import org.wso2.carbon.usage.api.TenantUsageRetriever;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.ConfigurationContextService;

public class Util {
    private static BillingManager billingManager = null;
    private static DataAccessManager dataAccessManager = null;
    private static RegistryService registryService;
    private static RealmService realmService;
    private static TenantUsageRetriever tenantUsageRetriever;
    private static MultitenancyBillingInfo billingInfo;
    private static ServiceTracker throttlingRuleInvokerTracker;
    private static BundleContext bundleContext;
    private static Log log;
    private static ConfigurationContextService contextService;

    public static ConfigurationContextService getContextService() {
        return contextService;
    }

    public static void setContextService(ConfigurationContextService contextService) {
        Util.contextService = contextService;
    }

    public static synchronized void setRegistryService(RegistryService service) {
        if (registryService == null) {
            registryService = service;
        }
    }

    public static synchronized void setRealmService(RealmService service) {
        if (realmService == null) {
            realmService = service;
        }
    }

    public static void setTenantUsageRetriever(TenantUsageRetriever tenantUsageRetriever) {
        Util.tenantUsageRetriever = tenantUsageRetriever;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static TenantUsageRetriever getTenantUsageRetriever() {
        return tenantUsageRetriever;
    }

    public static TenantManager getTenantManager() {
        if (realmService == null) {
            return null;
        }
        return realmService.getTenantManager();
    }

    public static BillingManager getBillingManager() {
        return billingManager;
    }

    public static void setBillingManager(BillingManager billingManager) {
        Util.billingManager = billingManager;
    }

    public static void registerSubscriptionFeedingHandlers(BundleContext bundleContext) {
        bundleContext.registerService(BillingHandler.class.getName(), (Object)new MultitenancySubscriptionFeedingHandler(), null);
    }

    public static void registerTenantBillingService(BundleContext bundleContext) {
        bundleContext.registerService(TenantBillingService.class.getName(), (Object)new DefaultTenantBilling(), null);
    }

    public static void scheduleBilling() throws BillingException {
        BillingEngine billingEngine = billingManager.getBillingEngine("multitenancyScheduledTask");
        if (billingEngine != null) {
            billingEngine.scheduleBilling();
        } else {
            log.info((Object)"No billing engine for scheduled tasks");
        }
    }

    public static void registerBillingInfo(BundleContext bundleContext) throws Exception {
        billingInfo = new MultitenancyBillingInfo();
        bundleContext.registerService(MultitenancyBillingInfo.class.getName(), (Object)billingInfo, null);
    }

    public static MultitenancyBillingInfo getMultitenancyBillingInfo() {
        return billingInfo;
    }

    public static DataAccessManager getDataAccessManager() {
        return dataAccessManager;
    }

    public static void setDataAccessManager(DataAccessManager dataAccessManager) {
        Util.dataAccessManager = dataAccessManager;
    }

    public static void initDataAccessManager() {
        DataAccessManager dataAccessManager;
        Util.dataAccessManager = dataAccessManager = new DataAccessManager(billingManager.getBillingConfiguration().getDataSource());
    }

    public static void initializeThrottling(BundleContext bundleContext) {
        throttlingRuleInvokerTracker = new ServiceTracker(bundleContext, ThrottlingAgent.class.getName(), null);
        throttlingRuleInvokerTracker.open();
    }

    public static void executeThrottlingRules(int tenantId) {
        try {
            ThrottlingAgent embeddedRuleInvoker = (ThrottlingAgent)throttlingRuleInvokerTracker.getService();
            if (embeddedRuleInvoker != null) {
                embeddedRuleInvoker.executeThrottlingRules(tenantId);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in executing throttling rules in manager" + e.toString()));
        }
    }

    static {
        throttlingRuleInvokerTracker = null;
        log = LogFactory.getLog(Util.class);
    }
}

