/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.billing.mgt.services;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.billing.core.BillingEngine;
import org.wso2.carbon.billing.core.BillingEngineContext;
import org.wso2.carbon.billing.core.BillingManager;
import org.wso2.carbon.billing.core.beans.OutstandingBalanceInfoBean;
import org.wso2.carbon.billing.core.beans.PaginatedBalanceInfoBean;
import org.wso2.carbon.billing.core.dataobjects.Cash;
import org.wso2.carbon.billing.core.dataobjects.Customer;
import org.wso2.carbon.billing.core.dataobjects.Discount;
import org.wso2.carbon.billing.core.dataobjects.Invoice;
import org.wso2.carbon.billing.core.dataobjects.Item;
import org.wso2.carbon.billing.core.dataobjects.Payment;
import org.wso2.carbon.billing.core.dataobjects.Subscription;
import org.wso2.carbon.billing.mgt.beans.BilledEntry;
import org.wso2.carbon.billing.mgt.beans.BillingPeriod;
import org.wso2.carbon.billing.mgt.beans.MultitenancyInvoice;
import org.wso2.carbon.billing.mgt.beans.MultitenancyPurchaseOrder;
import org.wso2.carbon.billing.mgt.beans.MultitenancySubscription;
import org.wso2.carbon.billing.mgt.util.Util;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.util.ClaimsMgtUtil;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.DataPaginator;
import org.wso2.carbon.utils.Pageable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BillingService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(BillingService.class);

    public BillingPeriod[] getAvailableBillingPeriods() throws Exception {
        UserRegistry registry = (UserRegistry)this.getGovernanceUserRegistry();
        return this.getAvailableBillingPeriods(registry);
    }

    public BillingPeriod[] getAvailableBillingPeriodsBySuperTenant(String tenantDomain) throws Exception {
        BillingManager billingManager = Util.getBillingManager();
        BillingEngine billingEngine = billingManager.getBillingEngine("multitenancyViewingTask");
        List customers = billingEngine.getCustomersWithName(tenantDomain);
        if (customers.size() > 0) {
            return this.getBillingPeriodsFromInvoices(billingEngine.getInvoices((Customer)customers.get(0)));
        }
        return new BillingPeriod[0];
    }

    public MultitenancyInvoice getPastInvoice(int invoiceId) throws Exception {
        UserRegistry registry = (UserRegistry)this.getGovernanceUserRegistry();
        return this.getPastInvoiceById(registry, invoiceId);
    }

    public MultitenancyInvoice getCurrentInvoice() throws Exception {
        UserRegistry registry = (UserRegistry)this.getGovernanceUserRegistry();
        return this.getCurrentInvoiceOfCustomer(registry);
    }

    public int addPayment(Payment payment, String amount) throws Exception {
        int paymentId = this.addPaymentRecord(payment, amount);
        if (paymentId > 0) {
            payment.setId(paymentId);
            this.sendPaymentReceivedEmail(payment);
        }
        return paymentId;
    }

    public int makeAdjustment(Payment payment, String amount) throws Exception {
        return this.addPaymentRecord(payment, amount);
    }

    private int addPaymentRecord(Payment payment, String amount) throws Exception {
        BillingManager billingManager = Util.getBillingManager();
        BillingEngine billingEngine = billingManager.getBillingEngine("multitenancyViewingTask");
        Cash cashAmount = new Cash(amount);
        payment.setAmount(cashAmount);
        if (payment.getInvoice() != null) {
            payment.setSubscriptions(billingEngine.getInvoiceSubscriptions(payment.getInvoice().getId()));
        }
        int paymentId = billingEngine.addPayment(payment);
        return paymentId;
    }

    public PaginatedBalanceInfoBean getPaginatedBalances(int pageNumber) throws Exception {
        BillingManager billingManager = Util.getBillingManager();
        BillingEngine billingEngine = billingManager.getBillingEngine("multitenancyViewingTask");
        List balanceBeans = billingEngine.getAllOutstandingBalances(null);
        PaginatedBalanceInfoBean paginatedBalanceBean = new PaginatedBalanceInfoBean();
        DataPaginator.doPaging((int)pageNumber, (List)balanceBeans, (Pageable)paginatedBalanceBean);
        return paginatedBalanceBean;
    }

    public OutstandingBalanceInfoBean[] getOutstandingBalance(String tenantDomain) throws Exception {
        BillingManager billingManager = Util.getBillingManager();
        BillingEngine billingEngine = billingManager.getBillingEngine("multitenancyViewingTask");
        List balanceBeans = billingEngine.getAllOutstandingBalanceInfoBeans(tenantDomain);
        return balanceBeans.toArray(new OutstandingBalanceInfoBean[balanceBeans.size()]);
    }

    public boolean addDiscount(Discount discount, String tenantDomain) throws Exception {
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        int tenantId = tenantManager.getTenantId(tenantDomain);
        if (tenantId == -1) {
            throw new Exception("Invalid tenant domain submitted for a discount");
        }
        discount.setTenantId(tenantId);
        BillingManager billingManager = Util.getBillingManager();
        BillingEngine billingEngine = billingManager.getBillingEngine("multitenancyViewingTask");
        boolean added = billingEngine.addDiscount(discount);
        if (added) {
            log.info((Object)("Discount entry added for tenant: " + discount.getTenantId()));
        }
        return added;
    }

    private MultitenancyInvoice getPastInvoiceById(UserRegistry registry, int invoiceId) throws Exception {
        BillingManager billingManager = Util.getBillingManager();
        BillingEngine billingEngine = billingManager.getBillingEngine("multitenancyViewingTask");
        Invoice invoice = billingEngine.getInvoice(invoiceId);
        if (invoice == null) {
            return null;
        }
        Customer customer = this.getCurrentCustomer(registry, billingEngine);
        if (customer == null || customer.getId() != invoice.getCustomer().getId()) {
            String msg = "Trying to looking at an invoice of another customer, customer: " + (customer == null ? "unknown" : Integer.valueOf(customer.getId())) + ", invoice: " + invoice.getId() + ".";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        MultitenancyInvoice multitenancyInvoice = new MultitenancyInvoice();
        multitenancyInvoice.setInvoiceId(invoice.getId());
        multitenancyInvoice.setBillingDate(invoice.getDate());
        multitenancyInvoice.setBoughtForward(invoice.getBoughtForward().serializeToString());
        multitenancyInvoice.setCarriedForward(invoice.getCarriedForward().serializeToString());
        multitenancyInvoice.setStartDate(invoice.getStartDate());
        multitenancyInvoice.setEndDate(invoice.getEndDate());
        multitenancyInvoice.setTotalCost(invoice.getTotalCost().serializeToString());
        multitenancyInvoice.setTotalPayments(invoice.getTotalPayment().serializeToString());
        List subscriptions = invoice.getSubscriptions();
        MultitenancySubscription[] multitenancySubscriptions = new MultitenancySubscription[subscriptions.size()];
        for (int i = 0; i < subscriptions.size(); ++i) {
            Subscription subscription = (Subscription)subscriptions.get(i);
            MultitenancySubscription multitenancySubscription = new MultitenancySubscription();
            multitenancySubscription.setSubscribedPackage(subscription.getItem().getName());
            multitenancySubscription.setActiveSince(subscription.getActiveSince());
            multitenancySubscription.setActiveUntil(subscription.getActiveUntil());
            multitenancySubscription.setActive(subscription.isActive());
            List billedItems = billingEngine.getBilledItems(subscription);
            BilledEntry[] itemEntries = new BilledEntry[billedItems.size()];
            for (int j = 0; j < billedItems.size(); ++j) {
                Item billedItem = (Item)billedItems.get(j);
                if (billedItem.getName().equals(multitenancySubscription.getSubscribedPackage())) continue;
                BilledEntry itemEntry = new BilledEntry();
                itemEntry.setName(billedItem.getDescription());
                itemEntry.setCost(billedItem.getCost().serializeToString());
                itemEntries[j] = itemEntry;
            }
            multitenancySubscription.setBilledEntries(itemEntries);
            multitenancySubscriptions[i] = multitenancySubscription;
        }
        multitenancyInvoice.setSubscriptions(multitenancySubscriptions);
        List payments = invoice.getPayments();
        if (payments != null) {
            MultitenancyPurchaseOrder[] multitenancyPurchaseOrders = new MultitenancyPurchaseOrder[payments.size()];
            for (int i = 0; i < payments.size(); ++i) {
                Payment payment = (Payment)payments.get(i);
                MultitenancyPurchaseOrder multitenancyPurchaseOrder = new MultitenancyPurchaseOrder();
                multitenancyPurchaseOrder.setId(payment.getId());
                multitenancyPurchaseOrder.setPaymentDate(payment.getDate());
                multitenancyPurchaseOrder.setPayment(payment.getAmount().serializeToString());
                multitenancyPurchaseOrder.setTransactionId(payment.getDescription());
                multitenancyPurchaseOrders[i] = multitenancyPurchaseOrder;
            }
            multitenancyInvoice.setPurchaseOrders(multitenancyPurchaseOrders);
        }
        return multitenancyInvoice;
    }

    private MultitenancyInvoice getCurrentInvoiceOfCustomer(UserRegistry registry) throws Exception {
        BillingManager billingManager = Util.getBillingManager();
        BillingEngine billingEngineViewer = billingManager.getBillingEngine("multitenancyViewingTask");
        Customer customer = this.getCurrentCustomer(registry, billingEngineViewer);
        if (customer == null) {
            return null;
        }
        BillingEngineContext billingEngineContext = new BillingEngineContext();
        billingEngineContext.setCustomer(customer);
        billingEngineViewer.generateBill(billingEngineContext);
        customer = billingEngineContext.getCustomer();
        Invoice invoice = customer.getActiveInvoice();
        if (invoice == null) {
            return null;
        }
        if (customer.getId() != invoice.getCustomer().getId()) {
            String msg = "Trying to looking at an invoice of another customer, customer: " + customer.getId() + ", invoice: " + invoice.getId() + ".";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        MultitenancyInvoice multitenancyInvoice = new MultitenancyInvoice();
        multitenancyInvoice.setBillingDate(invoice.getDate());
        multitenancyInvoice.setBoughtForward(invoice.getBoughtForward().serializeToString());
        multitenancyInvoice.setCarriedForward(invoice.getCarriedForward().serializeToString());
        multitenancyInvoice.setEndDate(invoice.getEndDate());
        multitenancyInvoice.setInvoiceId(invoice.getId());
        multitenancyInvoice.setStartDate(invoice.getStartDate());
        List payments = invoice.getPayments();
        MultitenancyPurchaseOrder[] multitenancyPurchaseOrders = new MultitenancyPurchaseOrder[payments.size()];
        for (int i = 0; i < payments.size(); ++i) {
            Payment payment = (Payment)payments.get(i);
            MultitenancyPurchaseOrder multitenancyPurchaseOrder = new MultitenancyPurchaseOrder();
            multitenancyPurchaseOrder.setId(payment.getId());
            multitenancyPurchaseOrder.setPaymentDate(payment.getDate());
            multitenancyPurchaseOrder.setPayment(payment.getAmount().serializeToString());
            multitenancyPurchaseOrder.setTransactionId(payment.getDescription());
            multitenancyPurchaseOrders[i] = multitenancyPurchaseOrder;
        }
        multitenancyInvoice.setPurchaseOrders(multitenancyPurchaseOrders);
        List subscriptions = invoice.getSubscriptions();
        MultitenancySubscription[] multitenancySubscriptions = new MultitenancySubscription[subscriptions.size()];
        for (int i = 0; i < subscriptions.size(); ++i) {
            BilledEntry[] itemEntries;
            Subscription subscription = (Subscription)subscriptions.get(i);
            MultitenancySubscription multitenancySubscription = new MultitenancySubscription();
            multitenancySubscription.setSubscribedPackage(subscription.getItem().getName());
            multitenancySubscription.setActiveSince(subscription.getActiveSince());
            multitenancySubscription.setActiveUntil(subscription.getActiveUntil());
            multitenancySubscription.setActive(subscription.isActive());
            List subItems = subscription.getItem().getChildren();
            if (subItems != null) {
                itemEntries = new BilledEntry[subItems.size()];
                for (int j = 0; j < subItems.size(); ++j) {
                    BilledEntry billedEntry = new BilledEntry();
                    Item billedItem = (Item)subItems.get(j);
                    billedEntry.setName(billedItem.getDescription());
                    if (billedItem.getCost() != null) {
                        billedEntry.setCost(billedItem.getCost().toString());
                    } else {
                        billedEntry.setCost(new Cash("$0").toString());
                    }
                    itemEntries[j] = billedEntry;
                }
            } else {
                itemEntries = new BilledEntry[]{};
            }
            multitenancySubscription.setBilledEntries(itemEntries);
            multitenancySubscriptions[i] = multitenancySubscription;
        }
        multitenancyInvoice.setSubscriptions(multitenancySubscriptions);
        Cash totalCost = invoice.getTotalCost();
        if (totalCost == null) {
            totalCost = new Cash("$0");
        }
        multitenancyInvoice.setTotalCost(totalCost.serializeToString());
        Cash totalPaymentCash = invoice.getTotalPayment();
        if (totalPaymentCash == null) {
            totalPaymentCash = new Cash("$0");
        }
        multitenancyInvoice.setTotalPayments(totalPaymentCash.serializeToString());
        return multitenancyInvoice;
    }

    private Customer getCurrentCustomer(UserRegistry userRegistry, BillingEngine billingEngine) throws Exception {
        int currentTenantId = userRegistry.getTenantId();
        TenantManager tenantManger = Util.getRealmService().getTenantManager();
        Tenant currentTenant = (Tenant)tenantManger.getTenant(currentTenantId);
        List customers = billingEngine.getCustomersWithName(currentTenant.getDomain());
        if (customers == null || customers.isEmpty()) {
            return null;
        }
        return (Customer)customers.get(0);
    }

    private BillingPeriod[] getAvailableBillingPeriods(UserRegistry registry) throws Exception {
        BillingManager billingManager = Util.getBillingManager();
        BillingEngine billingEngine = billingManager.getBillingEngine("multitenancyViewingTask");
        Customer customer = this.getCurrentCustomer(registry, billingEngine);
        if (customer == null) {
            return new BillingPeriod[0];
        }
        List invoices = billingEngine.getInvoices(customer);
        if (invoices == null || invoices.size() == 0) {
            return new BillingPeriod[0];
        }
        return this.getBillingPeriodsFromInvoices(invoices);
    }

    private BillingPeriod[] getBillingPeriodsFromInvoices(List<Invoice> invoices) {
        BillingPeriod[] billingPeriods = new BillingPeriod[invoices.size()];
        int index = 0;
        for (Invoice invoice : invoices) {
            BillingPeriod billingPeriod = new BillingPeriod();
            billingPeriod.setInvoiceId(invoice.getId());
            billingPeriod.setStartDate(invoice.getStartDate());
            billingPeriod.setEndDate(invoice.getEndDate());
            billingPeriod.setInvoiceDate(invoice.getDate());
            billingPeriods[index++] = billingPeriod;
        }
        return billingPeriods;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendPaymentReceivedEmail(Payment payment) throws Exception {
        BillingManager billingManager = Util.getBillingManager();
        BillingEngine billingEngine = billingManager.getBillingEngine("multitenancyViewingTask");
        if (payment.getInvoice() == null) {
            String msg = "Cannot send email to customer. Invoice Id is not available";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        Invoice invoice = billingEngine.getInvoice(payment.getInvoice().getId());
        if (invoice == null) {
            String msg = "Cannot send email to customer. Invoice details not available";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        Customer customer = invoice.getCustomer();
        if (customer == null) {
            String msg = "Cannot send email to customer. Customer details not available";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        HashMap<String, String> mailParameters = new HashMap<String, String>();
        mailParameters.put("date", new SimpleDateFormat("dd-MMM-yyyy").format(payment.getDate()));
        mailParameters.put("transaction-id", payment.getDescription());
        mailParameters.put("amount", payment.getAmount().toString());
        mailParameters.put("invoice-id", String.valueOf(payment.getInvoice().getId()));
        try {
            String customerName = ClaimsMgtUtil.getFirstName((RealmService)Util.getRealmService(), (int)customer.getId());
            if (customerName != null) {
                mailParameters.put("customer-name", customerName);
            } else {
                mailParameters.put("customer-name", "");
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not get tenant information for tenant: " + customer.getName() + "\n" + e.getMessage()));
            mailParameters.put("customer-name", "");
        }
        billingEngine.sendPaymentReceivedEmail(customer.getEmail(), "email-payment-received-customer.xml", mailParameters);
        String financeEmail = CommonUtil.getStratosConfig().getFinanceNotificationEmail();
        mailParameters.put("customer-name", customer.getName());
        billingEngine.sendPaymentReceivedEmail(financeEmail, "email-payment-received-wso2.xml", mailParameters);
    }
}

